# Common Operations

## Default Supported Features

By default all required supported features on POST Request will be present and set to "0" unless test define it with other value. Also it can be set to NONE is we want to test supported features not present.

## Register new user

In order to use OpenCAPIF we must add a new user. This new user can onboard/register any Invokers or Providers.

That new user **must be created by administrator** of Register Service and with the credentials shared by administrator, the new user can get the **access_token** by requesting it to Register service.

The steps to register a new user at Register Service are:

### Admin create User
1) **Login as Admin to get access_token:**

  * Send **POST** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/login**
    * **Include basic Auth Header with Admin credentials**
  * Get **access_token** and **refresh_token** from response

![Flow](../../../images/flows/01_Login_Admin.png)

2) **Create User:**

  * Send **POST** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/createUser**
    * Include Admin **access_token** in **Authorization Bearer Header**
    * Body [user_registration_body]

![Flow](../../../images/flows/02_Creation_of_user.png)

### User Retrieve access token and other information
1) **Retrieve access_token by User:**

  * Send **GET** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/getauth**
    * Include **basic Auth Header with User credentials**
  * Retrieve **access_token** and the urls needed for next requests from response body [user_getauth_response_body_example]

![Flow](../../../images/flows/03_Register_of_AEF_GetAuth.png)

## Onboard an Invoker

### Steps to perform operation
***Preconditions: The administrator must have previously registered the User.***

  1. Create public and private key at invoker
  2. Retrieve access_token by User:

    * Send **GET** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/getauth**
      * Include basic Auth Header with Admin user/password
    * Retrieve **access_token** and the urls needed for next requests from response body [user_getauth_response_body_example]

  3.  Onboard Invoker:     

     * Send **POST** to **https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers**
     * Reference Request Body: [invoker onboarding body]
     * "onboardingInformation"->"apiInvokerPublicKey": must contain public key generated by Invoker.
     * Send in Authorization Header the Bearer access_token obtained previously (Authorization:Bearer ${access_token})

### Checks to ensure onboarding

   2. Response to Get Auth:
      1. **200 OK**
      2. ***access_token*** returned.

   3. Response to Onboard request must accomplish:
      1. **201 Created**
      2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
         * apiInvokerId
         * onboardingInformation->apiInvokerCertificate must contain the public key signed.
      3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

### Example Flow
![Flow](../../../images/flows/07_Invoker_Onboarding.png)

## Register a Provider

### Steps to Perform operation
  1. Create public and private key at provider for provider itself and each function (apf, aef and amf)
  2. Retrieve access_token by User:

    * Send **GET** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/getauth**
      * Include basic Auth Header with Admin user/password
    * Retrieve **access_token** and the urls needed for next requests from response body [user_getauth_response_body_example]

  3. Register Provider:

     * Send **POST** **https://{CAPIF_HOSTNAME}/api-provider-management/v1/registrations**
     * body [provider request body]
     * Send in Authorization Header the Bearer access_token obtained previously (Authorization:Bearer ${access_token})
     * Store each cert in a file with according name.

### Checks to ensure provider registration
   1. Response to Register:
      1. **201 Created**

   2. Response to Get Auth:
      1. **200 OK**
      2. ***access_token*** returned.

   3. Register Provider at Provider Management:
      1. **201 Created** response.
      2. body returned must accomplish **APIProviderEnrolmentDetails** data structure.
      3. For each **apiProvFuncs**, we must check:
         1. **apiProvFuncId** is set
         2. **apiProvCert** under **regInfo** is set properly
      4. Location Header must contain the new resource URL **{apiRoot}/api-provider-management/v1/registrations/{registrationId}**

### Example Flow
![Flow](../../../images/flows/07_Invoker_Onboarding.png)


[user_registration_body]: ./user_registration_body.json  "User Registration Body"
[user_getauth_response_body_example]: ./user_getauth_response_body_example.json  "User GetAuth response Body Example"

[invoker onboarding body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
[invoker getauth body]: ../api_invoker_management/invoker_getauth_example.json    "Get Auth Example"

[provider request body]: ../api_provider_management/provider_details_post_example.json  "API Provider Enrolment Request"


[Return To All Test Plans]: ../README.md
