- [Downloading the project](#downloading-the-project)
  - [1. Create a folder to download the project](#1-create-a-folder-to-download-the-project)
  - [2. Download the deployment script](#2-download-the-deployment-script)
  - [3. Run the deployment script](#3-run-the-deployment-script)
- [Run All CAPIF Services locally with Docker images](#run-all-capif-services-locally-with-docker-images)
- [Run All CAPIF Services locally with Docker images and deploy monitoring stack](#run-all-capif-services-locally-with-docker-images-and-deploy-monitoring-stack)
- [Run each service using Docker](#run-each-service-using-docker)
- [Run each service using Python](#run-each-service-using-python)
- [Start Your Testing with OpenCAPIF](#start-your-testing-with-opencapif)

Capif services are developed under [services folder](https://labs.etsi.org/rep/ocf/capif/-/tree/main/services).

### Downloading the project

You can easily download CAPIF to run in local environment following next steps:

#### 1. Create a folder to download the project

```
mkdir OpenCAPIF

cd OpenCAPIF
```

#### 2. Download the deployment script

Download the deployment / environment preparation script:


```
wget https://labs.etsi.org/rep/ocf/capif/-/raw/staging/deploy.sh
```

Make it executable:

```
chmod +x deploy.sh
```

#### 3. Run the deployment script

This script selects the branch for capif repository project to pull from.

If you run the script without selecting a branch the the main branch is going to be selected.

We recommend:

* **main** branch for the most stable experience and **staging** branch for an experience with the latest features (for staging branch installation, it is strongly advisable that you may as well follow the staging documentation)

```
# ./deploy.sh [branch to fetch] [true or false (default) to install monitoring stack or not]

sudo ./deploy.sh staging
```


> **We recommend running the deploy.sh script with root permissions! In other case, some directories may not be accessible by the project building tools and hinder the smooth installation.**

### Run All CAPIF Services locally with Docker images
To run using docker and docker compose, version 2.10 or higher, you must ensure you have those tools installed in your machine. Also to simplify the process, we have 3 scripts allowing docker images to deploy, check and cleanup.

All these scripts are available under ***services*** directory.

To run CAPIF APIs locally using docker and docker-compose you can use run.sh script:
```
./run.sh -h

Usage: ./run.sh <options>
       -c : Setup different hostname for capif
       -m : Launch monitoring service
       -h : show this help
```
This script builds and runs all services using docker images, including mongodb and nginx locally and in the background, and imports ca.crt to nginx. By default monitoring is not activated and Nginx is deployed use **capifcore** as a hostname. 

Some examples of use:
```
# Default values, No monitoring and capifcore as CAPIF_HOSTNAME
./run.sh

# opencapif.etsi.org as CAPIF_HOSTNAME
./run.sh -c opencapif.etsi.org

# opencapif.etsi.org as CAPIF_HOSTNAME and monitoring activated
./run.sh -c opencapif.etsi.org -m 

```

If you want to check if all CAPIF services are running properly in a local machine after executing run.sh, you can use:
```
./check_services_are_running.sh
```
This shell script will return 0 if all services are running properly.

When we need to stop all CAPIF services, we can use next bash script:
```
./clean_capif_docker_services.sh -a
```

NOTE: You can use different flags if you only want to stop some of them, please check the help using
```
./clean_capif_docker_services.sh -h

Usage: clean_capif_docker_services.sh <options>
       -c : clean capif services
       -v : clean vault service
       -r : clean register service
       -m : clean monitoring service
       -a : clean all services
       -h : show this help
```

This shell script will remove and clean all CAPIF services started previously with run.sh

On the other hand you can check logs using show_logs.sh script, please check options:
```
./show_logs.sh
You must specify an option when running the script.
Usage: ./show_logs.sh <options>
       -c : Show capif services
       -v : Show vault service
       -r : Show register service
       -m : Show monitoring service
       -a : Show all services
       -f : Follow log output
       -h : Show this help
```
You can also use option -f in order to follow log output in real time

### Run All CAPIF Services locally with Docker images and deploy monitoring stack
It is now possible to deploy a monitoring stack for CAPIF with Grafana, Prometheus, FluentBit, Loki, Cadvisor, Tempo and Opentelemetry.

To deploy CAPIF together with the monitoring stack, it is only necessary to execute the following.

```
./run.sh -m true
```

After they have been built, the different panels can be consulted in Grafana at the url

```
http://localhost:3000
```

By default, the monitoring option is set to false. Once up, all data sources and dashboards are automatically provisioned.

### Run each service using Docker

Also you can run OpenCAPIF service by service using docker:
```
cd <Service>
docker build -t capif_security .
docker run -p 8080:8080 capif_security
```

### Run each service using Python

Run using python
```
cd <Service>
pip3 install -r requirements.txt
python3 -m <service>
```

#### Start Your Testing with OpenCAPIF

Related with OpenCAPIF Testing, the following sections help you to understand testing implemented and how to run it by yourself:

- [Test Plan Directory]: Here you can find the complete test plan definition that are accomplish by all versions released of OpenCAPIF.
- [Testing with Robot Framework]: At this section you can find all information about how to run the test suite implemented using Robot Framework.
- [Testing with Postman]: Easy way to understand the complete basic OpenCAPIF flow, acting as invoker and provider.


[Test Plan Directory]: .././testing/testplan/README.md  "Test Plan"
[Testing with Robot Framework]: .././testing/robotframework/README.md  "Robot Framework"
[Testing with Postman]: .././testing/postman/README.md  "Postman"
