# Invoker and Provider CLI
The Invoker and provider CLIs serve as examples for developers and integrators looking to connect their Network Applications (NetApps) to CAPIF. They demonstrate, using Python, how to develop the necessary code for seamless communication with CAPIF, offering a practical guide to implementing the required API calls and interactions.

## Provider CLI
When using the Provider Console, users can create a provider entity that registers and publishes APIs to make them available within the CAPIF ecosystem. This process begins with user registration, where a unique user account is associated with the provider. Once registered, the user gains the ability to define and expose APIs, specifying the necessary details and configurations to allow other clients to discover and interact with them. 

Check [Provider CLI](https://labs.etsi.org/rep/ocf/example-clients/provider-cli) for further information.

## Invoker CLI
The Invoker Console complements this by offering tools to explore and consume the APIs registered by providers. An invoker can perform a discovery request, a critical step that enables browsing available APIs in CAPIF. This feature ensures that consumers can find the services they need based on specific criteria or search parameters. After discovering an API, the next step is to establish a secure communication channel. The console allows users to request the creation of a security context, providing the necessary token that authorizes API consumption. This security framework ensures that interactions comply with OpenCAPIF’s authentication and authorization protocols. 

Check [Invoker CLI](https://labs.etsi.org/rep/ocf/example-clients/provider-cli) for further information.

## Other console features
Beyond the core functionalities of API publication and consumption, the consoles include advanced management options to enhance the user experience and provide comprehensive control over API lifecycles. Users can unpublish APIs when they are no longer needed, effectively removing them from discovery and usage. Furthermore, the consoles support deleting both providers and invokers, offering flexibility in maintaining a clean and organized service architecture. For enhanced adaptability, the system also includes subscription capabilities, enabling users to subscribe to events and receive notifications about changes or updates related to specific APIs.

[OCF Web]: https://ocf.etsi.org/ "OCF Web"
[OCF Documentation]: https://ocf.etsi.org/documentation/ "OCF Documentation"
