# Test Plan for API Status Feature
At this documentation you will have all information and related files and examples of test plan for this feature.

## Test Case 1: Publish without apiStatus feature receive eventDetails with serviceAPIDescription

**Test ID**: ***api_status-1***

**Description**:

  This test case will check if an invoker subscribed to events **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE**, with ***apiStatusMonitoring*** and ***Enhanced_event_report*** active, receive SERVICE_API_AVAILABLE in mockserver when api is published by a provider, containing apiIds and serviceAPIDescription at eventDetails, and the same when api is unpublished.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered with 2 aefs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:
  1. Register Invoker and Onboard Invoker at CCF.
  2. Subscribe to **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE**. ***Enhanced_event_report*** and ***apiStatusMonitoring*** **active** at supported features (binary 1100-> string **C**)
  3. Register Provider at CCF with 2 aefs.
  4. Publish Service API at CCF:
     1. Supported Features with apiStatusMonitoring flag inactive (binary 0 0000 0000 -> string **000**)
     2. This API not includes "API Status" information at **service API Description**.
  5. Discover Service APIs by Invoker
     1. includes filter by query parameter **aef-id**
  6. Provider remove published API.

**Information of Test**:

  1. Perform [Invoker Onboarding]
  2. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
       1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
       2. body [event subscription request body] with:
          1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE']**
          2. supportedFeatures: binary 1100 -> string **C**
       3. Use **Invoker Certificate**
  3. Perform [Provider Registration] with 2 aefs
  4. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with **service_1** and **service_2** apiNames and realted with aefId1 and aefId2.
       * supportedFeatures **000**
       * 2 profiles, one with each aef.
     * Use **APF Certificate**
  5. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**
  6. Remove published Service API:
     * Send **DELETE** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  3. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
        * 2 profiles with:
          * apiName service_1 and aefId1
          * apiName service_2 and aefId2
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response without **"apiStatus"** parameter.
  4. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if **NOT** contains the **apiStatus** keys
  5. Response to Remove published Service API at CCF:
     1. **204 No Content**
  6. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE** apiId of published API with **eventDetails** containing **apiIds** and **serviceAPIDescription** parameters.
        2. The other one must be **SERVICE_API_UNAVAILABLE** apiId of published API with **eventDetails** containing **apiIds** and **serviceAPIDescription** parameters.


   [service api description]: ../api_publish_service/service_api_description_post_example.json  "Service API **Description** Request"
   [publisher register body]: ../api_publish_service/publisher_register_body.json  "Publish register Body"
   [invoker onboarding body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
   [provider request body]: ../api_provider_management/provider_details_post_example.json  "API Provider Enrolment Request"
   [provider request patch body]: ../api_provider_management/provider_details_enrolment_details_patch_example.json  "API Provider Enrolment Patch Request"

   [invoker onboarding]: ../common_operations/README.md#onboard-an-invoker "Invoker Onboarding"
   [provider registration]: ../common_operations/README.md#register-a-provider "Provider Registration"
   [event subscription request body]: ../api_events_service/event_subscription.json  "Event Subscription Request"
