## **Release 2.0.0**

### **New Features**

#### 3GPP CAPIF release 18

- New endpoints included in new release 18 with new logic.
- New logic to support ***Vendor Extensibility*** on Publish and Discover Service.
- New logic to support ***API Status*** feature on Publish and Events Services.
- Supported Features now are mandatory for all POST and PUT Requests as is described on TS 29.222.
    - **Possible Breaking change**, all POST request now must include supported features attribute, default can me set to "0" to keep all features inactive.
    - **Possible Breaking change** on Events API, if you need eventDetails information on notification you must activate **Enhanced Event Report** feature by setting properly the supported features flag.

### **Technical Debt Solved**

#### **Vendor Extensibility feature**

- Publish API:
    - On publishing a service API, **SupportedFeatures** is read and checked whether VendExt feature is enabled.
    - When VendExt is enabled, vendor-specific fields are searched and stored in the db inside the ServiceAPIDescription object
    - Vendor-specific fields are added according to the specific format:
    ```
    "vendorSpecific-urn:<organization>:<field name>": {
        "key1": "value1",
        ...
        "keyN": "valueN",
    }
  
    e.g. 
    "vendorSpecific-urn:etsi:mec:capifext:transport-info": {
        "name": "trasport1",
        "description": "Transport Info 1",
        "type": "REST_HTTP",
        "protocol": "HTTP",
        "version": "2",
        "security": {
            "grantTypes": "OAUTH2_CLIENT_CREDENTIALS",
            "tokenEndpoint": "https://token-endpoint/"
        }
    }
  
    where organization is "etsi:mec" and field name "capifext:transport-info"
    ```

- Discover API:
    - On Discover request **SupportedFeatures** is read and checked whether VendSpecQueryParams feature is enabled.
    - When VendSpecQueryParams is enabled, vendor-specific query parameters are parsed
    - Vendor specific query parameters are added on the GET request according to the following format:
    ```
    https://{{CAPIF_HOSTNAME}}:{{CAPIF_PORT}}/{{DISCOVER_URL}}?
           ...
           vend-spec-<query parameter name>={
              "target": <string that contains the JSON pointer to the attribute in the resource representation>, 
              "value": <query parameter value>
    }
  
    e.g. 
    https://{{CAPIF_HOSTNAME}}:{{CAPIF_PORT}}/{{DISCOVER_URL}}?
           ...
           vend-spec-type={
              "target": "/vendorSpecific-urn:etsi:mec:capifext:transport-info", 
              "value": "REST_HTTP"
    }
    ```

#### **Api Status feature**

- Events API:
    - Event internal notifications between services improved to accomplish specification.
    - On event subscription **SupportedFeatures** is read and stored in db to accomplish specification.
    - Also **SupportedFeatures** is checked before send event notification, in order to accomplish specification, sending **eventDetails** and related information according to ***enhanced_event_report*** and ***apiStatusMonitoring*** supported features activated.

#### **Issues**

- Solved issue to get ready REDIS on deployment: REDIS scheduled on start to allow receive notification since service is deployed.
- Solved problem removing service APIs published is provider register more than one APF.
- Solved Superadmin problem deleting service API published through helper service if provider is not present.
- Increased the overall stability, fixing some corner cases.
- Location headers now are filled in same way at all services that needs it.
- Security issues solved.
- Base docker images present on ETSI registry.
- Robot image uploaded to ETSI Registry.

#### Local Scripts

- All scripts were reviewed and improved.
- New scripts to manage users on local deployment added:
  - create_users.sh: helps developer to create new users in local deployment.
  - remove_users.sh: helps developer to remove users from db in local deployment.

#### Remote Scripts

New scripts developed to help on remote deployment, configuration and testing. All this script are stored under helm/scripts in capif repository.

***variables.sh*** contains all configuration that will be used on remote operation. This file must be filled carefully before run remote scripts.

- Deployment Scripts:
    - ***install_vault.sh***: Deploy Vault component from k8s cluster, only needed if vault is not previously deployed. If it’s deployed you can setup vault token on variables.sh.
    - ***install_monitoring.sh***: Deploy monitoring on k8s cluster.
    - ***install_capif.sh***: Deploy OpenCAPIF on k8s cluster. It will be deployed on configured namespace with domain and hostnames configured under variables.sh.
    - ***uninstall_vault.sh***: Rollback Vault component from k8s cluster.
    - ***uninstall_monitoring.sh***: Rollback monitoring components from k8s cluster.
    - ***uninstall_capif.sh***: Rollback OpenCAPIF from k8s cluster.

- Manage remote users:
    - ***create_remote_users.sh***: This script create users setup by parameters on deployed OpenCAPIF. Those users are created by administrator.
    - ***remove_remote_users.sh***: This script removes user from deployed OpenCAPIF.
    - ***remove_remote_users_by_prefix.sh***:: This script removes users by prefix.

- Configuration of bastion machine, this simplify DNS fixed resolution:
    - ***get_ingress.sh***: This create a configuration for dns fixed resolution for ingress configured in namespace passed by parameters.
    - ***set_ingress.sh***: This scripts adds to /etc/hosts the fixed DNS resolution for ingress setup for  namespace passed by parameters.

- Execute robot tests over remote deployment.
    - ***run_remote_capif_tests.sh***: This scripts launch Robot Test docker image on current machine to reach deployed OpenCAPIF. Is useful to launch with “--include smoke” in order to ensure all is deployed properly.

- Just for testing, next scripts upload dummy information to deployed OpenCAPIF:
    - ***populate_create_remote_dummy_users.sh***: : Create Dummy providers and invokers, publish service APIs and creates security context for invokers.
    - ***populate_remove_remote_dummy_users.sh***: Remove dummy information created.


### **Documentation**

#### New test included on documentation

- New Vendor Extensibility test suite with 9 tests. [Api Events Service](./testing/testplan/vendor_extensibility/README.md)
- New [API Status feature](./testing/testplan/api_status/README.md) test suite.
- Improved [Events test suite](./testing/testplan/api_events_service/README.md) with 8 new tests.
- Test plan updated with default supported features for all request set to "0" (all inactive by default) [See common operations](./testing/testplan/common_operations/README.md).

---

## **Release 1.0.0**

### **New Features**

#### Registration Flow improved

- Eliminated access from CAPIF to the Register user database when onboarding is performed.
- Isolation between CCF and Register services, interaction now is only by HTTPS requested between Register, CCF and Vault.
- Eliminated the "role" in user creation.
    - Now a user can be an invoker or a provider at the same time
- Administrator User:
    - New entity in charge of registering and managing users of the register service.
- UUID to identify users.
    - When you create a user, a uuid is associated with it
    - The uuid will be contained in the token requested by the user and will be used to relate invokers and providers with users.
- Endpoints changed and created:
    - Administrator endpoints:
        - /createUser: /register endpoint changed to createUser. Used to register new users.
        - /deleteUser: /remove endpoint changed to this. Used to delete users and all the entities they had created.
        - /login: Allows administrator to log in to obtain the necessary tokens for their requests.
        - /refresh: Retrieve new access token token.
        - /getUsers: Returns the list with all registered users.
    - Customer User:
        - /getauth now also returns the urls needed to use CAPIF, used by customer.
- Security improvements:
    - /login uses basic auth with administrator credentials.
    - /getauth uses basic auth with customer user credentials.
    - Other requests use the administrator access token obtained from login.

- Current fields on user creation by administrator:
```
required_fields = {
    "username": str,
    "password": str,
    "enterprise": str,
    "country": str,
    "email": str,
    "purpose": str
}

optional_fields = {
    "phone_number": str,
    "company_web": str,
    "description": str
}
```

- Test plan has been updated with the new register flow. Please check [OCF Registration Flow]
- Video with explanation and demonstration of new register flow [New Registration Demo]

#### New OpenCAPIF architecture

- New arquitecture with separated namespaces for Vault, CCF and Register components. Communication between them now are only allowed by using REST APIs.
- New helper service inside CCF, it will simplify integration with third parties like external management portals.

- Helper endpoints:
    - /getInvokers : Get the list of invokers from CAPIF
    - /getProviders: Get the list of providers from CAPIF
    - /getServices : Get the list of services published in CAPIF
    - /getSecurityContext : Get the list of security contexts from CAPIF
    - /getEvents : Get the list of events subscriptions from CAPIF
    - /deleteEntities: Removes all entities registered by a user from the register

- Security in the helper
    - To make requests to the helper you will need a superadmin certificate and password.

#### Events API Upgrade

- The event management at CCF is improved, EventNotification include Event Details with required information.
- Events updated:
    - SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE with apiIds
    - SERVICE_API_UPDATE with serviceAPIDescriptions
    - API_INVOKER_ONBOARDED, API_INVOKER_UPDATED, API_INVOKER_OFFBOARDED with apiInvokerIds.
- Events Included:
    - SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE with invocationLogs
- Test plan include 7 new tests in order to check new events implemented and scenarios of each notification implemented, with a complete check of Event Notification.
- Test plan documentation includes the new event tests [OCF Event test plan documentation].

#### Inital implementation of CI/CD

- The inital implementation of CI/CD on gitlab was performed.
- Detailed information in the [CICD Wiki].
- Implement initial CI/CD:
    - Description of the CI process.
        - In CI phase, created design, jobs and security checks when a branch is pushed.
        - The CI has jobs as:
            - Linting code, unit test (if needed),
            - Build and push artifacts (images) in Git OCI register
            - Security checks,
            - SCA, CVS, SAST
            - The vulnerabilities are exposed in Merge Request panel to be solved.
    - Description of the CD process:
        - Defined the environments to OCF.
            - Production env.
            - Pre-production env.
            - Validation env.
            - Dev-1, dev-2… envs (ephemeral)
        - Defined the naming convention to OCF releases
            - Tag in prod: v0.0.1-release
            - Tag non-prod: v0.0.1-rc
            - Other tags: v0.0.1-test, v0.0.1-smt
        - Defined the jobs of CD
            - CD ensures the deployment in multiple envs. Therefore, the CD pipeline has deploy-ocf, delete-ocf (if needed) jobs
    - ETSI HIVE Labs:
        - Designed, created and the Kuberntes OCF cluster is running to support OCFs deployments.
        - Iterating with ETSI HIVE’s support to solve computing issues.
            - CPU compatibilities with OCF services (MongoDB): Fixed


### **Documentation**

#### Improvements on documentation

- Documentation stored in [OCF Documentation Repository]
- Continuous Integration included at repository for web documentation:
    - Develop version of documentation is automatically generated on each merge to develop branch.
    - Tagged version from main create documentation with related tag as version.

### **Technical Debt Solved**

#### Improved Testing with Robot in order to cover

- Support of new Register flows.
- Allow different URLs for register, ccf and vault services.
- New Variables included to manage new architecture under test.
- Mock server developed to add the functionality of write tests involving notification from Service Under Test.
- Docker image improved generation and libraries upgraded to Robot Framework 7.

#### Improved security on DB

- Credentials requested to access mongo databases.
- Credentials requested also by mongo-express.

#### Scripts upgraded

- Docker compose version 2 used on them.
- New cleaning script developed.
- Scripts upgraded:
    - **check_services_are_running.sh**: Checks if all essential services (Vault, CCF and Register) are running.
    - **clean_capif_docker_services.sh**: Shutdowns and removes all services essential services.
    - **clean_capif_temporary_files.sh**: Removes temporaly files from local repository. 
    - **run.sh**: Launch Essential services locally using docker compose, also monitoring can be launched.
    - **run_capif_tests.sh**: Launch Robot Framwork Tests.
    - **show_logs.sh**: Show locally logs of Services running.
    - **run_mock_server.sh**: Launch mock server locally on all interfaces. This axiliary server is only used by tagged mockserver tests on Robot Framework.
    - **clean_mock_server.sh**: Remove mock server local deployment.
    - **deploy.sh**: This script simplify the way to download capif repository.

#### Codebase Improvements

- Documentation is now on splitted repository [OCF Documentation Repository]
- Test plan was moved to [OCF Documentation Repository]
- Obsolote data is removed.
- Repository Reorganization: Enhanced structure and maintainability with a better directory layout and clearer module separation.
- Code Quality Enhancements: Refactored code and fixed known issues

#### Migration to GUNICORN

- Include production server on each microservice: Release 0 use Flask developer server, now we use GUNICORN.

---

## **Release 0.0**

The APIs included in Release 0.0 are:

- JWT Authentication APIs
- CAPIF Invoker Management API
- CAPIF Publish API
- CAPIF Discover API
- CAPIF Security API
- CAPIF Events API
- CAPIF Provider Management API

This Release also includes a Robot Test Suite for all those services and a Postman Test Suite for simple testing.


[OCF Documentation Repository]: https://labs.etsi.org/rep/ocf/documentation "OCF Documentation Repository"
[OCF Event test plan documentation]: https://ocf.etsi.org/documentation/latest/testing/testplan/api_events_service/ "OCF Event test plan documentation"
[OCF Registration Flow]: https://ocf.etsi.org/documentation/latest/testing/testplan/common_operations/ "OCF Registration Flow"
[New Registration Demo]: https://www.youtube.com/watch?v=sn-tN6eRvv8 "New Registration Demo"
[CICD Wiki]: https://labs.etsi.org/rep/ocf/community/-/wikis/OCF-CICD "CI/CD Wiki"
[Upgrade Release 17 to 18 Wiki]: https://labs.etsi.org/rep/ocf/community/-/wikis/?¿?¿?¿?¿?   "Upgrade Release 17 to 18 Wiki"
