<img src="images/logos/OpenCAPIF.png" alt="drawing" width="200"/>

# Release X.X.X-rc

This release includes next changes:

**New register flow to ensure:**

  - isolation between CCF and Register services.
  - Improve security, with split resposability between administrator operations and common user.

**Improved Testing with Robot in order to cover:**

  - New Register flows.
  - Allow different URLs for register, ccf and vault services.

**Improved security on DB:**

  - Credentials requested to access mongo databases.
  - Credentials requested also by mongo-express.

**Scripts upgraded:**

  - docker compose version 2 used on them.
  - New cleaning script developed.

**Cleanup of capif repository:**

  - Documentation is now on splitted repository [OCF Documentation Repository]
  - Test plan was moved to [OCF Documentation Repository]
  - Obsolote data is removed.


# Release 0.0

The APIs included in Release 0.0 are:

- JWT Authentication APIs
- CAPIF Invoker Management API
- CAPIF Publish API
- CAPIF Discover API
- CAPIF Security API
- CAPIF Events API
- CAPIF Provider Management API

This Release also includes a Robot Test Suite for all those services and a Postman Test Suite for simple testing.

## What is OpenCAPIF?

OpenCAPIF is an open source implementation of the CAPIF Core Function APIs plus the logic and additional services required to fulfill the 3GPP requirements and deliver the expected functionality.

CAPIF is the “Common API Framework” defined by 3GPP to manage the APIs exposed by 3GPP networks in their northbound interfaces.

3GPP specifications for CAPIF defines three types of entities:

* API Providers, which are the entities exposing APIs (e.g., NEF)
* API Invokers, which are the entities that consume APIs (e.g., Applications), and
* the CAPIF Core Function, which manages the relationships between the other two.

![CAPIF Core Function](./images/architecture/CAPIF_Core_Function.png "CAPIF Core Function")

The CAPIF Core Function is the cornerstone of the Common API Framework and provides the following capabilities:

* Authenticating the API Invoker based on its identity and other information;
* Supporting mutual authentication with the API Invoker;
* Providing authorization for the API Invoker prior to accessing the exposed APIs;
* Publishing, storing, and supporting the discovery of service APIs information;
* Controlling the service API access based on PLMN operator configured policies;
* Storing the logs for the service API invocations and providing the service API invocation logs to authorized entities;
* Charging based on the logs of the service API invocations;
* Monitoring the service API invocations;
* Onboarding a new API Invoker and offboarding an API Invoker;
* Storing policy configurations related to CAPIF and service APIs;
* Support for accessing the logs for auditing (e.g., detecting abuse); and
* Support for publishing and discovery of service APIs information among CAPIF Core Function (CAPIF interconnection).

The following diagram shows how API Invokers and API Providers interact with the CAPIF Core Function to Register in CAPIF, Publish APIs, Discover APIs and Consume APIs. It is important to highlight that the CAPIF Core Function is not a classical API Gateway. The API consumption takes place directly between the API Invoker and the API Provider. Therefore, CAPIF does not impact API performance in API consumption between API Invokers and API Providers.

![Flow](./images/architecture/msg_flow.png "Flow")

If you want to know more about OpenCAPIF check [The story behind openCAPIF](https://ocf.etsi.org/news/20240110_the_story_behind_opencapif/)


## Repository structure

You can check the code at [OpenCAPIF Repository]

```
CAPIF_API_Services
└───helm
└───monitoring
└───services
└───tests
└───tools
    └───robot
    └───open_api_script
```
* **helm**: This folder contains helm files to deploy capif under k8s environment.
* **monitoring**: This folder contains grafana helm files to deploy capif under k8s environment.
* **services**: Services developed following CAPIF API specifications. Also, other complementary services (e.g., NGINX and JWTauth services for the authentication of API consuming entities).
* **tools**: Auxiliary tools. Robot Framework related code and OpenAPI scripts.
* **test**: Tests developed using Robot Framework.

## CAPIF_API_Services

This repository has the python-flask Mockup servers created with openapi-generator related with CAPIF APIS defined here:
[Open API Descriptions of 3GPP 5G APIs]


## How to test CAPIF APIs

The above APIs can be tested either with POSTMAN tool or running the developed tests with Robot Framework.

## Test Plan Documentation

Complete documentation of tests is available here: [Test Plan Directory]

## Robot Framework

In order to ensure that modifications over CAPIF services still fulfills the required functionality, the Robot Framework Test Suite must be successfully run.

The Robot Test Suite covers the requirements described in the test plan at [Test Plan Directory] folder.

Please check the [Testing with Robot Framework] Section

## Using PostMan

You can also test the CAPIF flow using the Postman tool. To do this, we have created a collection with some examples of CAPIF requests with everything necessary to carry them out.

For more information on how to test the APIs with POSTMAN, go to this [POSTMAN Section].

## Important urls:

## Mongo CAPIF's DB Dashboard
```
http://localhost:8082/ (if accessed from localhost) 

or

http://<Mongo CAPIF Express Host IP>:8082/ (if accessed from another host)
```

## Mongo Register's DB Dashboard
```
http://localhost:8083/ (if accessed from localhost) 

or

http://<Mongo Register Express Host IP>:8083/ (if accessed from another host)
```

## FAQ Documentation

Frequently asked questions can be found here: [FAQ Section]






[Test Plan Directory]: ./testing/testplan/README.md  "Test Plan Directory"
[Testing with Robot Framework]: ./testing/robotframework/README.md  "Testing with Robot Framework"
[FAQ Section]: ./FAQ.md "FAQ Section"

[Open API Descriptions of 3GPP 5G APIs]: https://forge.3gpp.org/rep/all/5G_APIs  "Open API Descriptions of 3GPP 5G APIs"
[OpenCAPIF Repository]: https://labs.etsi.org/rep/ocf/capif "OpenCAPIF Repository"
[POSTMAN Section]: ./testing/postman/README.md "POSTMAN Section"
[OCF Documentation Repository]: https://labs.etsi.org/rep/ocf/documentation "OCF Documentation Repository"