This section provides users with essential details to interact with the OpenCAPIF Sandbox, including endpoint URLs, example requests, and client implementation references.

## Public Sandbox URLs
Below are the key endpoints required for API interactions within the sandbox environment:

- **Registration Service**: `https://register-opencapif.etsi.org`
- **OpenCAPIF Service**: `https://opencapif.etsi.org`

## Postman collection and flows
To facilitate API testing and integration, we provide example requests that can be used in Postman:

- **[Postman Collection for OpenCAPIF](../testing/postman/README.md)**: A ready-to-use collection with predefined requests to interact with the sandbox APIs including flows.

## Example Client Implementations
For users who wish to integrate OpenCAPIF into their applications, we provide [invoker and provider example](../example-clients/example-clients.md) clients:

- **Invoker Client**: [invoker-cli Repository](https://labs.etsi.org/rep/ocf/example-clients/invoker-cli)
- **Provider Client**: [provider-cli Repository](https://labs.etsi.org/rep/ocf/example-clients/provider-cli)

These resources are continuously updated to align with the latest OpenCAPIF developments, ensuring users have access to functional and relevant examples.

## Disclaimer
The OpenCAPIF Sandbox is a temporary and non-persistent testing environment. Any data stored within the sandbox is not backed up and may be periodically cleaned or reset without prior notice. Users should not store critical or long-term data in this environment. Always ensure that any necessary backups are maintained externally.
