# Invoker and Provider CLIs
The Invoker and Provider CLIs serve as examples for developers and integrators looking to connect their Network Applications (NetApps) to CAPIF. 

They demonstrate, using Python, how to develop the necessary code for seamless communication with CAPIF, offering a practical guide to implementing the required API calls and interactions.

## Provider CLI
When using the Provider Console, users can create a provider entity that registers and publishes APIs to make them available within the CAPIF ecosystem. 

With the provider console you can make the following requests to CAPIF:

- provider_get_auth - to request the token and CA cert to be able to perform the onboarding
- register_provider - to perform the onboarding of a provider
- publish_service - to publish an api as a provider
- get_services - to see what services the provider has published
- register_events - to register for events
- remove_service - to unpublish an api
- remove_provider - to remove the provider

Apart from these operations, with the provider console you can also perform operations as administrator if you have a CAPIF locally:

- login_admin - to obtain the tokens needed to perform admin operations
- refresh_admin - to refresh the admin token
- register_user - to create a user in CAPIF
- remove_user - to delete a CAPIF user

Additionally, it also contains an API example that contains everything needed to verify the token used by invokers in API requests.

Check [Provider CLI](https://labs.etsi.org/rep/ocf/example-clients/provider-cli) for further information.

## Invoker CLI
Using the Invoker console, users can create their own invoker to discover the APIs published in CAPIF and perform all the necessary actions to be able to consume them.

With the Invoker console you can make the following requests to CAPIF:

- get_auth - to request the token and CA cert to be able to perform the onboarding
- register_invoker - to perform the onboarding of an invoker
- discover_service - to discover the APIs published in CAPIF
- register_security_context - to make the request to create a security context
- get_security_auth - to request the token necessary for the consumption of an API
- call_service - to consume an api
- register_events - to register for events
- remove_security_context - to delete the created security context
- remove_invoker - to remove the invoker

Apart from these operations, with the invoker console you can also perform operations as administrator if you have a CAPIF locally:

- login_admin - to obtain the tokens needed to perform admin operations
- refresh_admin - to refresh the admin token
- register_user - to create a user in CAPIF
- remove_user - to delete a CAPIF user

With these requests you can easily perform the basic flow as a CAPIF Invoker

Check [Invoker CLI](https://labs.etsi.org/rep/ocf/example-clients/provider-cli) for further information.

[OCF Web]: https://ocf.etsi.org/ "OCF Web"
[OCF Documentation]: https://ocf.etsi.org/documentation/ "OCF Documentation"
