<img src="../images/logos/OpenCAPIF.png" alt="drawing" width="200"/>

# **Architecture**

The CAPIF architecture has three main components, Register Service, Vault and CCF, which are represented in the following image:

![New Architecture](./images/architecture/New_Architecture.png)

Each component is separated into different namespaces and all communications between them use Rest APIs.

Apart from the communication between components, there are 2 other entities that can use them:

- **Admin/superadmin**: Responsible for managing users with the Register or carrying out special operations in the CCF.
- **Users**: They are those who want to use CAPIF, registering as a user in the Register and as Invoker or Provider in the CCF.

## **Register NS**

This namespace belongs to the Register service, and we find 2 components:

- **Register Service**: It is responsible for managing all users who use CAPIF, in addition to providing the necessary information for its use.
- **Register MONGO DATABASE**: It is the Register database, in it we store all the information about registered users.

## **Vault NS**

This namespace belongs to Vault. 

This component is responsible for managing all CAPIF certificates, so other components such as the Register or the CCF communicate with it to create new certificates or request keys.

## **Mon NS**

This is the main namespace of CAPIF, since it contains all the CCF services in addition to other components:

- **NGINX**: Responsible for acting as a reverse proxy to distribute CAPIF requests to the different services, controlling whether or not they are authorized to access them.
- **REDIS**: Used for internal communication of services.
- **CAPIF MONGO DATABASE**: CAPIF database, where all information related to CAPIF services such as invokers, registered providers or published services is stored.
- **HELPER**: Service that simplifies integration with third parties such as external management portals.
