# Test Plan for CAPIF Api Invoker Management
At this documentation you will have all information and related files and examples of test plan for this API.

## Test Case 1: Onboard NetApp

**Test ID**: ***capif_api_invoker_management-1***

**Description**:

  This test will try to register new NetApp at CAPIF Core.

**Pre-Conditions**:

  * NetApp was not registered previously
  * NetApp was not onboarded previously
  * ***Preconditions: The administrator must have previously registered the User.***

**Information of Test**:

  1. Create public and private key at invoker

  2. Retrieve access_token by User:

    * Send **GET** to **https://${CAPIF_REGISTER}:${CAPIF_REGISTER_PORT}/getauth**
      * Include basic Auth Header with Admin user/password
    * Retrieve **access_token** and the urls needed for next requests from response body [user_getauth_response_body_example]

  3. Onboard Invoker:
     * Send POST to *https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers*
     * Reference Request Body: [invoker onboarding body]
     * "onboardingInformation"->"apiInvokerPublicKey": must contain public key generated by Invoker.
     * Send at Authorization Header the Bearer access_token obtained previously (Authorization:Bearer ${access_token})

**Execution Steps**:

  1. Retrieve access_token by User from register
  2. Onboard Invoker at CCF
  3. Store signed Certificate
   
**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*


## Test Case 2: Onboard NetApp Already onboarded

**Test ID**: ***capif_api_invoker_management-2***

**Description**:

  This test will check second onboard of same NetApp is not allowed.

**Pre-Conditions**:

  * NetApp was registered previously
  * NetApp was onboarded previously

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Repeat Onboard Invoker:
     * Send POST to *https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers*
     * Reference Request Body: [invoker onboarding body]
     * "onboardingInformation"->"apiInvokerPublicKey": must contain public key generated by Invoker.
     * Send at Authorization Header the Bearer access_token obtained previously (Authorization:Bearer ${access_token})

**Execution Steps**:

  1. Register NetApp at CCF
  2. Onboard NetApp at CCF
  3. Store signed Certificate at NetApp
  4. Onboard Again the NetApp at CCF
  
**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*
  2. Response to Second Onboard of NetApp must accomplish:
     1. **403 Forbidden**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 403
        * title with message "Forbidden"
        * detail with message "Invoker Already registered".
        * cause with message "Identical invoker public key".


## Test Case 3: Update Onboarded NetApp  

**Test ID**: ***capif_api_invoker_management-3***

**Description**:

  This test will try to update information of previous onboard NetApp at CAPIF Core.

**Pre-Conditions**:

  * NetApp was registered previously
  * NetApp was onboarded previously with {onboardingId}
  
**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Update information of previously onboarded Invoker:
     * Send PUT to *https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers/{onboardingId}*
     * Reference Request Body is: [put invoker onboarding body]
       * "notificationDestination": "*http://host.docker.internal:8086/netapp_new_callback*",

**Execution Steps**:
  
  1. Register Invoker at CCF
  2. Onboard Invoker at CCF
  3. Store signed Certificate
  4. Update Onboarding Information at CCF with a minor change on "notificationDestination"
   
**Expected Result**:
  
  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*
  2. Response to Update Request (PUT) with minor change must contain:
     1. **200 OK** response.
     2. notificationDestination on response must contain the new value


## Test Case 4: Update Not Onboarded NetApp

**Test ID**: ***capif_api_invoker_management-4***

**Description**:

  This test will try to update information of not onboarded NetApp at CAPIF Core.

**Pre-Conditions**:

  * NetApp was registered previously
  * NetApp was not onboarded previously
  
**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Update information of not onboarded Invoker:
     * Send PUT to *https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers/{INVOKER_NOT_REGISTERED}*
     * Reference Request Body is: [put invoker onboarding body]

**Execution Steps**:
  
  1. Register Invoker at CCF
  2. Onboard Invoker at CCF
  3. Update Onboarding Information at CCF of not onboarded
   
**Expected Result**:
  
  1. Response to Onboard request must accomplish:
     1. **201 Created**
  2. Response to Update Request (PUT) must contain:
     1. **404 Not Found**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * title with message "Not Found"
        * detail with message "Please provide an existing Netapp ID".
        * cause with message "Not exist NetappID".



## Test Case 5: Offboard NetApp

**Test ID**: ***capif_api_invoker_management-5***

**Description**:

  This test case will check that a Registered NetApp can be deleted.

**Pre-Conditions**:

  * NetApp was registered previously
  * NetApp was onboarded previously

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Offboard:
     * Send Delete to *https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers/{onboardingId}*

**Execution Steps**:

  1. Register Invoker at CCF
  2. Onboard Invoker at CCF
  3. Offboard Invoker at CCF
   
**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
  2. Response to Offboard Request (DELETE) must contain:
     1. **204 No Content**


## Test Case 6: Offboard Not previsouly Onboarded NetApp

**Test ID**: ***capif_api_invoker_management-6***

**Description**:

  This test case will check that a Non-Registered NetApp cannot be deleted

**Pre-Conditions**:

  * NetApp was registered previously
  * NetApp was not onboarded previously

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Offboard:
     * Send Delete to *https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers/{INVOKER_NOT_REGISTERED}*

**Execution Steps**:

  1. Register Invoker at CCF
  2. Offboard Invoker at CCF

**Expected Result**:

  1. Response to Offboard Request (DELETE) must contain:
     1. **404 Not Found**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * title with message "Not Found"
        * detail with message "Please provide an existing Netapp ID".
        * cause with message "Not exist NetappID".

## Test Case 7: Update Onboarded NetApp Certificate

**Test ID**: ***capif_api_invoker_management-7***

**Description**:

  This test will try to update public key and get a new signed certificate by CAPIF Core.

**Pre-Conditions**:

  * NetApp was registered previously
  * NetApp was onboarded previously with {onboardingId} and {public_key_1}

**Information of Test**:

  1. Perform [Invoker Onboarding] with public_key_1.

  2. Create {public_key_2}

  3. Update information of previously onboarded Invoker:
     * Send PUT to *https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers/{onboardingId}*
     * Reference Request Body is: [put invoker onboarding body]
       * ["onboardingInformation"]["apiInvokerPublicKey"]: {public_key_2},
     * Store new certificate.

  4. Update information of previously onboarded Invoker Using new certificate:
     * Send PUT to *https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers/{onboardingId}*
     * Reference Request Body is: [put invoker onboarding body]
       * "notificationDestination": "*http://host.docker.internal:8086/netapp_new_callback*",
     * Use new invoker certificate

**Execution Steps**:

  1. Register Invoker at CCF
  2. Onboard Invoker at CCF
  3. Store signed Certificate
  4. Update Onboarding Information at CCF with new public key
  5. Update Onboarding Information at CCF with minor change

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: *{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}*
  2. Response to Update Request (PUT) with new public key:
     1. **200 OK** response.
     2. apiInvokerCertificate with new certificate on response -> store to use.
  3. Response to Update Request (PUT) with minor change must contain:
     1. **200 OK** response.
     2. notificationDestination on response must contain the new value




[invoker onboarding body]: ./invoker_details_post_example.json  "API Invoker Request"
[user_getauth_response_body_example]: ../common_operations/user_getauth_response_body_example.json  "User GetAuth response Body Example"
[put register body]: ./invoker_details_put_example.json  "API Invoker Update Request"
[invoker getauth body]: ./invoker_getauth_example.json    "Get Auth Example"

[invoker onboarding]: ../common_operations/README.md#onboard-an-invoker "Invoker Onboarding"
