# Test Plan for Vendor Extensibility Feature
At this documentation you will have all information and related files and examples of test plan for this feature.

## Test Case 1: Published API with vendor extensibility

**Test ID**: ***vendor_extensibility-1***

**Description**:

  This test case will check if a published API with vendorExt flag active and vendorSpecific, can be discovered by invoker with all vendorSpecific fields.

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF:
     1. Supported Features with vendorExt flag active (binary 1 0000 0000 -> string **100**)
     2. This API includes "Vendor Specific" information at **service API Description** and inside **AEF Profile**.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker
     1. includes **supported-features** with VendSpecQueryParams active (binary 010 -> string **2**)

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * include [vendor specific service] in root of [service api description].
       * include [vendor specific aef profile] in one AEFProfile inside aefProfiles key.
       * supportedFeatures **100**
     * Use **APF Certificate**
  3. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}&supported-features=2**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response must include **"vendorSpecific"** keys inside root and at AEF Profile.

  2. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  3. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if contains the **vendorSpecific** keys

## Test Case 2: Published API with vendor extensibility and discover with VendSpecQueryParams disabled

**Test ID**: ***vendor_extensibility-2***

**Description**:

  This test case will check if a published API with vendorExt flag active and vendorSpecific, but discovered filter only APIs without vendorSpecific parameter

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF:
     1. Supported Features with vendorExt flag active (binary 1 0000 0000 -> string **100**)
     2. This API includes "Vendor Specific" information at **service API Description** and inside **AEF Profile**.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * include [vendor specific service] in root of [service api description].
       * include [vendor specific aef profile] in one AEFProfile inside aefProfiles key.
       * supportedFeatures **100**
     * Use **APF Certificate**
  3. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}&supported-features=0**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response must include **"vendorSpecific"** keys inside root and at AEF Profile.

  2. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  3. Response to Discover Request By Invoker:
     1. **404 Not Found** response.
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * title with message "Not Found"
        * detail with message "API Invoker {api_invoker_id} has no API Published that accomplish filter conditions".
        * cause with message "No API Published accomplish filter conditions".

## Test Case 3: Publish API with vendorExt active and discover without supported features filter

**Test ID**: ***vendor_extensibility-3***

**Description**:

  This test case will check if a published API with vendor extensions can be discovered by invoker but without verdorSpecific parameters if supported-features query parameter is not set properly

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF:
     1. Supported Features with vendorExt flag active (binary 1 0000 0000 -> string **100**)
     2. This API includes "Vendor Specific" information at **service API Description** and inside **AEF Profile**.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * include [vendor specific service] in root of [service api description].
       * include [vendor specific aef profile] in one AEFProfile inside aefProfiles key.
       * supportedFeatures **100**
     * Use **APF Certificate**
  3. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response must include **"vendorSpecific"** keys inside root and at AEF Profile.

  2. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  3. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check **NOT** contains the **vendorSpecific** keys

## Test Case 4: Publish API with vendorExt active but without vendorSpecifics

**Test ID**: ***vendor_extensibility-4***

**Description**:

  This test case will check if a published API with vendorExt flag active and without vendorSpecific gets a 400 Bad Request, because is not allowed by definition.

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF:
     1. Supported Features with vendorExt flag active (binary 1 0000 0000 -> string **100**)
     2. This API **NOT** includes any "Vendor Specific" information.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * **NOT INCLUDED** [vendor specific service] in root of [service api description].
       * **NOT INCLUDED** [vendor specific aef profile] in one AEFProfile inside aefProfiles key.
       * supportedFeatures **100**
     * Use **APF Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **400 Bad Request**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 400
        * title with message "Bad Request"
        * detail with message "If and only if VendorExt feature is enabled, then vendor-specific fields should be defined".
        * cause with message "Vendor extensibility misconfiguration".

## Test Case 5: Publish API with vendorExt inactive but with vendorSpecifics

**Test ID**: ***vendor_extensibility-5***

**Description**:

  This test case will check if a published API with vendorExt flag inactive and with vendorSpecific gets a 400 Bad Request, because is not allowed by definition.

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF:
     1. Supported Features with vendorExt flag active (binary 0 0000 0000 -> string **000**)
     2. This API includes any "Vendor Specific" information.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * include [vendor specific service] in root of [service api description].
       * include [vendor specific aef profile] in one AEFProfile inside aefProfiles key.
       * supportedFeatures **000**
     * Use **APF Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **400 Bad Request**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 400
        * title with message "Bad Request"
        * detail with message "If and only if VendorExt feature is enabled, then vendor-specific fields should be defined".
        * cause with message "Vendor extensibility misconfiguration".


## Test Case 6: Published API without vendor extensibility discover with VendSpecQueryParams enabled

**Test ID**: ***vendor_extensibility-6***

**Description**:

  This test case will check if a published API with vendorExt flag inactive and vendorSpecific no presnet, but discovered filter only APIs with vendorSpecific parameter

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF:
     1. Supported Features with vendorExt flag active (binary 0 0000 0000 -> string **000**)
     2. This API **NOT** includes "Vendor Specific" information at **service API Description** and inside **AEF Profile**.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker
     1. Supported-features: binary 010 -> string 2

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * **NOT INCLUDED** [vendor specific service] in root of [service api description].
       * **NOT INCLUDED** [vendor specific aef profile] in one AEFProfile inside aefProfiles key.
       * supportedFeatures **000**
     * Use **APF Certificate**
  3. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}&supported-features=2**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response must NOT include any **"vendorSpecific"** keys inside root and at AEF Profile.

  2. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  3. Response to Discover Request By Invoker:
     1. **404 Not Found** response.
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * title with message "Not Found"
        * detail with message "API Invoker {api_invoker_id} has no API Published that accomplish filter conditions".
        * cause with message "No API Published accomplish filter conditions".

## Test Case 7: Published API without vendor extensibility and discover with vendSpecQueryParams disabled

**Test ID**: ***vendor_extensibility-7***

**Description**:

  This test case will check if a published API with vendorExt flag inactive and no vendorSpecific, can be discovered by invoker filtering by vendSpecQueryParams.

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF:
     1. Supported Features with vendorExt flag active (binary 0 0000 0000 -> string **00**)
     2. This API **NOT** includes any "Vendor Specific" information at **service API Description** and inside **AEF Profile**.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker
     1. includes **supported-features** with VendSpecQueryParams active (binary 000 -> string **0**)

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * **NOT INCLUDE** [vendor specific service] in root of [service api description].
       * **NOT INCLUDE** [vendor specific aef profile] in one AEFProfile inside aefProfiles key.
       * supportedFeatures **000**
     * Use **APF Certificate**
  3. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}&supported-features=0**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response must **NOT** include **"vendorSpecific"** keys inside root and at AEF Profile.

  2. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  3. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if **NOT** contains any **vendorSpecific** keys


## Test Case 8: Published API without vendor extensibility and discover without supported-features query parameter

**Test ID**: ***vendor_extensibility-8***

**Description**:

  This test case will check if a published API with vendorExt flag inactive and no vendorSpecific, can be discovered by invoker without filtering by vendSpecQueryParams.

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF:
     1. Supported Features with vendorExt flag active (binary 0 0000 0000 -> string **000**)
     2. This API **NOT** includes any "Vendor Specific" information at **service API Description** and inside **AEF Profile**.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker
     1. **NOT** includes **supported-features**

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * **NOT INCLUDE** [vendor specific service] in root of [service api description].
       * **NOT INCLUDE** [vendor specific aef profile] in one AEFProfile inside aefProfiles key.
       * supportedFeatures **000**
     * Use **APF Certificate**
  3. Request Discover Published APIs:
     * Send **GET** to **https://{CAPIF_HOSTNAME}/service-apis/v1/allServiceAPIs?api-invoker-id={apiInvokerId}&aef-id=${aefId}**
     * Param api-invoker-id is mandatory
     * Use **Invoker Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **201 Created**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiId
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/published-apis/v1/{apfId}/service-apis/{serviceApiId}**
     4. Response must **NOT** include **"vendorSpecific"** keys inside root and at AEF Profile.

  2. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  3. Response to Discover Request By Invoker:
     1. **200 OK** response.
     2. Response body must follow **DiscoveredAPIs** data structure:
        * Check if DiscoveredAPIs contains the API Published previously
          * Check if **NOT** contains any **vendorSpecific** keys

## Test Case 9: Publish API without supportedFeatures

**Test ID**: ***vendor_extensibility-9***

**Description**:

  This test case will check if a published API without supportedFeatures receives the 400 Bad Request, because is not allowed by definition.

**Pre-Conditions**:

  * Network App was registered previously
  * Network App was onboarded previously with {onboardingId}

**Execution Steps**:

  1. Register Provider at CCF, store certificates.
  2. Publish Service API at CCF.
  3. Register Invoker and Onboard Invoker at CCF
  4. Discover Service APIs by Invoker

**Information of Test**:

  1. Perform [Provider Registration] and [Invoker Onboarding]
  2. Publish Service API at CCF:
     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
       * **without supportedFeatures parameter.**
     * Use **APF Certificate**

**Expected Result**:

  1. Response to Publish request must accomplish:
     1. **400 Bad Request**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 400
        * title with message "Bad Request"
        * detail with message "supportedFeatures not present in request".
        * cause with message "supportedFeatures not present".


   [service api description]: ../api_publish_service/service_api_description_post_example.json  "Service API **Description** Request"
   [publisher register body]: ../api_publish_service/publisher_register_body.json  "Publish register Body"
   [invoker onboarding body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
   [provider request body]: ../api_provider_management/provider_details_post_example.json  "API Provider Enrolment Request"
   [provider request patch body]: ../api_provider_management/provider_details_enrolment_details_patch_example.json  "API Provider Enrolment Patch Request"

   [invoker onboarding]: ../common_operations/README.md#onboard-an-invoker "Invoker Onboarding"
   [provider registration]: ../common_operations/README.md#register-a-provider "Provider Registration"
   [vendor specific service]: ./vendor_specific_service.json  "Vendor Specific Service"
   [vendor specific aef profile]: ./vendor_specific_aef_profile.json  "Vendor Specific AEF Profile"
