# Documentation

This respository contains the documentation of OpenCAPIF.

## How it works?

There are 2 ways to upgrade documentation published on [OCF Documentation]:
* Push any change on **develop** branch will force update of **develop** version on [OCF Documentation].
* Create a tag, this will create a version with tag name on [OCF Documentation].

## Repository Branches

This documentation repository has 2 protected branches:

* **main**
  * This branch will store the information stable.
* **develop**
  * Any change uploaded on this branch will upgrade **develop** version on documentation published on [OCF Documentation]

## What should be the flow to add documentation during development

The steps to upgrade documentation are:
1. Perform the development of functionality on capif code respository.
2. Create an issue on [Documentation Gitlab](https://labs.etsi.org/rep/ocf/documentation/-/issues)
3. Create new branch with source from **develop**.
4. Update documentation:
   1. ***Remember to update index.md with new functionalities for latest version***
   2. New testplan is defined? **Update test plan documentation**
5. Check if all new documentation is ok using **mike** [Checking documentation with local deployment](#checking-documentation-with-local-deployment) section.
6. Push changes to branch.
7. Create Merge Request.
8. Send Merge Request to one TSC Member to approve it.

## Release new version of documentation

When **OpenCAPIF** code repository is ready to share a new release we need to follow next steps by a **TSC Member**:
1. Create a new branch with released version, and merge it to **develop**.
2. Create a Merge request from **develop** to **main**.
3. When develop is merged to **main**, then we need to **create a tag with released version.**


## Checking documentation with local deployment

The easy way to check if documentation will be generated properly is check locally with [mike utility](https://github.com/jimporter/mike).

## Requirements

1. You will need python or any python virtual environment installed on your computer with **pip**.
2. Install mike and mkdocs-material:
```
pip install -q mkdocs-material mike
```
3. Set default tag:
```
mike set-default --allow-undefined version1
```
4. Run mike development server:
```
mike deploy version1; mike serve
```
1. Use any web browser to reach http://localhost:8000/version1/

> **To see changes on documentation you will need to restart mike server**

## What is the documentation structure

At mkdocs.yml you will have the navigation structure of documentation, there you can sections with sub-sections. after semicolon you can place the markdown to use on it. For example:
```
nav:
  - Overview:
      - Introduction: index.md
  - Getting Started:
      - How to Run: ./gettingstarted/howtorun.md
  - Testing:
      - Test Plan: ./testing/testplan/README.md
      - Robot Framework: ./testing/robotframework/README.md
      - Postman: ./testing/postman/README.md
  - FAQ: ./FAQ.md
```

As you can see we have 4 main sections:
* Overview:
  * Here we must place high level information like, version changelog, some inital scripts, ...
* Getting Started:
  * This section must contain a simple way to start working with project.
* Testing:
  * Detailed information of **how to test** OpenCAPIF, and test plan developed to ensure the code has all implemented functionallity checked.
* FAQ

## Main page

The page shown on first view is at **doc/index.md**

That page should be updated with latest changes on CAPIF, also including the version.


[OCF Web]: https://ocf.etsi.org/ "OCF Web"
[OCF Documentation]: https://ocf.etsi.org/documentation/ "OCF Documentation"