# Test Plan for CAPIF Api Events Service
At this documentation you will have all information and related files and examples of test plan for this API.

---
## Test Case 1: Creates a new individual CAPIF Event Subscription.

**Test ID**: ***capif_api_events-1***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) can Subscribe to Events
**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)

**Execution Steps**:

  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
  3. Retrieve {subscriberId} and {subscriptionId} from Location Header

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body]
     3. Use **Invoker Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.

  3. Event Subscriptions are stored in CAPIF Database

---
## Test Case 2: Creates a new individual CAPIF Event Subscription with Invalid SubscriberId

**Test ID**: ***capif_api_events-2***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) cannot Subscribe to Events without valid SubcriberId

**Pre-Conditions**:

  * CAPIF subscriber is not pre-authorised (has invalid InvokerId or apfId)

**Execution Steps**:

  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{SUBSCRIBER_NOT_REGISTERED}/subscriptions**
     2. body [event subscription request body]
     3. Use **Invoker Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  2. Response to Event Subscription must accomplish:
     1. **404 Not Found**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * title with message "Not Found"
        * detail with message "Invoker or APF or AEF or AMF Not found".
        * cause with message "Subscriber Not Found".

  3. Event Subscriptions are not stored in CAPIF Database

---
## Test Case 3: Deletes an individual CAPIF Event Subscription

**Test ID**: ***capif_api_events-3***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) can Delete an Event Subscription

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)

**Execution Steps**:

  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
  3. Retrieve {subscriberId} and {subscriptionId} from Location Header
  4. Remove Event Subscription

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body]
     3. Use **Invoker Certificate**

  3. Remove Event Subscription:
     1. Send **DELETE** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. Use **Invoker Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.

  3. Event Subscriptions are stored in CAPIF Database
  4. Remove Event Subscription:
     1. **204 No Content**

  5. Event Subscription is not present at CAPIF Database.

---
## Test Case 4: Deletes an individual CAPIF Event Subscription with invalid SubscriberId

**Test ID**: ***capif_api_events-4***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) cannot Delete to Events without valid SubcriberId

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId).
  * CAPIF subscriber is subscribed to Events.

**Execution Steps**:

  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
  3. Retrieve Location Header with subscriptionId.
  4. Remove Event Subscribed with not valid Subscriber.

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body]
     3. Use **Invoker Certificate**

  3. Remove Event Subcription with not valid subscriber:
     1. Send **DELETE** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{SUBSCRIBER_ID_NOT_VALID}/subscriptions/{subcriptionId}**
     2. Use **Invoker Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  2. Response to Event Subscription must accomplish:
     1. 201 Created
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: *{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}
     3. Response Body must follow **EventSubscription** data structure.

  3. Event Subscriptions are stored in CAPIF Database
  4. Error Response Body must accomplish with **ProblemDetails** data structure with:

     * status 404
     * title with message "Not Found"
     * detail with message "Invoker or APF or AEF or AMF Not found".
     * cause with message "Subscriber Not Found".

---
## Test Case 5: Deletes an individual CAPIF Event Subscription with invalid SubscriptionId

**Test ID**: ***capif_api_events-5***

**Description**:

  This test case will check that a CAPIF subscriber (Invoker or Publisher) cannot Delete an Event Subscription without valid SubscriptionId

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has invalid InvokerId or apfId).
  * CAPIF subscriber is subscribed to Events.

**Execution Steps**:

  1. Register Invoker and Onboard Invoker at CCF
  2. Subscribe to Events
  3. Retrieve Location Header with subscriptionId.
  4. Remove Event Subscribed with not valid Subscriber.

**Information of Test**:

  1. Perform [Invoker Onboarding]

  2. Event Subscription:
     1. Send **POST** to https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions
     2. body [event subscription request body]
     3. Use **Invoker Certificate**

  3. Remove Event Subcription with not valid subscriber:
     1. Send **DELETE** to to https://{CAPIF_HOSTNAME}/capif-events/v1/{subcriberId}/subscriptions/{SUBSCRIPTION_ID_NOT_VALID}
     2. Use **Invoker Certificate**

**Expected Result**:

  1. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**

  2. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.

  3. Event Subscriptions are stored in CAPIF Database
  4. Remove Event Subscription with not valid subscriber:
     1. **404 Not Found**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 404
        * detail with message "Service API not existing".
        * cause with message "Event API subscription id not found".

---
## Test Case 6: Invoker receives Service API Invocation events

**Test ID**: ***capif_api_events-6***, ***mockserver***

**Description**:

  This test case will check that a CAPIF Invoker subscribed to SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE, receive the notification when AEF send to logging service result of invocations to their APIs.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered and published APIs.
  * API Provider had a Service API Published on CAPIF
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:

  1. Register provider and publish one API at CCF
  2. Register Invoker and Onboard Invoker at CCF
  3. Discover published APIs and extract apiIds and apiNames
  4. Subscribe to **SERVICE_API_INVOCATION_SUCCESS** and **SERVICE_API_INVOCATION_FAILURE** event filtering by aefId.
  5. Retrieve {subscriberId} and {subscriptionId} from Location Header
  6. Emulate Success and Failure on API invocation of provider by Invoker, using Invocation Logs API.

**Information of Test**:

  1. Perform [provider registration]
  2. Publish Service API at CCF:

     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
     * Store **serviceApiId**
     * Use APF Certificate

  3. Perform [invoker onboarding]
  4. Discover published APIs:

     * Get **Api Ids** And **Api Names** from response.

  5. Event Subscription to SERVICE_API_INVOCATION_SUCCESS and SERVICE_API_INVOCATION_FAILURE of provider previously registered:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body] with:
        1. events: **['SERVICE_API_INVOCATION_SUCCESS','SERVICE_API_INVOCATION_FAILURE']**
        2. eventFilter: only receive events from provider's aefId.
     3. Use **Invoker Certificate**

  7. Create Log Entry emulating provider receive Success and Failure api invocation from invoker:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/api-invocation-logs/v1/{aefId}/logs**
     2. body [log entry request body] with:
        1. aefId from provider published.
        2. apiInvokerId from invoker onboarded.
        3. apiId of published API
        4. apiName of published API
        5. 200 and 400 results in two logs.
     3. Use AEF Certificate

**Expected Result**:

  1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  2. Response to creation of log entry on CCF must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/api-invocation-logs/{apiVersion}/{aefId}/subscriptions/{logId}**
  3. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **invocationLog** in **eventDetail** parameter.
        1. One should be **SERVICE_API_INVOCATION_SUCCESS** related with **200** result at Log.
        2. The other one must be **SERVICE_API_INVOCATION_FAILURE** related with **400** result at Log.

---
## Test Case 7: Invoker subscribe to Service API Available and Unavailable events

**Test ID**: ***capif_api_events-7***, ***mockserver***

**Description**:

  This test case will check that a CAPIF Invoker subscribed to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE, receive the notification when AEF publish and remove it. 

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered and published APIs.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:

  1. Register provider and publish one API at CCF
  2. Register Invoker and Onboard Invoker at CCF
  3. Discover published APIs and extract apiIds and apiNames
  4. Subscribe to **SERVICE_API_AVAILABLE** and **SERVICE_API_UNAVAILABLE** event filtering by aefId.
  5. Retrieve {subscriberId} and {subscriptionId} from Location Header
  6. Provider publish new API.
  7. Provider remove published API.

**Information of Test**:

  1. Perform [provider registration]
  2. Publish Service API at CCF:

     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
     * Store **serviceApiId**
     * Use **APF Certificate**

  3. Perform [invoker onboarding]
  4. Discover published APIs:

     * Get **Api Ids** And **Api Names** from response.

  5. Event Subscription to SERVICE_API_AVAILABLE and SERVICE_API_UNAVAILABLE of provider previously registered:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body] with:
        1. events: **['SERVICE_API_AVAILABLE','SERVICE_API_UNAVAILABLE']**
        2. eventFilter: only receive events from provider's aefId.
     3. Use **Invoker Certificate**

  6. Publish new Service API at CCF:

     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_2**
     * Store **serviceApiId**
     * Use **APF Certificate**

  7. Remove published Service API at CCF:
     * Send **DELETE** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{SERVICE_API_ID}**
     * Use **APF Certificate**


**Expected Result**:

  1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.

  2. Mock Server received messages must accomplish:
     1. **Two Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiIds** in **eventDetail** parameter.
        1. One should be **SERVICE_API_AVAILABLE** apiId of service_2 published API.
        2. The other one must be **SERVICE_API_UNAVAILABLE** apiId of service_1 published API.

---
## Test Case 8: Invoker subscribe to Service API Update

**Test ID**: ***capif_api_events-8***, ***mockserver***

**Description**:

  This test case will check that a CAPIF Invoker subscribed to SERVICE_API_UPDATE, receive the notification when AEF Update some information on API Published.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered and published APIs.
  * API Provider had a Service API Published on CAPIF
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:

  1. Register Provider and publish one API at CCF
  2. Register Invoker and Onboard Invoker at CCF
  3. Discover published APIs and extract apiIds and apiNames
  4. Subscribe to **SERVICE_API_UPDATE** event filtering by aefId.
  5. Retrieve {subscriberId} and {subscriptionId} from Location Header at event subscription
  6. Provider update information of Service API Published.

**Information of Test**:

  1. Check and Clean Mock Server
  2. Perform [provider registration]
  3. Publish Service API at CCF:

     * Send **POST** to ccf_publish_url **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis**
     * body [service api description] with apiName **service_1**
     * Use ***APF Certificate***
     * Store **serviceApiId**

  4. Perform [invoker onboarding]
  5. Discover published APIs:

     * Get **Api Ids** And **Api Names** from response.

  6. Event Subscription to SERVICE_API_UPDATE of provider previously registered:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body] with:
        1. events: **['SERVICE_API_UPDATE']**
        2. eventFilter: only receive events from provider's aefId.
     3. Use **Invoker Certificate**

  7. Update published API at CCF:
     * Send **PUT** to resource URL **https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis/{serivceApiId}**
     * body [service api description] with overrided **apiName** to **service_1_modified**
     * Use **APF Certificate**

**Expected Result**:

  1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  2. Response to Update Published Service API:
     1. **200 OK**
     2. Response Body must follow **ServiceAPIDescription** data structure with:
        * apiName **service_1_modified**
  3. Mock Server received messages must accomplish:
     1. **One Event has been received**.
     2. Validate received events follow **EventNotification** data structure, with **serviceAPIDescriptions** in **eventDetail** parameter.
        1. Event should be **SERVICE_API_UPDATE** with **eventDetail** with modified **apiName**.

---
## Test Case 9: Provider subscribe to API Invoker events

**Test ID**: ***capif_api_events-9***, ***mockserver***

**Description**:

  This test case will check that a CAPIF Provider subscribed to API Invoker events (API_INVOKER_ONBOARDED, API_INVOKER_UPDATED and API_INVOKER_OFFBOARDED), receive the notifications when Invoker is onboarded, updated and removed respectively.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:

  1. Register Provider at CCF
  2. Subscribe Provider to **API_INVOKER_ONBOARDED, API_INVOKER_UPDATED and API_INVOKER_OFFBOARDED** events.
  3. Register Invoker and Onboard Invoker at CCF
  4. Update Onboarding Information at CCF with a minor change on "notificationDestination"
  5. Offboard Invoker

**Information of Test**:

  1. Check and Clean Mock Server
  2. Perform [provider registration]
  3. Event Subscription to API_INVOKER_ONBOARDED, API_INVOKER_UPDATED and API_INVOKER_OFFBOARDED events:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body] with:
        1. events: **['API_INVOKER_ONBOARDED', 'API_INVOKER_UPDATED', 'API_INVOKER_OFFBOARDED']**
     3. Use **Provider AMF Certificate**
  4. Perform [invoker onboarding]
  5. Update information of previously onboarded Invoker:
     * Send **PUT** to **https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers/{onboardingId}**
     * Reference Request Body is: [put invoker onboarding body]
       * "notificationDestination": "**http://host.docker.internal:8086/netapp_new_callback**",
  6. Offboard:
     * Send **DELETE** to **https://{CAPIF_HOSTNAME}/api-invoker-management/v1/onboardedInvokers/{onboardingId}**

**Expected Result**:

  1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  2. Response to Onboard request must accomplish:
     1. **201 Created**
     2. Response Body must follow **APIInvokerEnrolmentDetails** data structure with:
        * apiInvokerId
        * onboardingInformation->apiInvokerCertificate must contain the public key signed.
     3. Response Header **Location** must be received with URI to new resource created, following this structure: **{apiRoot}/api-invoker-management/{apiVersion}/onboardedInvokers/{onboardingId}**
  3. Response to Update Request (PUT) with minor change must contain:
     1. **200 OK** response.
     2. notificationDestination on response must contain the new value
  4. Response to Offboard Request (DELETE) must contain:
     1. **204 No Content**
  5. Mock Server received messages must accomplish:
     1. **Three Events have been received**.
     2. Validate received events follow **EventNotification** data structure, with **apiInvokerIds** in **eventDetail** parameter.
        1. One Event should be **API_INVOKER_ONBOARDED** with **eventDetail** with modified **apiInvokerId**.
        2. One Event should be **API_INVOKER_UPDATED** with **eventDetail** with modified **apiInvokerId**.
        3. One Event should be **API_INVOKER_OFFBOARDED** with **eventDetail** with modified **apiInvokerId**.
---
## Test Case 10: Provider subscribed to ACL update event

**Test ID**: ***capif_api_events-10***, ***mockserver***

**Description**:

  This test case will check that a CAPIF Provider subscribed to ACCESS_CONTROL_POLICY_UPDATE receive a notification when ACL Changes.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered.
  * API Provider had one Service API Published on CAPIF
  * API Invoker had a Security Context for the Service API published by provider.
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:
  
  1. Register Provider at CCF.
  2. Publish a provider API with name **service_1**.
  3. Register Invoker and Onboard Invoker at CCF.
  4. Subscribe Provider to **ACCESS_CONTROL_POLICY_UPDATE** event.
  5. Discover APIs filtered by **aef_id**
  6. Create Security Context for Invoker.
  7. Provider Retrieve ACL

**Information of Test**:

  1. Check and Clean Mock Server
  2. Perform [provider registration]
  3. Perform [invoker onboarding]
  4. Event Subscription to **ACCESS_CONTROL_POLICY_UPDATE** event:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body] with:
        1. events: **['ACCESS_CONTROL_POLICY_UPDATE']**
        2. eventFilters: apiInvokerIds array with apiInvokerId of invoker
     3. Use **Provider AMF Certificate**
  5. Discover published APIs
  6. Create Security Context for Invoker
     * Send **PUT** **https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}**
     * body [service security body]
     * Use Invoker Certificate
  7. Provider Retrieve ACL
     * Send **GET** **https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}**
     * Use **serviceApiId** and **aefId**
     * Use AEF Provider Certificate

**Expected Result**:

  1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  2. Create security context:
     1. **201 Created** response.
     2. body returned must accomplish **ServiceSecurity** data structure.
     3. Location Header must contain the new resource URL **{apiRoot}/capif-security/v1/trustedInvokers/{apiInvokerId}**
  3. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. contain only one object.
        2. apiInvokerId must match apiInvokerId registered previously.
  4. Mock Server received messages must accomplish:
     1. **One Event has been received**.
     2. Validate received event follow **EventNotification** data structure, with **accCtrlPolListExt** in **eventDetail** parameter.
        1. One Event should be **ACCESS_CONTROL_POLICY_UPDATE** with **eventDetail** with **accCtrlPolListExt** including the **apiId** and **apiInvokerPolicies**.

---
## Test Case 11: Provider receives an ACL unavailable event when invoker remove Security Context.

**Test ID**: ***capif_api_events-11***, ***mockserver***

**Description**:

  This test case will check that a CAPIF Invoker subscribed to ACCESS_CONTROL_POLICY_UNAVAILABLE will receive the notification when AEF remove Security Context created previously.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered.
  * API Provider had one Service API Published on CAPIF
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:

  1. Register Provider at CCF.
  2. Publish a provider API with name **service_1**.
  3. Register Invoker and Onboard Invoker at CCF.
  4. Subscribe Invoker to **ACCESS_CONTROL_POLICY_UNAVAILABLE** event.
  5. Discover APIs filtered by **aef_id**
  6. Create Security Context for Invoker.
  7. Provider Retrieve ACL.
  8. Remove Security Context for Invoker.

**Information of Test**:

  1. Check and Clean Mock Server
  2. Perform [provider registration]
  3. Perform [invoker onboarding]
  4. Event Subscription to **ACCESS_CONTROL_POLICY_UNAVAILABLE** event:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body] with:
        1. events: **['ACCESS_CONTROL_POLICY_UNAVAILABLE']**
        2. eventFilters: apiInvokerIds array with apiInvokerId of invoker
     3. Use **Invoker Certificate**
  5. Discover published APIs
  6. Create Security Context for Invoker
     * Send **PUT** **https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}**
     * body [service security body]
     * Use Invoker Certificate
  7. Provider Retrieve ACL
     * Send **GET** **https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}**
     * Use **serviceApiId** and **aefId**
     * Use **AEF Provider Certificate**
  3. Delete Security Context of Invoker by Provider:
     * Send **DELETE** **https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}**
     * Use **AEF certificate**

**Expected Result**:

  1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  2. Create security context:
     1. **201 Created** response.
     2. body returned must accomplish **ServiceSecurity** data structure.
     3. Location Header must contain the new resource URL **{apiRoot}/capif-security/v1/trustedInvokers/{apiInvokerId}**
  3. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. contain only one object.
        2. apiInvokerId must match apiInvokerId registered previously.
  4. Delete security context:
     1. **204 No Content** response.
  5. Mock Server received messages must accomplish:
     1. **One Event has been received**.
     2. Validate received event follow **EventNotification** data structure, without **eventDetail** parameter.
        1. One Event should be **ACCESS_CONTROL_POLICY_UNAVAILABLE** without **eventDetail**.
---
## Test Case 12: Invoker receives an Invoker Authorization Revoked and ACL unavailable event when Provider revoke Invoker Authorization.

**Test ID**: ***capif_api_events-12***, ***mockserver***

**Description**:

  This test case will check that a CAPIF Invoker subscribed to API_INVOKER_AUTHORIZATION_REVOKED and ACCESS_CONTROL_POLICY_UNAVAILABLE receive both notification when AEF revoke invoker's authorization.

**Pre-Conditions**:

  * CAPIF subscriber is pre-authorised (has valid InvokerId or apfId from CAPIF Authority)
  * CAPIF provider is correctly registered.
  * API Provider had one Service API Published on CAPIF
  * **Mock Server is up and running to receive requests.**
  * **Mock Server is clean.**

**Execution Steps**:

  1. Register Provider at CCF.
  2. Publish a provider API with name **service_1**.
  3. Register Invoker and Onboard Invoker at CCF.
  4. Subscribe Invoker to **ACCESS_CONTROL_POLICY_UNAVAILABLE and API_INVOKER_AUTHORIZATION_REVOKED** events.
  5. Discover APIs filtered by **aef_id**
  6. Create Security Context for Invoker.
  7. Revoke Authorization by Provider.

**Information of Test**:

  1. Check and Clean Mock Server
  2. Perform [provider registration]
  3. Perform [invoker onboarding]
  4. Event Subscription to **ACCESS_CONTROL_POLICY_UNAVAILABLE and API_INVOKER_AUTHORIZATION_REVOKED** event:
     1. Send **POST** to **https://{CAPIF_HOSTNAME}/capif-events/v1/{subscriberId}/subscriptions**
     2. body [event subscription request body] with:
        1. events: **['ACCESS_CONTROL_POLICY_UNAVAILABLE','API_INVOKER_AUTHORIZATION_REVOKED']**
        2. eventFilters: apiInvokerIds array with apiInvokerId of invoker
     3. Use **Invoker Certificate**
  5. Discover published APIs
  6. Create Security Context for Invoker
     * Send **PUT** **https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}**
     * body [service security body]
     * Use Invoker Certificate
  7. Revoke Authorization by Provider:
     * Send **POST** **https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}/delete**
     * body [security notification body]
     * Using AEF Certificate.

**Expected Result**:

  1. Response to Event Subscription must accomplish:
     1. **201 Created**
     2. The URI of the created resource shall be returned in the "Location" HTTP header, following this structure: **{apiRoot}/capif-events/{apiVersion}/{subscriberId}/subscriptions/{subscriptionId}**
     3. Response Body must follow **EventSubscription** data structure.
  2. Create security context:
     1. **201 Created** response.
     2. body returned must accomplish **ServiceSecurity** data structure.
     3. Location Header must contain the new resource URL **{apiRoot}/capif-security/v1/trustedInvokers/{apiInvokerId}**
  4. Revoke Authorization:
     1. **204 No Content** response.
  5. Mock Server received messages must accomplish:
     1. **Two Events has been received**.
     2. Validate received event follow **EventNotification** data structure, without **eventDetail** parameter.
        1. One Event should be **ACCESS_CONTROL_POLICY_UNAVAILABLE** without **eventDetail**.
        2. One Event should be **API_INVOKER_AUTHORIZATION_REVOKED** without **eventDetail**.

---

[invoker onboard request body]: ../api_invoker_management/invoker_details_post_example.json  "API Invoker Request"
[event subscription request body]: ./event_subscription.json  "Event Subscription Request"
[invoker onboarding]: ../common_operations/README.md#onboard-an-invoker "Invoker Onboarding"
[provider registration]: ../common_operations/README.md#register-a-provider "Provider Registration"
[log entry request body]: ../api_logging_service/invocation_log.json "Log Request Body"
[put register body]: ./invoker_details_put_example.json  "API Invoker Update Request"
[service security body]: ../api_security_service/service_security.json  "Service Security Request"
[security notification body]: ./security_notification.json  "Security Notification Request"

[Return To All Test Plans]: ../README.md
