# Vendor Extensibility
Mechanism for the APIs to re-use, extend their functionalities and data models and engage with third-party API frameworks (e.g. ETSI MEC)

Vendor specific extensions are defined on 3GPP TS 29.122 (section 5.2.13) and 29.500 (section 6.6.3) and is tightly connected with "supported-features” and "feature negotiation" procedures.

## Vendor Extensibility in CAPIF:
Vendor Extensibility is a feature focused on the APIs that are published and exposed via CAPIF. 
As a result, the feature is supported by the ServiceAPIDescription object (and any other objects embeded on it e.g. AefProfile). In the figure below, depicting all supported features of ServiceAPIDescription, 
VendExt feature is noted, which enables vendor-specific extension in the body of the specific object.

![Publish Supported Features](../images/vendor-ext/publish_supported_features_2.png)

Vendor extensibility feature can be enabled and leveraged in 2 CAPIF APIs, Publish and Discover.

## Vendor Extensibility in CAPIF APIs 

### Publish API:
A vendor can extend the ServiceAPIDescription object by adding additional member elements. However, in order to avoid duplication of member names inside a same object 
it is necessary to comply with a naming scheme for vendor-specific data elements, to avoid clashing names between vendors.
Vendor-specific member names in JSON objects shall be named in the following manner:
```
  "vendorSpecific-nnnnnnnnn": {
        ...
        }
```

where the value "nnnnnn" can be:

1.  6-digit IANA-assigned enterprise code:

```
  "vendorSpecific-010415": {
        ...
        }
```

2.  domain name:


```
"vendorSpecific-3gpp.org": {
        ...
        }
```

3. URN:


```
"vendorSpecific-urn:3gpp:example": {
        ...
        }
```

A concrete example of vendor-specific extensibility exists on section 9 of ETSI GS MEC 011 V3.2.1, where ETSI MEC extends the ServiceAPIDescription as depicted on the following two figures.

![Service API Description](../images/vendor-ext/service_api_description_2.png)

![AEF Profile](../images/vendor-ext/aef_profile_2.png)

**Example:**
```json
"vendorSpecific-urn:etsi:mec:capifext:service-info": {
      "serializer": "JSON",
      "state": "ACTIVE",
      "scopeOfLocality": "MEC_SYSTEM",
      "consumedLocalOnly": "True",
      "isLocal": "True",
      "category": {
          "href": "https://www.location.com",
          "id": "location_1",
          "name": "Location",
          "version": "1.0"
      }
  }

  "vendorSpecific-urn:etsi:mec:capifext:transport-info": {
      "name": "trasport1",
      "description": "Transport Info 1",
      "type": "REST_HTTP",
      "protocol": "HTTP",
      "version": "2",
      "security": {
          "grantTypes": "OAUTH2_CLIENT_CREDENTIALS",
          "tokenEndpoint": "https://token-endpoint/"
      }
  }
```

### Discover API

In order to use vendor-specific fields as filters in Discover API, vendor-specific query parameter shall be encoded as follows:
    
```json
https://{{CAPIF_HOSTNAME}}:{{CAPIF_PORT}}/{{DISCOVER_URL}}?
       ...
       vend-spec-<query parameter name>={
          "target": <string that contains the JSON pointer to the attribute in the resource representation>, 
          "value": <query parameter value>
}
```

**Example:**
```json
    https://{{CAPIF_HOSTNAME}}:{{CAPIF_PORT}}/{{DISCOVER_URL}}?
           ...
           vend-spec-type={
              "target": "/vendorSpecific-urn:etsi:mec:capifext:transport-info", 
              "value": "REST_HTTP"
    }
```




[OCF Web]: https://ocf.etsi.org/ "OCF Web"
[OCF Documentation]: https://ocf.etsi.org/documentation/ "OCF Documentation"
