
# Documenting

OpenCAPIF's documentation runs on [MkDocs](https://www.mkdocs.org/).

## Eligibility

Documenting OpenCAPIF is limited to active contributors. So, if you:

1. are an active member or participant;

2. wish to contribute to it;

3. you're ready!

## Documentation System and Structure

[MkDocs](https://www.mkdocs.org/) is a fast and simple static site generator that's geared towards building project documentation. Documentation source files are written in `Markdown`, and configured with a single `YAML` configuration file. Start by reading the [introductory tutorial](https://www.mkdocs.org/getting-started/), then check the [User Guide](https://www.mkdocs.org/user-guide/) for more information.

## Getting Started

To contribute to OpenSlice's documentation, you need to follow those easy steps:

1) Clone the [Documentation repository](https://labs.etsi.org/rep/ocf/documentation) with:

```bash
git clone https://labs.etsi.org/rep/ocf/documentation.git
```

2) Checkout the develop branch (incoming contributions are only accepted to the **develop** branch):

```bash
cd ./documentation
git checkout develop
```

3) Setup a local mkdocs server, using a virtual environment:

```bash
python3 -m venv venv
source venv/bin/activate
python -m pip install mkdocs
python -m pip install mkdocs-material
python -m pip install mike
```

4) Wait for all downloads to finish and start the mkdocs server:

```bash
mkdocs serve
```

5) Document (and commit)! 😊

Before committing, you should make sure that the local *MkDocs* server terminal is not producing any `INFO`/``WARNING`` messages regarding your contributions.

> The documentation website supports branches, so your accepted changes will be reflected to the **develop** branch which becomes the **release** branch after each corresponding cycle.
