# Helm of CAPIF

![Version: v1.0.0](https://img.shields.io/badge/Version-v1.0.0-informational?style=for-the-badge)
![Type: application](https://img.shields.io/badge/Type-application-informational?style=for-the-badge)
![AppVersion: v1.0.0](https://img.shields.io/badge/AppVersion-v1.0.0-informational?style=for-the-badge)

## Description

A Helm chart to CAPIF in Kubernetes

## Usage

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| CapifClient.enable | string | `"true"` | If enable capif client. |
| CapifClient.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| CapifClient.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/client"` | The docker image repository to use |
| CapifClient.image.tag | string | `""` | The docker image tag to use @default Chart version |
| CapifClient.ports[0].name | string | `"8080"` |  |
| CapifClient.ports[0].port | int | `8080` |  |
| CapifClient.ports[0].targetPort | int | `8080` |  |
| CapifClient.replicas | int | `1` |  |
| CapifClient.resources.limits.cpu | string | `"100m"` |  |
| CapifClient.resources.limits.memory | string | `"128Mi"` |  |
| CapifClient.resources.requests.cpu | string | `"100m"` |  |
| CapifClient.resources.requests.memory | string | `"128Mi"` |  |
| CapifClient.type | string | `"ClusterIP"` |  |
| accessControlPolicy.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| accessControlPolicy.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| accessControlPolicy.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/access-control-policy"` | The docker image repository to use |
| accessControlPolicy.image.tag | string | `""` | The docker image tag to use @default Chart version |
| accessControlPolicy.ports[0].name | string | `"8080"` |  |
| accessControlPolicy.ports[0].port | int | `8080` |  |
| accessControlPolicy.ports[0].targetPort | int | `8080` |  |
| accessControlPolicy.replicas | int | `1` |  |
| accessControlPolicy.resources.limits.cpu | string | `"100m"` |  |
| accessControlPolicy.resources.limits.memory | string | `"128Mi"` |  |
| accessControlPolicy.resources.requests.cpu | string | `"100m"` |  |
| accessControlPolicy.resources.requests.memory | string | `"128Mi"` |  |
| accessControlPolicy.type | string | `"ClusterIP"` |  |
| apiInvocationLogs.apiInvocationLogs.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| apiInvocationLogs.apiInvocationLogs.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| apiInvocationLogs.apiInvocationLogs.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/api-invocation-logs-api"` | The docker image repository to use |
| apiInvocationLogs.apiInvocationLogs.image.tag | string | `""` | The docker image tag to use @default Chart version |
| apiInvocationLogs.apiInvocationLogs.resources.limits.cpu | string | `"100m"` |  |
| apiInvocationLogs.apiInvocationLogs.resources.limits.memory | string | `"128Mi"` |  |
| apiInvocationLogs.apiInvocationLogs.resources.requests.cpu | string | `"100m"` |  |
| apiInvocationLogs.apiInvocationLogs.resources.requests.memory | string | `"128Mi"` |  |
| apiInvocationLogs.ports[0].name | string | `"8080"` |  |
| apiInvocationLogs.ports[0].port | int | `8080` |  |
| apiInvocationLogs.ports[0].targetPort | int | `8080` |  |
| apiInvocationLogs.replicas | int | `1` |  |
| apiInvocationLogs.type | string | `"ClusterIP"` |  |
| apiInvokerManagement.apiInvokerManagement.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| apiInvokerManagement.apiInvokerManagement.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| apiInvokerManagement.apiInvokerManagement.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/api-invoker-management-api"` | The docker image repository to use |
| apiInvokerManagement.apiInvokerManagement.image.tag | string | `""` | The docker image tag to use @default Chart version |
| apiInvokerManagement.apiInvokerManagement.resources.limits.cpu | string | `"100m"` |  |
| apiInvokerManagement.apiInvokerManagement.resources.limits.memory | string | `"128Mi"` |  |
| apiInvokerManagement.apiInvokerManagement.resources.requests.cpu | string | `"100m"` |  |
| apiInvokerManagement.apiInvokerManagement.resources.requests.memory | string | `"128Mi"` |  |
| apiInvokerManagement.ports[0].name | string | `"8080"` |  |
| apiInvokerManagement.ports[0].port | int | `8080` |  |
| apiInvokerManagement.ports[0].targetPort | int | `8080` |  |
| apiInvokerManagement.replicas | int | `1` |  |
| apiInvokerManagement.type | string | `"ClusterIP"` |  |
| apiProviderManagement.apiProviderManagement.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| apiProviderManagement.apiProviderManagement.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| apiProviderManagement.apiProviderManagement.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/api-provider-management-api"` | The docker image repository to use |
| apiProviderManagement.apiProviderManagement.image.tag | string | `""` | The docker image tag to use @default Chart version |
| apiProviderManagement.apiProviderManagement.resources.limits.cpu | string | `"100m"` |  |
| apiProviderManagement.apiProviderManagement.resources.limits.memory | string | `"128Mi"` |  |
| apiProviderManagement.apiProviderManagement.resources.requests.cpu | string | `"100m"` |  |
| apiProviderManagement.apiProviderManagement.resources.requests.memory | string | `"128Mi"` |  |
| apiProviderManagement.ports[0].name | string | `"8080"` |  |
| apiProviderManagement.ports[0].port | int | `8080` |  |
| apiProviderManagement.ports[0].targetPort | int | `8080` |  |
| apiProviderManagement.replicas | int | `1` |  |
| apiProviderManagement.type | string | `"ClusterIP"` |  |
| capifEvents.capifEvents.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| capifEvents.capifEvents.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| capifEvents.capifEvents.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/events-api"` | The docker image repository to use |
| capifEvents.capifEvents.image.tag | string | `""` | The docker image tag to use @default Chart version |
| capifEvents.capifEvents.resources.limits.cpu | string | `"100m"` |  |
| capifEvents.capifEvents.resources.limits.memory | string | `"128Mi"` |  |
| capifEvents.capifEvents.resources.requests.cpu | string | `"100m"` |  |
| capifEvents.capifEvents.resources.requests.memory | string | `"128Mi"` |  |
| capifEvents.ports[0].name | string | `"8080"` |  |
| capifEvents.ports[0].port | int | `8080` |  |
| capifEvents.ports[0].targetPort | int | `8080` |  |
| capifEvents.replicas | int | `1` |  |
| capifEvents.type | string | `"ClusterIP"` |  |
| capifRoutingInfo.capifRoutingInfo.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| capifRoutingInfo.capifRoutingInfo.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| capifRoutingInfo.capifRoutingInfo.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/routing-info-api"` | The docker image repository to use |
| capifRoutingInfo.capifRoutingInfo.image.tag | string | `""` | The docker image tag to use @default Chart version |
| capifRoutingInfo.capifRoutingInfo.resources.limits.cpu | string | `"100m"` |  |
| capifRoutingInfo.capifRoutingInfo.resources.limits.memory | string | `"128Mi"` |  |
| capifRoutingInfo.capifRoutingInfo.resources.requests.cpu | string | `"100m"` |  |
| capifRoutingInfo.capifRoutingInfo.resources.requests.memory | string | `"128Mi"` |  |
| capifRoutingInfo.ports[0].name | string | `"8080"` |  |
| capifRoutingInfo.ports[0].port | int | `8080` |  |
| capifRoutingInfo.ports[0].targetPort | int | `8080` |  |
| capifRoutingInfo.replicas | int | `1` |  |
| capifRoutingInfo.type | string | `"ClusterIP"` |  |
| capifSecurity.capifSecurity.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| capifSecurity.capifSecurity.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| capifSecurity.capifSecurity.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/security-api"` | The docker image repository to use |
| capifSecurity.capifSecurity.image.tag | string | `""` | The docker image tag to use @default Chart version |
| capifSecurity.capifSecurity.resources.limits.cpu | string | `"100m"` |  |
| capifSecurity.capifSecurity.resources.limits.memory | string | `"128Mi"` |  |
| capifSecurity.capifSecurity.resources.requests.cpu | string | `"100m"` |  |
| capifSecurity.capifSecurity.resources.requests.memory | string | `"128Mi"` |  |
| capifSecurity.ports[0].name | string | `"8080"` |  |
| capifSecurity.ports[0].port | int | `8080` |  |
| capifSecurity.ports[0].targetPort | int | `8080` |  |
| capifSecurity.replicas | int | `1` |  |
| capifSecurity.type | string | `"ClusterIP"` |  |
| env | string | `""` | The Environment variable. Use openshift if you are deploying in Openshift cluster. anotherwise use the field empty |
| ingress.ip | string | `"10.17.173.127"` |  |
| kubernetesClusterDomain | string | `"cluster.local"` |  |
| logs.enable | string | `"true"` | If register enabled. enable: true, enable: "" = not enabled |
| logs.logs.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| logs.logs.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| logs.logs.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/auditing-api"` | The docker image repository to use |
| logs.logs.image.tag | string | `""` | The docker image tag to use @default Chart version |
| logs.logs.resources.limits.cpu | string | `"100m"` |  |
| logs.logs.resources.limits.memory | string | `"128Mi"` |  |
| logs.logs.resources.requests.cpu | string | `"100m"` |  |
| logs.logs.resources.requests.memory | string | `"128Mi"` |  |
| logs.ports[0].name | string | `"8080"` |  |
| logs.ports[0].port | int | `8080` |  |
| logs.ports[0].targetPort | int | `8080` |  |
| logs.replicas | int | `1` |  |
| logs.type | string | `"ClusterIP"` |  |
| mongo.mongo.env.mongoInitdbRootPassword | string | `"example"` |  |
| mongo.mongo.env.mongoInitdbRootUsername | string | `"root"` |  |
| mongo.mongo.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| mongo.mongo.image.repository | string | `"mongo"` | The docker image repository to use |
| mongo.mongo.image.tag | string | `"6.0.2"` | The docker image tag to use @default Chart version |
| mongo.mongo.resources | object | `{}` |  |
| mongo.persistence | object | `{"enable":"true","storage":"8Gi"}` | If mongo.persistence enabled. enable: true, enable: "" = not enabled |
| mongo.ports[0].name | string | `"27017"` |  |
| mongo.ports[0].port | int | `27017` |  |
| mongo.ports[0].targetPort | int | `27017` |  |
| mongo.replicas | int | `1` |  |
| mongo.type | string | `"ClusterIP"` |  |
| mongoExpress.mongoExpress.env.meConfigMongodbAdminpassword | string | `"example"` |  |
| mongoExpress.mongoExpress.env.meConfigMongodbAdminusername | string | `"root"` |  |
| mongoExpress.mongoExpress.env.meConfigMongodbUrl | string | `"mongodb://root:example@mongo:27017/"` |  |
| mongoExpress.mongoExpress.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| mongoExpress.mongoExpress.image.repository | string | `"mongo-express"` | The docker image repository to use |
| mongoExpress.mongoExpress.image.tag | string | `"1.0.0-alpha.4"` | The docker image tag to use @default Chart version |
| mongoExpress.mongoExpress.resources.limits.cpu | string | `"100m"` |  |
| mongoExpress.mongoExpress.resources.limits.memory | string | `"128Mi"` |  |
| mongoExpress.mongoExpress.resources.requests.cpu | string | `"100m"` |  |
| mongoExpress.mongoExpress.resources.requests.memory | string | `"128Mi"` |  |
| mongoExpress.ports[0].name | string | `"8082"` |  |
| mongoExpress.ports[0].port | int | `8082` |  |
| mongoExpress.ports[0].targetPort | int | `8081` |  |
| mongoExpress.replicas | int | `1` |  |
| mongoExpress.type | string | `"ClusterIP"` |  |
| mongoRegister.mongo.env.mongoInitdbRootPassword | string | `"example"` |  |
| mongoRegister.mongo.env.mongoInitdbRootUsername | string | `"root"` |  |
| mongoRegister.mongo.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| mongoRegister.mongo.image.repository | string | `"mongo"` | The docker image repository to use |
| mongoRegister.mongo.image.tag | string | `"6.0.2"` | The docker image tag to use @default Chart version |
| mongoRegister.mongo.resources | object | `{}` |  |
| mongoRegister.ports[0].name | string | `"27017"` |  |
| mongoRegister.ports[0].port | int | `27017` |  |
| mongoRegister.ports[0].targetPort | int | `27017` |  |
| mongoRegister.replicas | int | `1` |  |
| mongoRegister.type | string | `"ClusterIP"` |  |
| monitoring.enable | string | `"true"` |  |
| monitoring.enable | string | `"true"` | If monitoring enabled. enable: true, enable: "" = not enabled |
| monitoring.fluentBit.env.lokiUrl | string | `"http://loki:3100/loki/api/v1/push"` |  |
| monitoring.fluentBit.image.repository | string | `"grafana/fluent-bit-plugin-loki"` | The docker image repository to use |
| monitoring.fluentBit.image.tag | string | `"latest"` | The docker image tag to use @default Chart version |
| monitoring.fluentBit.resources | object | `{}` |  |
| monitoring.grafana.env.gfAuthAnonymousEnable | bool | `true` |  |
| monitoring.grafana.env.gfAuthAnonymousOrgRole | string | `"Admin"` |  |
| monitoring.grafana.env.gfSecurityAdminPassword | string | `"secure_pass"` |  |
| monitoring.grafana.env.gfSecurityAllowEmbedding | bool | `true` |  |
| monitoring.grafana.env.lokiUrl | string | `"http://loki:3100"` |  |
| monitoring.grafana.env.prometheusUrl | string | `"http://prometheus.mon.svc.cluster.local:9090"` |  |
| monitoring.grafana.env.tempoUrl | string | `"http://monitoring-capif-tempo:3100"` |  |
| monitoring.grafana.image.repository | string | `"grafana/grafana"` | The docker image repository to use |
| monitoring.grafana.image.tag | string | `"latest"` | The docker image tag to use @default Chart version |
| monitoring.grafana.ingress | object | `{"annotations":null,"enabled":true,"hosts":[{"host":"grafana.5gnacar.int","paths":[{"path":"/","pathType":"Prefix"}]}],"ingressClassName":"nginx","tls":[]}` | If ingress enabled=true, use monitoring.grafana.ingressRoute.enable="" |
| monitoring.grafana.ingressRoute | object | `{"enable":"","host":"grafana.5gnacar.int"}` | If ingressRoute enable=true, use monitoring.grafana.ingress.enabled="" |
| monitoring.grafana.persistence | object | `{"enable":"true","storage":"100Mi"}` | If grafana.persistence enabled. enable: true, enable: "" = not enabled |
| monitoring.grafana.resources | object | `{}` |  |
| monitoring.grafana.service.port | int | `3000` |  |
| monitoring.grafana.service.type | string | `"ClusterIP"` |  |
| monitoring.loki.image.repository | string | `"grafana/loki"` | The docker image repository to use |
| monitoring.loki.image.tag | string | `"2.8.0"` | The docker image tag to use @default Chart version |
| monitoring.loki.persistence | object | `{"enable":"true","storage":"100Mi"}` | If grafana.persistence enabled. enable: true, enable: "" = not enabled |
| monitoring.loki.resources | object | `{}` |  |
| monitoring.otel.configMap.tempoEndpoint | string | `"monitoring-capif-tempo:4317"` |  |
| monitoring.otel.image.repository | string | `"otel/opentelemetry-collector"` | The docker image repository to use |
| monitoring.otel.image.tag | string | `"0.81.0"` | The docker image tag to use @default Chart version |
| monitoring.otel.resources | object | `{}` |  |
| monitoring.prometheus.enable | string | `"true"` | It will deploy prometheus |
| monitoring.prometheus.image.repository | string | `"prom/prometheus"` | The docker image repository to use |
| monitoring.prometheus.image.tag | string | `"latest"` | The docker image tag to use @default Chart version |
| monitoring.prometheus.ingress.annotations | string | `nil` |  |
| monitoring.prometheus.ingress.enabled | bool | `true` |  |
| monitoring.prometheus.ingress.hosts[0].host | string | `"prometheus.5gnacar.int"` |  |
| monitoring.prometheus.ingress.hosts[0].paths[0].path | string | `"/"` |  |
| monitoring.prometheus.ingress.hosts[0].paths[0].pathType | string | `"Prefix"` |  |
| monitoring.prometheus.ingress.ingressClassName | string | `"nginx"` |  |
| monitoring.prometheus.ingress.tls | list | `[]` |  |
| monitoring.prometheus.ingressRoute | object | `{"enable":"","host":"prometheus.5gnacar.int"}` | If ingressRoute enable=true, use monitoring.prometheus.ingress.enabled="" |
| monitoring.prometheus.persistence.enable | string | `"true"` |  |
| monitoring.prometheus.persistence.storage | string | `"8Gi"` |  |
| monitoring.prometheus.resources | object | `{}` |  |
| monitoring.prometheus.service.port | int | `9090` |  |
| monitoring.prometheus.service.type | string | `"ClusterIP"` |  |
| monitoring.renderer.env.enableMetrics | string | `"true"` |  |
| monitoring.renderer.image.repository | string | `"grafana/grafana-image-renderer"` | The docker image repository to use |
| monitoring.renderer.image.tag | string | `"latest"` | The docker image tag to use @default Chart version |
| monitoring.renderer.resources | object | `{}` |  |
| nginx.annotations."nginx.ingress.kubernetes.io/backend-protocol" | string | `"HTTPS"` |  |
| nginx.annotations."nginx.ingress.kubernetes.io/ssl-passthrough" | string | `"true"` |  |
| nginx.annotations."nginx.ingress.kubernetes.io/ssl-redirect" | string | `"true"` |  |
| nginx.ingressClassName | string | `"nginx"` |  |
| nginx.ingressType | string | `"Ingress"` | if nginx.ingressType: "Ingress". set up monitoring.prometheus.ingress: true and monitoring.grafana.ingress: true Use IngressRoute if you want to use Gateway API. ex traefix |
| nginx.nginx.env.capifHostname | string | `"my-capif.apps.ocp-epg.hi.inet"` | Ingress's host to Capif |
| nginx.nginx.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| nginx.nginx.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/nginx"` | The docker image repository to use |
| nginx.nginx.image.tag | string | `""` | The docker image tag to use @default Chart version |
| nginx.nginx.resources.limits.cpu | string | `"100m"` |  |
| nginx.nginx.resources.limits.memory | string | `"128Mi"` |  |
| nginx.nginx.resources.requests.cpu | string | `"100m"` |  |
| nginx.nginx.resources.requests.memory | string | `"128Mi"` |  |
| nginx.ports[0].name | string | `"8080"` |  |
| nginx.ports[0].port | int | `8080` |  |
| nginx.ports[0].targetPort | int | `8080` |  |
| nginx.ports[1].name | string | `"443"` |  |
| nginx.ports[1].port | int | `443` |  |
| nginx.ports[1].targetPort | int | `443` |  |
| nginx.replicas | int | `1` |  |
| nginx.type | string | `"ClusterIP"` |  |
| parametersVault.env.vaultAccessToken | string | `"dev-only-token"` |  |
| parametersVault.env.vaultHostname | string | `"vault-internal.mon.svc.cluster.local"` |  |
| parametersVault.env.vaultPort | int | `8200` |  |
| publishedApis.ports[0].name | string | `"8080"` |  |
| publishedApis.ports[0].port | int | `8080` |  |
| publishedApis.ports[0].targetPort | int | `8080` |  |
| publishedApis.publishedApis.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| publishedApis.publishedApis.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| publishedApis.publishedApis.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/publish-service-api"` | The docker image repository to use |
| publishedApis.publishedApis.image.tag | string | `""` | The docker image tag to use @default Chart version |
| publishedApis.publishedApis.resources.limits.cpu | string | `"100m"` |  |
| publishedApis.publishedApis.resources.limits.memory | string | `"128Mi"` |  |
| publishedApis.publishedApis.resources.requests.cpu | string | `"100m"` |  |
| publishedApis.publishedApis.resources.requests.memory | string | `"128Mi"` |  |
| publishedApis.replicas | int | `1` |  |
| publishedApis.type | string | `"ClusterIP"` |  |
| redis.ports[0].name | string | `"6379"` |  |
| redis.ports[0].port | int | `6379` |  |
| redis.ports[0].targetPort | int | `6379` |  |
| redis.redis.env.redisReplicationMode | string | `"master"` |  |
| redis.redis.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| redis.redis.image.repository | string | `"redis"` | The docker image repository to use |
| redis.redis.image.tag | string | `"alpine"` | The docker image tag to use @default Chart version |
| redis.redis.resources.limits.cpu | string | `"100m"` |  |
| redis.redis.resources.limits.memory | string | `"128Mi"` |  |
| redis.redis.resources.requests.cpu | string | `"100m"` |  |
| redis.redis.resources.requests.memory | string | `"128Mi"` |  |
| redis.replicas | int | `1` |  |
| redis.type | string | `"ClusterIP"` |  |
| register.enable | string | `"true"` | If register enabled. enable: true, enable: "" = not enabled |
| register.ports[0].name | string | `"8080"` |  |
| register.ports[0].port | int | `8084` |  |
| register.ports[0].targetPort | int | `8080` |  |
| register.register.env.mongoHost | string | `"mongo-register"` |  |
| register.register.env.mongoPort | int | `27017` |  |
| register.register.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| register.register.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/jwtauth"` | The docker image repository to use |
| register.register.image.tag | string | `""` | The docker image tag to use @default Chart version |
| register.register.resources.limits.cpu | string | `"100m"` |  |
| register.register.resources.limits.memory | string | `"128Mi"` |  |
| register.register.resources.requests.cpu | string | `"100m"` |  |
| register.register.resources.requests.memory | string | `"128Mi"` |  |
| register.replicas | int | `1` |  |
| register.type | string | `"ClusterIP"` |  |
| serviceApis.ports[0].name | string | `"8080"` |  |
| serviceApis.ports[0].port | int | `8080` |  |
| serviceApis.ports[0].targetPort | int | `8080` |  |
| serviceApis.replicas | int | `1` |  |
| serviceApis.serviceApis.env | object | `{"monitoring":"true"}` | If env.monitoring: true. Setup monitoring.enable: true |
| serviceApis.serviceApis.image.imagePullPolicy | string | `"Always"` | Image pull policy: Always, IfNotPresent |
| serviceApis.serviceApis.image.repository | string | `"public.ecr.aws/o2v4a8t6/opencapif/discover-service-api"` | The docker image repository to use |
| serviceApis.serviceApis.image.tag | string | `""` | The docker image tag to use @default Chart version |
| serviceApis.serviceApis.resources.limits.cpu | string | `"100m"` |  |
| serviceApis.serviceApis.resources.limits.memory | string | `"128Mi"` |  |
| serviceApis.serviceApis.resources.requests.cpu | string | `"100m"` |  |
| serviceApis.serviceApis.resources.requests.memory | string | `"128Mi"` |  |
| serviceApis.type | string | `"ClusterIP"` |  |
| tempo | object | `{"enabled":true,"persistence":{"enabled":true,"size":"3Gi"},"tempo":{"metricsGenerator":{"enabled":true,"remoteWriteUrl":"http://prometheus.mon.svc.cluster.local:9090/api/v1/write"}}}` | If monitoring.enable: "true". Also enable tempo.enabled: true |

