import re  # noqa: E501
from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from capif_security import util
from capif_security.models.base_model import Model


class PlmnId(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, mcc=None, mnc=None):  # noqa: E501
        """PlmnId - a model defined in OpenAPI

        :param mcc: The mcc of this PlmnId.  # noqa: E501
        :type mcc: str
        :param mnc: The mnc of this PlmnId.  # noqa: E501
        :type mnc: str
        """
        self.openapi_types = {
            'mcc': str,
            'mnc': str
        }

        self.attribute_map = {
            'mcc': 'mcc',
            'mnc': 'mnc'
        }

        self._mcc = mcc
        self._mnc = mnc

    @classmethod
    def from_dict(cls, dikt) -> 'PlmnId':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The PlmnId of this PlmnId.  # noqa: E501
        :rtype: PlmnId
        """
        return util.deserialize_model(dikt, cls)

    @property
    def mcc(self) -> str:
        """Gets the mcc of this PlmnId.

        Mobile Country Code part of the PLMN, comprising 3 digits, as defined in clause 9.3.3.5 of 3GPP TS 38.413.    # noqa: E501

        :return: The mcc of this PlmnId.
        :rtype: str
        """
        return self._mcc

    @mcc.setter
    def mcc(self, mcc: str):
        """Sets the mcc of this PlmnId.

        Mobile Country Code part of the PLMN, comprising 3 digits, as defined in clause 9.3.3.5 of 3GPP TS 38.413.    # noqa: E501

        :param mcc: The mcc of this PlmnId.
        :type mcc: str
        """
        if mcc is None:
            raise ValueError("Invalid value for `mcc`, must not be `None`")  # noqa: E501
        if mcc is not None and not re.search(r'^\d{3}$', mcc):  # noqa: E501
            raise ValueError(r"Invalid value for `mcc`, must be a follow pattern or equal to `/^\d{3}$/`")  # noqa: E501

        self._mcc = mcc

    @property
    def mnc(self) -> str:
        """Gets the mnc of this PlmnId.

        Mobile Network Code part of the PLMN, comprising 2 or 3 digits, as defined in  clause 9.3.3.5 of 3GPP TS 38.413.    # noqa: E501

        :return: The mnc of this PlmnId.
        :rtype: str
        """
        return self._mnc

    @mnc.setter
    def mnc(self, mnc: str):
        """Sets the mnc of this PlmnId.

        Mobile Network Code part of the PLMN, comprising 2 or 3 digits, as defined in  clause 9.3.3.5 of 3GPP TS 38.413.    # noqa: E501

        :param mnc: The mnc of this PlmnId.
        :type mnc: str
        """
        if mnc is None:
            raise ValueError("Invalid value for `mnc`, must not be `None`")  # noqa: E501
        if mnc is not None and not re.search(r'^\d{2,3}$', mnc):  # noqa: E501
            raise ValueError(r"Invalid value for `mnc`, must be a follow pattern or equal to `/^\d{2,3}$/`")  # noqa: E501

        self._mnc = mnc
