from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from capif_security import util
from capif_security.models.base_model import Model
from capif_security.models.no_profile_match_reason import NoProfileMatchReason  # noqa: E501
from capif_security.models.query_param_combination import QueryParamCombination  # noqa: E501


class NoProfileMatchInfo(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, reason=None, query_param_combination_list=None):  # noqa: E501
        """NoProfileMatchInfo - a model defined in OpenAPI

        :param reason: The reason of this NoProfileMatchInfo.  # noqa: E501
        :type reason: NoProfileMatchReason
        :param query_param_combination_list: The query_param_combination_list of this NoProfileMatchInfo.  # noqa: E501
        :type query_param_combination_list: List[QueryParamCombination]
        """
        self.openapi_types = {
            'reason': NoProfileMatchReason,
            'query_param_combination_list': List[QueryParamCombination]
        }

        self.attribute_map = {
            'reason': 'reason',
            'query_param_combination_list': 'queryParamCombinationList'
        }

        self._reason = reason
        self._query_param_combination_list = query_param_combination_list

    @classmethod
    def from_dict(cls, dikt) -> 'NoProfileMatchInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The NoProfileMatchInfo of this NoProfileMatchInfo.  # noqa: E501
        :rtype: NoProfileMatchInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def reason(self) -> NoProfileMatchReason:
        """Gets the reason of this NoProfileMatchInfo.


        :return: The reason of this NoProfileMatchInfo.
        :rtype: NoProfileMatchReason
        """
        return self._reason

    @reason.setter
    def reason(self, reason: NoProfileMatchReason):
        """Sets the reason of this NoProfileMatchInfo.


        :param reason: The reason of this NoProfileMatchInfo.
        :type reason: NoProfileMatchReason
        """
        if reason is None:
            raise ValueError("Invalid value for `reason`, must not be `None`")  # noqa: E501

        self._reason = reason

    @property
    def query_param_combination_list(self) -> List[QueryParamCombination]:
        """Gets the query_param_combination_list of this NoProfileMatchInfo.


        :return: The query_param_combination_list of this NoProfileMatchInfo.
        :rtype: List[QueryParamCombination]
        """
        return self._query_param_combination_list

    @query_param_combination_list.setter
    def query_param_combination_list(self, query_param_combination_list: List[QueryParamCombination]):
        """Sets the query_param_combination_list of this NoProfileMatchInfo.


        :param query_param_combination_list: The query_param_combination_list of this NoProfileMatchInfo.
        :type query_param_combination_list: List[QueryParamCombination]
        """
        if query_param_combination_list is not None and len(query_param_combination_list) < 1:
            raise ValueError("Invalid value for `query_param_combination_list`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._query_param_combination_list = query_param_combination_list
