from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from capif_security import util
from capif_security.models.base_model import Model
from capif_security.models.nwdaf_event import NwdafEvent  # noqa: E501


class MlModelInterInd(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, analytics_id=None, vendor_list=None):  # noqa: E501
        """MlModelInterInd - a model defined in OpenAPI

        :param analytics_id: The analytics_id of this MlModelInterInd.  # noqa: E501
        :type analytics_id: NwdafEvent
        :param vendor_list: The vendor_list of this MlModelInterInd.  # noqa: E501
        :type vendor_list: List[str]
        """
        self.openapi_types = {
            'analytics_id': NwdafEvent,
            'vendor_list': List[str]
        }

        self.attribute_map = {
            'analytics_id': 'analyticsId',
            'vendor_list': 'vendorList'
        }

        self._analytics_id = analytics_id
        self._vendor_list = vendor_list

    @classmethod
    def from_dict(cls, dikt) -> 'MlModelInterInd':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The MlModelInterInd of this MlModelInterInd.  # noqa: E501
        :rtype: MlModelInterInd
        """
        return util.deserialize_model(dikt, cls)

    @property
    def analytics_id(self) -> NwdafEvent:
        """Gets the analytics_id of this MlModelInterInd.


        :return: The analytics_id of this MlModelInterInd.
        :rtype: NwdafEvent
        """
        return self._analytics_id

    @analytics_id.setter
    def analytics_id(self, analytics_id: NwdafEvent):
        """Sets the analytics_id of this MlModelInterInd.


        :param analytics_id: The analytics_id of this MlModelInterInd.
        :type analytics_id: NwdafEvent
        """
        if analytics_id is None:
            raise ValueError("Invalid value for `analytics_id`, must not be `None`")  # noqa: E501

        self._analytics_id = analytics_id

    @property
    def vendor_list(self) -> List[str]:
        """Gets the vendor_list of this MlModelInterInd.


        :return: The vendor_list of this MlModelInterInd.
        :rtype: List[str]
        """
        return self._vendor_list

    @vendor_list.setter
    def vendor_list(self, vendor_list: List[str]):
        """Sets the vendor_list of this MlModelInterInd.


        :param vendor_list: The vendor_list of this MlModelInterInd.
        :type vendor_list: List[str]
        """
        if vendor_list is None:
            raise ValueError("Invalid value for `vendor_list`, must not be `None`")  # noqa: E501
        if vendor_list is not None and len(vendor_list) < 1:
            raise ValueError("Invalid value for `vendor_list`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._vendor_list = vendor_list
