from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from capif_routing_info import util
from capif_routing_info.models.base_model import Model
from capif_routing_info.models.routing_rule import RoutingRule  # noqa: E501


class RoutingInfo(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, routing_rules=None):  # noqa: E501
        """RoutingInfo - a model defined in OpenAPI

        :param routing_rules: The routing_rules of this RoutingInfo.  # noqa: E501
        :type routing_rules: List[RoutingRule]
        """
        self.openapi_types = {
            'routing_rules': List[RoutingRule]
        }

        self.attribute_map = {
            'routing_rules': 'routingRules'
        }

        self._routing_rules = routing_rules

    @classmethod
    def from_dict(cls, dikt) -> 'RoutingInfo':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The RoutingInfo of this RoutingInfo.  # noqa: E501
        :rtype: RoutingInfo
        """
        return util.deserialize_model(dikt, cls)

    @property
    def routing_rules(self) -> List[RoutingRule]:
        """Gets the routing_rules of this RoutingInfo.


        :return: The routing_rules of this RoutingInfo.
        :rtype: List[RoutingRule]
        """
        return self._routing_rules

    @routing_rules.setter
    def routing_rules(self, routing_rules: List[RoutingRule]):
        """Sets the routing_rules of this RoutingInfo.


        :param routing_rules: The routing_rules of this RoutingInfo.
        :type routing_rules: List[RoutingRule]
        """
        if routing_rules is None:
            raise ValueError("Invalid value for `routing_rules`, must not be `None`")  # noqa: E501
        if routing_rules is not None and len(routing_rules) < 1:
            raise ValueError("Invalid value for `routing_rules`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._routing_rules = routing_rules
