from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from capif_events import util
from capif_events.models.base_model import Model
from capif_events.models.buffered_notifications_action import BufferedNotificationsAction  # noqa: E501
from capif_events.models.subscription_action import SubscriptionAction  # noqa: E501


class MutingExceptionInstructions(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, buffered_notifs=None, subscription=None):  # noqa: E501
        """MutingExceptionInstructions - a model defined in OpenAPI

        :param buffered_notifs: The buffered_notifs of this MutingExceptionInstructions.  # noqa: E501
        :type buffered_notifs: BufferedNotificationsAction
        :param subscription: The subscription of this MutingExceptionInstructions.  # noqa: E501
        :type subscription: SubscriptionAction
        """
        self.openapi_types = {
            'buffered_notifs': BufferedNotificationsAction,
            'subscription': SubscriptionAction
        }

        self.attribute_map = {
            'buffered_notifs': 'bufferedNotifs',
            'subscription': 'subscription'
        }

        self._buffered_notifs = buffered_notifs
        self._subscription = subscription

    @classmethod
    def from_dict(cls, dikt) -> 'MutingExceptionInstructions':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The MutingExceptionInstructions of this MutingExceptionInstructions.  # noqa: E501
        :rtype: MutingExceptionInstructions
        """
        return util.deserialize_model(dikt, cls)

    @property
    def buffered_notifs(self) -> BufferedNotificationsAction:
        """Gets the buffered_notifs of this MutingExceptionInstructions.


        :return: The buffered_notifs of this MutingExceptionInstructions.
        :rtype: BufferedNotificationsAction
        """
        return self._buffered_notifs

    @buffered_notifs.setter
    def buffered_notifs(self, buffered_notifs: BufferedNotificationsAction):
        """Sets the buffered_notifs of this MutingExceptionInstructions.


        :param buffered_notifs: The buffered_notifs of this MutingExceptionInstructions.
        :type buffered_notifs: BufferedNotificationsAction
        """

        self._buffered_notifs = buffered_notifs

    @property
    def subscription(self) -> SubscriptionAction:
        """Gets the subscription of this MutingExceptionInstructions.


        :return: The subscription of this MutingExceptionInstructions.
        :rtype: SubscriptionAction
        """
        return self._subscription

    @subscription.setter
    def subscription(self, subscription: SubscriptionAction):
        """Sets the subscription of this MutingExceptionInstructions.


        :param subscription: The subscription of this MutingExceptionInstructions.
        :type subscription: SubscriptionAction
        """

        self._subscription = subscription
