import re  # noqa: E501
from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from capif_events import util
from capif_events.models.base_model import Model
from capif_events.models.capif_event import CAPIFEvent  # noqa: E501
from capif_events.models.capif_event_filter import CAPIFEventFilter  # noqa: E501
from capif_events.models.reporting_information import ReportingInformation  # noqa: E501
from capif_events.models.websock_notif_config import WebsockNotifConfig  # noqa: E501


class EventSubscription(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, events=None, event_filters=None, event_req=None, notification_destination=None, request_test_notification=None, websock_notif_config=None, supported_features=None):  # noqa: E501
        """EventSubscription - a model defined in OpenAPI

        :param events: The events of this EventSubscription.  # noqa: E501
        :type events: List[CAPIFEvent]
        :param event_filters: The event_filters of this EventSubscription.  # noqa: E501
        :type event_filters: List[CAPIFEventFilter]
        :param event_req: The event_req of this EventSubscription.  # noqa: E501
        :type event_req: ReportingInformation
        :param notification_destination: The notification_destination of this EventSubscription.  # noqa: E501
        :type notification_destination: str
        :param request_test_notification: The request_test_notification of this EventSubscription.  # noqa: E501
        :type request_test_notification: bool
        :param websock_notif_config: The websock_notif_config of this EventSubscription.  # noqa: E501
        :type websock_notif_config: WebsockNotifConfig
        :param supported_features: The supported_features of this EventSubscription.  # noqa: E501
        :type supported_features: str
        """
        self.openapi_types = {
            'events': List[CAPIFEvent],
            'event_filters': List[CAPIFEventFilter],
            'event_req': ReportingInformation,
            'notification_destination': str,
            'request_test_notification': bool,
            'websock_notif_config': WebsockNotifConfig,
            'supported_features': str
        }

        self.attribute_map = {
            'events': 'events',
            'event_filters': 'eventFilters',
            'event_req': 'eventReq',
            'notification_destination': 'notificationDestination',
            'request_test_notification': 'requestTestNotification',
            'websock_notif_config': 'websockNotifConfig',
            'supported_features': 'supportedFeatures'
        }

        self._events = events
        self._event_filters = event_filters
        self._event_req = event_req
        self._notification_destination = notification_destination
        self._request_test_notification = request_test_notification
        self._websock_notif_config = websock_notif_config
        self._supported_features = supported_features

    
    @classmethod
    def from_dict(cls, dikt) -> 'EventSubscription':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The EventSubscription of this EventSubscription.  # noqa: E501
        :rtype: EventSubscription
        """
        return util.deserialize_model(dikt, cls)

    @property
    def events(self) -> List[CAPIFEvent]:
        """Gets the events of this EventSubscription.

        Subscribed events  # noqa: E501

        :return: The events of this EventSubscription.
        :rtype: List[CAPIFEvent]
        """
        return self._events

    @events.setter
    def events(self, events: List[CAPIFEvent]):
        """Sets the events of this EventSubscription.

        Subscribed events  # noqa: E501

        :param events: The events of this EventSubscription.
        :type events: List[CAPIFEvent]
        """
        if events is None:
            raise ValueError("Invalid value for `events`, must not be `None`")  # noqa: E501
        if events is not None and len(events) < 1:
            raise ValueError("Invalid value for `events`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._events = events

    @property
    def event_filters(self) -> List[CAPIFEventFilter]:
        """Gets the event_filters of this EventSubscription.

        Subscribed event filters  # noqa: E501

        :return: The event_filters of this EventSubscription.
        :rtype: List[CAPIFEventFilter]
        """
        return self._event_filters

    @event_filters.setter
    def event_filters(self, event_filters: List[CAPIFEventFilter]):
        """Sets the event_filters of this EventSubscription.

        Subscribed event filters  # noqa: E501

        :param event_filters: The event_filters of this EventSubscription.
        :type event_filters: List[CAPIFEventFilter]
        """
        if event_filters is not None and len(event_filters) < 1:
            raise ValueError("Invalid value for `event_filters`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._event_filters = event_filters

    @property
    def event_req(self) -> ReportingInformation:
        """Gets the event_req of this EventSubscription.


        :return: The event_req of this EventSubscription.
        :rtype: ReportingInformation
        """
        return self._event_req

    @event_req.setter
    def event_req(self, event_req: ReportingInformation):
        """Sets the event_req of this EventSubscription.


        :param event_req: The event_req of this EventSubscription.
        :type event_req: ReportingInformation
        """

        self._event_req = event_req

    @property
    def notification_destination(self) -> str:
        """Gets the notification_destination of this EventSubscription.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :return: The notification_destination of this EventSubscription.
        :rtype: str
        """
        return self._notification_destination

    @notification_destination.setter
    def notification_destination(self, notification_destination: str):
        """Sets the notification_destination of this EventSubscription.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :param notification_destination: The notification_destination of this EventSubscription.
        :type notification_destination: str
        """
        if notification_destination is None:
            raise ValueError("Invalid value for `notification_destination`, must not be `None`")  # noqa: E501

        self._notification_destination = notification_destination

    @property
    def request_test_notification(self) -> bool:
        """Gets the request_test_notification of this EventSubscription.

        Set to true by Subscriber to request the CAPIF core function to send a test notification as defined in in clause 7.6. Set to false or omitted otherwise.   # noqa: E501

        :return: The request_test_notification of this EventSubscription.
        :rtype: bool
        """
        return self._request_test_notification

    @request_test_notification.setter
    def request_test_notification(self, request_test_notification: bool):
        """Sets the request_test_notification of this EventSubscription.

        Set to true by Subscriber to request the CAPIF core function to send a test notification as defined in in clause 7.6. Set to false or omitted otherwise.   # noqa: E501

        :param request_test_notification: The request_test_notification of this EventSubscription.
        :type request_test_notification: bool
        """

        self._request_test_notification = request_test_notification

    @property
    def websock_notif_config(self) -> WebsockNotifConfig:
        """Gets the websock_notif_config of this EventSubscription.


        :return: The websock_notif_config of this EventSubscription.
        :rtype: WebsockNotifConfig
        """
        return self._websock_notif_config

    @websock_notif_config.setter
    def websock_notif_config(self, websock_notif_config: WebsockNotifConfig):
        """Sets the websock_notif_config of this EventSubscription.


        :param websock_notif_config: The websock_notif_config of this EventSubscription.
        :type websock_notif_config: WebsockNotifConfig
        """

        self._websock_notif_config = websock_notif_config

    @property
    def supported_features(self) -> str:
        """Gets the supported_features of this EventSubscription.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The supported_features of this EventSubscription.
        :rtype: str
        """
        return self._supported_features

    @supported_features.setter
    def supported_features(self, supported_features: str):
        """Sets the supported_features of this EventSubscription.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param supported_features: The supported_features of this EventSubscription.
        :type supported_features: str
        """
        if supported_features is not None and not re.search(r'^[A-Fa-f0-9]*$', supported_features):  # noqa: E501
            raise ValueError(r"Invalid value for `supported_features`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._supported_features = supported_features
