from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from capif_events import util
from capif_events.models.base_model import Model
from capif_events.models.capif_event import CAPIFEvent  # noqa: E501
from capif_events.models.capif_event_detail import CAPIFEventDetail  # noqa: E501


class EventNotification(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, subscription_id=None, events=None, event_detail=None):  # noqa: E501
        """EventNotification - a model defined in OpenAPI

        :param subscription_id: The subscription_id of this EventNotification.  # noqa: E501
        :type subscription_id: str
        :param events: The events of this EventNotification.  # noqa: E501
        :type events: CAPIFEvent
        :param event_detail: The event_detail of this EventNotification.  # noqa: E501
        :type event_detail: CAPIFEventDetail
        """
        self.openapi_types = {
            'subscription_id': str,
            'events': CAPIFEvent,
            'event_detail': CAPIFEventDetail
        }

        self.attribute_map = {
            'subscription_id': 'subscriptionId',
            'events': 'events',
            'event_detail': 'eventDetail'
        }

        self._subscription_id = subscription_id
        self._events = events
        self._event_detail = event_detail

    @classmethod
    def from_dict(cls, dikt) -> 'EventNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The EventNotification of this EventNotification.  # noqa: E501
        :rtype: EventNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def subscription_id(self) -> str:
        """Gets the subscription_id of this EventNotification.

        Identifier of the subscription resource to which the notification is related – CAPIF resource identifier   # noqa: E501

        :return: The subscription_id of this EventNotification.
        :rtype: str
        """
        return self._subscription_id

    @subscription_id.setter
    def subscription_id(self, subscription_id: str):
        """Sets the subscription_id of this EventNotification.

        Identifier of the subscription resource to which the notification is related – CAPIF resource identifier   # noqa: E501

        :param subscription_id: The subscription_id of this EventNotification.
        :type subscription_id: str
        """
        if subscription_id is None:
            raise ValueError("Invalid value for `subscription_id`, must not be `None`")  # noqa: E501

        self._subscription_id = subscription_id

    @property
    def events(self) -> CAPIFEvent:
        """Gets the events of this EventNotification.


        :return: The events of this EventNotification.
        :rtype: CAPIFEvent
        """
        return self._events

    @events.setter
    def events(self, events: CAPIFEvent):
        """Sets the events of this EventNotification.


        :param events: The events of this EventNotification.
        :type events: CAPIFEvent
        """
        if events is None:
            raise ValueError("Invalid value for `events`, must not be `None`")  # noqa: E501

        self._events = events

    @property
    def event_detail(self) -> CAPIFEventDetail:
        """Gets the event_detail of this EventNotification.


        :return: The event_detail of this EventNotification.
        :rtype: CAPIFEventDetail
        """
        return self._event_detail

    @event_detail.setter
    def event_detail(self, event_detail: CAPIFEventDetail):
        """Sets the event_detail of this EventNotification.


        :param event_detail: The event_detail of this EventNotification.
        :type event_detail: CAPIFEventDetail
        """

        self._event_detail = event_detail
