import re  # noqa: E501
from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from service_apis import util
from service_apis.models.base_model import Model


class ServiceKpis(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, max_req_rate=None, max_restime=None, availability=None, aval_comp=None, aval_gra_comp=None, aval_mem=None, aval_stor=None, con_band=None):  # noqa: E501
        """ServiceKpis - a model defined in OpenAPI

        :param max_req_rate: The max_req_rate of this ServiceKpis.  # noqa: E501
        :type max_req_rate: int
        :param max_restime: The max_restime of this ServiceKpis.  # noqa: E501
        :type max_restime: int
        :param availability: The availability of this ServiceKpis.  # noqa: E501
        :type availability: int
        :param aval_comp: The aval_comp of this ServiceKpis.  # noqa: E501
        :type aval_comp: str
        :param aval_gra_comp: The aval_gra_comp of this ServiceKpis.  # noqa: E501
        :type aval_gra_comp: str
        :param aval_mem: The aval_mem of this ServiceKpis.  # noqa: E501
        :type aval_mem: str
        :param aval_stor: The aval_stor of this ServiceKpis.  # noqa: E501
        :type aval_stor: str
        :param con_band: The con_band of this ServiceKpis.  # noqa: E501
        :type con_band: int
        """
        self.openapi_types = {
            'max_req_rate': int,
            'max_restime': int,
            'availability': int,
            'aval_comp': str,
            'aval_gra_comp': str,
            'aval_mem': str,
            'aval_stor': str,
            'con_band': int
        }

        self.attribute_map = {
            'max_req_rate': 'maxReqRate',
            'max_restime': 'maxRestime',
            'availability': 'availability',
            'aval_comp': 'avalComp',
            'aval_gra_comp': 'avalGraComp',
            'aval_mem': 'avalMem',
            'aval_stor': 'avalStor',
            'con_band': 'conBand'
        }

        self._max_req_rate = max_req_rate
        self._max_restime = max_restime
        self._availability = availability
        self._aval_comp = aval_comp
        self._aval_gra_comp = aval_gra_comp
        self._aval_mem = aval_mem
        self._aval_stor = aval_stor
        self._con_band = con_band

    @classmethod
    def from_dict(cls, dikt) -> 'ServiceKpis':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The ServiceKpis of this ServiceKpis.  # noqa: E501
        :rtype: ServiceKpis
        """
        return util.deserialize_model(dikt, cls)

    @property
    def max_req_rate(self) -> int:
        """Gets the max_req_rate of this ServiceKpis.

        Unsigned Integer, i.e. only value 0 and integers above 0 are permissible.  # noqa: E501

        :return: The max_req_rate of this ServiceKpis.
        :rtype: int
        """
        return self._max_req_rate

    @max_req_rate.setter
    def max_req_rate(self, max_req_rate: int):
        """Sets the max_req_rate of this ServiceKpis.

        Unsigned Integer, i.e. only value 0 and integers above 0 are permissible.  # noqa: E501

        :param max_req_rate: The max_req_rate of this ServiceKpis.
        :type max_req_rate: int
        """
        if max_req_rate is not None and max_req_rate < 0:  # noqa: E501
            raise ValueError("Invalid value for `max_req_rate`, must be a value greater than or equal to `0`")  # noqa: E501

        self._max_req_rate = max_req_rate

    @property
    def max_restime(self) -> int:
        """Gets the max_restime of this ServiceKpis.

        Unsigned integer identifying a period of time in units of seconds.  # noqa: E501

        :return: The max_restime of this ServiceKpis.
        :rtype: int
        """
        return self._max_restime

    @max_restime.setter
    def max_restime(self, max_restime: int):
        """Sets the max_restime of this ServiceKpis.

        Unsigned integer identifying a period of time in units of seconds.  # noqa: E501

        :param max_restime: The max_restime of this ServiceKpis.
        :type max_restime: int
        """
        if max_restime is not None and max_restime < 0:  # noqa: E501
            raise ValueError("Invalid value for `max_restime`, must be a value greater than or equal to `0`")  # noqa: E501

        self._max_restime = max_restime

    @property
    def availability(self) -> int:
        """Gets the availability of this ServiceKpis.

        Unsigned Integer, i.e. only value 0 and integers above 0 are permissible.  # noqa: E501

        :return: The availability of this ServiceKpis.
        :rtype: int
        """
        return self._availability

    @availability.setter
    def availability(self, availability: int):
        """Sets the availability of this ServiceKpis.

        Unsigned Integer, i.e. only value 0 and integers above 0 are permissible.  # noqa: E501

        :param availability: The availability of this ServiceKpis.
        :type availability: int
        """
        if availability is not None and availability < 0:  # noqa: E501
            raise ValueError("Invalid value for `availability`, must be a value greater than or equal to `0`")  # noqa: E501

        self._availability = availability

    @property
    def aval_comp(self) -> str:
        """Gets the aval_comp of this ServiceKpis.

        The maximum compute resource available in FLOPS for the API Invoker.   # noqa: E501

        :return: The aval_comp of this ServiceKpis.
        :rtype: str
        """
        return self._aval_comp

    @aval_comp.setter
    def aval_comp(self, aval_comp: str):
        """Sets the aval_comp of this ServiceKpis.

        The maximum compute resource available in FLOPS for the API Invoker.   # noqa: E501

        :param aval_comp: The aval_comp of this ServiceKpis.
        :type aval_comp: str
        """
        if aval_comp is not None and not re.search(r'^\d+(\.\d+)? (kFLOPS|MFLOPS|GFLOPS|TFLOPS|PFLOPS|EFLOPS|ZFLOPS)$', aval_comp):  # noqa: E501
            raise ValueError(r"Invalid value for `aval_comp`, must be a follow pattern or equal to `/^\d+(\.\d+)? (kFLOPS|MFLOPS|GFLOPS|TFLOPS|PFLOPS|EFLOPS|ZFLOPS)$/`")  # noqa: E501

        self._aval_comp = aval_comp

    @property
    def aval_gra_comp(self) -> str:
        """Gets the aval_gra_comp of this ServiceKpis.

        The maximum graphical compute resource in FLOPS available for the API Invoker.   # noqa: E501

        :return: The aval_gra_comp of this ServiceKpis.
        :rtype: str
        """
        return self._aval_gra_comp

    @aval_gra_comp.setter
    def aval_gra_comp(self, aval_gra_comp: str):
        """Sets the aval_gra_comp of this ServiceKpis.

        The maximum graphical compute resource in FLOPS available for the API Invoker.   # noqa: E501

        :param aval_gra_comp: The aval_gra_comp of this ServiceKpis.
        :type aval_gra_comp: str
        """
        if aval_gra_comp is not None and not re.search(r'^\d+(\.\d+)? (kFLOPS|MFLOPS|GFLOPS|TFLOPS|PFLOPS|EFLOPS|ZFLOPS)$', aval_gra_comp):  # noqa: E501
            raise ValueError(r"Invalid value for `aval_gra_comp`, must be a follow pattern or equal to `/^\d+(\.\d+)? (kFLOPS|MFLOPS|GFLOPS|TFLOPS|PFLOPS|EFLOPS|ZFLOPS)$/`")  # noqa: E501

        self._aval_gra_comp = aval_gra_comp

    @property
    def aval_mem(self) -> str:
        """Gets the aval_mem of this ServiceKpis.

        The maximum memory resource available for the API Invoker.   # noqa: E501

        :return: The aval_mem of this ServiceKpis.
        :rtype: str
        """
        return self._aval_mem

    @aval_mem.setter
    def aval_mem(self, aval_mem: str):
        """Sets the aval_mem of this ServiceKpis.

        The maximum memory resource available for the API Invoker.   # noqa: E501

        :param aval_mem: The aval_mem of this ServiceKpis.
        :type aval_mem: str
        """
        if aval_mem is not None and not re.search(r'^\d+(\.\d+)? (KB|MB|GB|TB|PB|EB|ZB|YB)$', aval_mem):  # noqa: E501
            raise ValueError(r"Invalid value for `aval_mem`, must be a follow pattern or equal to `/^\d+(\.\d+)? (KB|MB|GB|TB|PB|EB|ZB|YB)$/`")  # noqa: E501

        self._aval_mem = aval_mem

    @property
    def aval_stor(self) -> str:
        """Gets the aval_stor of this ServiceKpis.

        The maximum storage resource available for the API Invoker.   # noqa: E501

        :return: The aval_stor of this ServiceKpis.
        :rtype: str
        """
        return self._aval_stor

    @aval_stor.setter
    def aval_stor(self, aval_stor: str):
        """Sets the aval_stor of this ServiceKpis.

        The maximum storage resource available for the API Invoker.   # noqa: E501

        :param aval_stor: The aval_stor of this ServiceKpis.
        :type aval_stor: str
        """
        if aval_stor is not None and not re.search(r'^\d+(\.\d+)? (KB|MB|GB|TB|PB|EB|ZB|YB)$', aval_stor):  # noqa: E501
            raise ValueError(r"Invalid value for `aval_stor`, must be a follow pattern or equal to `/^\d+(\.\d+)? (KB|MB|GB|TB|PB|EB|ZB|YB)$/`")  # noqa: E501

        self._aval_stor = aval_stor

    @property
    def con_band(self) -> int:
        """Gets the con_band of this ServiceKpis.

        Unsigned Integer, i.e. only value 0 and integers above 0 are permissible.  # noqa: E501

        :return: The con_band of this ServiceKpis.
        :rtype: int
        """
        return self._con_band

    @con_band.setter
    def con_band(self, con_band: int):
        """Sets the con_band of this ServiceKpis.

        Unsigned Integer, i.e. only value 0 and integers above 0 are permissible.  # noqa: E501

        :param con_band: The con_band of this ServiceKpis.
        :type con_band: int
        """
        if con_band is not None and con_band < 0:  # noqa: E501
            raise ValueError("Invalid value for `con_band`, must be a value greater than or equal to `0`")  # noqa: E501

        self._con_band = con_band
