from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from service_apis import util
from service_apis.models.base_model import Model
from service_apis.models.geographic_area import GeographicArea  # noqa: E501
from service_apis.models.geographical_coordinates import GeographicalCoordinates  # noqa: E501


class LocalOrigin(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, coordinate_id=None, point=None, area=None, horiz_axes_orientation=None):  # noqa: E501
        """LocalOrigin - a model defined in OpenAPI

        :param coordinate_id: The coordinate_id of this LocalOrigin.  # noqa: E501
        :type coordinate_id: str
        :param point: The point of this LocalOrigin.  # noqa: E501
        :type point: GeographicalCoordinates
        :param area: The area of this LocalOrigin.  # noqa: E501
        :type area: GeographicArea
        :param horiz_axes_orientation: The horiz_axes_orientation of this LocalOrigin.  # noqa: E501
        :type horiz_axes_orientation: int
        """
        self.openapi_types = {
            'coordinate_id': str,
            'point': GeographicalCoordinates,
            'area': GeographicArea,
            'horiz_axes_orientation': int
        }

        self.attribute_map = {
            'coordinate_id': 'coordinateId',
            'point': 'point',
            'area': 'area',
            'horiz_axes_orientation': 'horizAxesOrientation'
        }

        self._coordinate_id = coordinate_id
        self._point = point
        self._area = area
        self._horiz_axes_orientation = horiz_axes_orientation

    @classmethod
    def from_dict(cls, dikt) -> 'LocalOrigin':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The LocalOrigin of this LocalOrigin.  # noqa: E501
        :rtype: LocalOrigin
        """
        return util.deserialize_model(dikt, cls)

    @property
    def coordinate_id(self) -> str:
        """Gets the coordinate_id of this LocalOrigin.


        :return: The coordinate_id of this LocalOrigin.
        :rtype: str
        """
        return self._coordinate_id

    @coordinate_id.setter
    def coordinate_id(self, coordinate_id: str):
        """Sets the coordinate_id of this LocalOrigin.


        :param coordinate_id: The coordinate_id of this LocalOrigin.
        :type coordinate_id: str
        """
        if coordinate_id is None:
            raise ValueError("Invalid value for `coordinate_id`, must not be `None`")  # noqa: E501

        self._coordinate_id = coordinate_id

    @property
    def point(self) -> GeographicalCoordinates:
        """Gets the point of this LocalOrigin.


        :return: The point of this LocalOrigin.
        :rtype: GeographicalCoordinates
        """
        return self._point

    @point.setter
    def point(self, point: GeographicalCoordinates):
        """Sets the point of this LocalOrigin.


        :param point: The point of this LocalOrigin.
        :type point: GeographicalCoordinates
        """

        self._point = point

    @property
    def area(self) -> GeographicArea:
        """Gets the area of this LocalOrigin.


        :return: The area of this LocalOrigin.
        :rtype: GeographicArea
        """
        return self._area

    @area.setter
    def area(self, area: GeographicArea):
        """Sets the area of this LocalOrigin.


        :param area: The area of this LocalOrigin.
        :type area: GeographicArea
        """

        self._area = area

    @property
    def horiz_axes_orientation(self) -> int:
        """Gets the horiz_axes_orientation of this LocalOrigin.

        Horizontal axes orientation angle clockwise from northing in 0.1 degrees.  # noqa: E501

        :return: The horiz_axes_orientation of this LocalOrigin.
        :rtype: int
        """
        return self._horiz_axes_orientation

    @horiz_axes_orientation.setter
    def horiz_axes_orientation(self, horiz_axes_orientation: int):
        """Sets the horiz_axes_orientation of this LocalOrigin.

        Horizontal axes orientation angle clockwise from northing in 0.1 degrees.  # noqa: E501

        :param horiz_axes_orientation: The horiz_axes_orientation of this LocalOrigin.
        :type horiz_axes_orientation: int
        """
        if horiz_axes_orientation is not None and horiz_axes_orientation > 3600:  # noqa: E501
            raise ValueError("Invalid value for `horiz_axes_orientation`, must be a value less than or equal to `3600`")  # noqa: E501
        if horiz_axes_orientation is not None and horiz_axes_orientation < 0:  # noqa: E501
            raise ValueError("Invalid value for `horiz_axes_orientation`, must be a value greater than or equal to `0`")  # noqa: E501

        self._horiz_axes_orientation = horiz_axes_orientation
