from flask import current_app, request

from ..core.provider_enrolment_details_api import ProviderManagementOperations
from ..models.api_provider_enrolment_details_patch import APIProviderEnrolmentDetailsPatch  # noqa: E501

provider_management_ops = ProviderManagementOperations()

def modify_ind_api_provider_enrolment(registration_id, body):  # noqa: E501
    """modify_ind_api_provider_enrolment

    Modify an individual API provider details. # noqa: E501

    :param registration_id: 
    :type registration_id: str
    :param api_provider_enrolment_details_patch: 
    :type api_provider_enrolment_details_patch: dict | bytes

    :rtype: Union[APIProviderEnrolmentDetails, Tuple[APIProviderEnrolmentDetails, int], Tuple[APIProviderEnrolmentDetails, int, Dict[str, str]]
    """
    current_app.logger.info("Patch Provider Domain")
    if request.is_json:
        body = APIProviderEnrolmentDetailsPatch.from_dict(request.get_json())  # noqa: E501

    res = provider_management_ops.update_api_provider_enrolment_details(registration_id, body)

    return res
