from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from api_invoker_management import util
from api_invoker_management.models.api_invoker_enrolment_details import APIInvokerEnrolmentDetails  # noqa: E501
from api_invoker_management.models.api_list import APIList  # noqa: E501
from api_invoker_management.models.base_model import Model


class OnboardingNotification(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, result=None, resource_location=None, api_invoker_enrolment_details=None, api_list=None):  # noqa: E501
        """OnboardingNotification - a model defined in OpenAPI

        :param result: The result of this OnboardingNotification.  # noqa: E501
        :type result: bool
        :param resource_location: The resource_location of this OnboardingNotification.  # noqa: E501
        :type resource_location: str
        :param api_invoker_enrolment_details: The api_invoker_enrolment_details of this OnboardingNotification.  # noqa: E501
        :type api_invoker_enrolment_details: APIInvokerEnrolmentDetails
        :param api_list: The api_list of this OnboardingNotification.  # noqa: E501
        :type api_list: APIList
        """
        self.openapi_types = {
            'result': bool,
            'resource_location': str,
            'api_invoker_enrolment_details': APIInvokerEnrolmentDetails,
            'api_list': APIList
        }

        self.attribute_map = {
            'result': 'result',
            'resource_location': 'resourceLocation',
            'api_invoker_enrolment_details': 'apiInvokerEnrolmentDetails',
            'api_list': 'apiList'
        }

        self._result = result
        self._resource_location = resource_location
        self._api_invoker_enrolment_details = api_invoker_enrolment_details
        self._api_list = api_list

    @classmethod
    def from_dict(cls, dikt) -> 'OnboardingNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The OnboardingNotification of this OnboardingNotification.  # noqa: E501
        :rtype: OnboardingNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def result(self) -> bool:
        """Gets the result of this OnboardingNotification.

        Set to \"true\" indicate successful on-boarding. Otherwise set to \"false\"  # noqa: E501

        :return: The result of this OnboardingNotification.
        :rtype: bool
        """
        return self._result

    @result.setter
    def result(self, result: bool):
        """Sets the result of this OnboardingNotification.

        Set to \"true\" indicate successful on-boarding. Otherwise set to \"false\"  # noqa: E501

        :param result: The result of this OnboardingNotification.
        :type result: bool
        """
        if result is None:
            raise ValueError("Invalid value for `result`, must not be `None`")  # noqa: E501

        self._result = result

    @property
    def resource_location(self) -> str:
        """Gets the resource_location of this OnboardingNotification.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :return: The resource_location of this OnboardingNotification.
        :rtype: str
        """
        return self._resource_location

    @resource_location.setter
    def resource_location(self, resource_location: str):
        """Sets the resource_location of this OnboardingNotification.

        string providing an URI formatted according to IETF RFC 3986.  # noqa: E501

        :param resource_location: The resource_location of this OnboardingNotification.
        :type resource_location: str
        """

        self._resource_location = resource_location

    @property
    def api_invoker_enrolment_details(self) -> APIInvokerEnrolmentDetails:
        """Gets the api_invoker_enrolment_details of this OnboardingNotification.


        :return: The api_invoker_enrolment_details of this OnboardingNotification.
        :rtype: APIInvokerEnrolmentDetails
        """
        return self._api_invoker_enrolment_details

    @api_invoker_enrolment_details.setter
    def api_invoker_enrolment_details(self, api_invoker_enrolment_details: APIInvokerEnrolmentDetails):
        """Sets the api_invoker_enrolment_details of this OnboardingNotification.


        :param api_invoker_enrolment_details: The api_invoker_enrolment_details of this OnboardingNotification.
        :type api_invoker_enrolment_details: APIInvokerEnrolmentDetails
        """

        self._api_invoker_enrolment_details = api_invoker_enrolment_details

    @property
    def api_list(self) -> APIList:
        """Gets the api_list of this OnboardingNotification.


        :return: The api_list of this OnboardingNotification.
        :rtype: APIList
        """
        return self._api_list

    @api_list.setter
    def api_list(self, api_list: APIList):
        """Sets the api_list of this OnboardingNotification.


        :param api_list: The api_list of this OnboardingNotification.
        :type api_list: APIList
        """

        self._api_list = api_list
