from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from api_invoker_management import util
from api_invoker_management.models.base_model import Model
from api_invoker_management.models.ipv4_address_range import Ipv4AddressRange  # noqa: E501
from api_invoker_management.models.ipv6_address_range import Ipv6AddressRange  # noqa: E501


class IpAddrRange(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, ue_ipv4_addr_ranges=None, ue_ipv6_addr_ranges=None):  # noqa: E501
        """IpAddrRange - a model defined in OpenAPI

        :param ue_ipv4_addr_ranges: The ue_ipv4_addr_ranges of this IpAddrRange.  # noqa: E501
        :type ue_ipv4_addr_ranges: List[Ipv4AddressRange]
        :param ue_ipv6_addr_ranges: The ue_ipv6_addr_ranges of this IpAddrRange.  # noqa: E501
        :type ue_ipv6_addr_ranges: List[Ipv6AddressRange]
        """
        self.openapi_types = {
            'ue_ipv4_addr_ranges': List[Ipv4AddressRange],
            'ue_ipv6_addr_ranges': List[Ipv6AddressRange]
        }

        self.attribute_map = {
            'ue_ipv4_addr_ranges': 'ueIpv4AddrRanges',
            'ue_ipv6_addr_ranges': 'ueIpv6AddrRanges'
        }

        self._ue_ipv4_addr_ranges = ue_ipv4_addr_ranges
        self._ue_ipv6_addr_ranges = ue_ipv6_addr_ranges

    @classmethod
    def from_dict(cls, dikt) -> 'IpAddrRange':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The IpAddrRange of this IpAddrRange.  # noqa: E501
        :rtype: IpAddrRange
        """
        return util.deserialize_model(dikt, cls)

    @property
    def ue_ipv4_addr_ranges(self) -> List[Ipv4AddressRange]:
        """Gets the ue_ipv4_addr_ranges of this IpAddrRange.

        Represents the IPv4 Address ranges of the UE(s).  # noqa: E501

        :return: The ue_ipv4_addr_ranges of this IpAddrRange.
        :rtype: List[Ipv4AddressRange]
        """
        return self._ue_ipv4_addr_ranges

    @ue_ipv4_addr_ranges.setter
    def ue_ipv4_addr_ranges(self, ue_ipv4_addr_ranges: List[Ipv4AddressRange]):
        """Sets the ue_ipv4_addr_ranges of this IpAddrRange.

        Represents the IPv4 Address ranges of the UE(s).  # noqa: E501

        :param ue_ipv4_addr_ranges: The ue_ipv4_addr_ranges of this IpAddrRange.
        :type ue_ipv4_addr_ranges: List[Ipv4AddressRange]
        """
        if ue_ipv4_addr_ranges is not None and len(ue_ipv4_addr_ranges) < 1:
            raise ValueError("Invalid value for `ue_ipv4_addr_ranges`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._ue_ipv4_addr_ranges = ue_ipv4_addr_ranges

    @property
    def ue_ipv6_addr_ranges(self) -> List[Ipv6AddressRange]:
        """Gets the ue_ipv6_addr_ranges of this IpAddrRange.

        Represents the Ipv6 Address ranges of the UE(s).  # noqa: E501

        :return: The ue_ipv6_addr_ranges of this IpAddrRange.
        :rtype: List[Ipv6AddressRange]
        """
        return self._ue_ipv6_addr_ranges

    @ue_ipv6_addr_ranges.setter
    def ue_ipv6_addr_ranges(self, ue_ipv6_addr_ranges: List[Ipv6AddressRange]):
        """Sets the ue_ipv6_addr_ranges of this IpAddrRange.

        Represents the Ipv6 Address ranges of the UE(s).  # noqa: E501

        :param ue_ipv6_addr_ranges: The ue_ipv6_addr_ranges of this IpAddrRange.
        :type ue_ipv6_addr_ranges: List[Ipv6AddressRange]
        """
        if ue_ipv6_addr_ranges is not None and len(ue_ipv6_addr_ranges) < 1:
            raise ValueError("Invalid value for `ue_ipv6_addr_ranges`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._ue_ipv6_addr_ranges = ue_ipv6_addr_ranges
