from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from api_invoker_management import util
from api_invoker_management.models.base_model import Model
from api_invoker_management.models.service_api_description import ServiceAPIDescription  # noqa: E501


class APIList(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, service_api_descriptions=None):  # noqa: E501
        """APIList - a model defined in OpenAPI

        :param service_api_descriptions: The service_api_descriptions of this APIList.  # noqa: E501
        :type service_api_descriptions: List[ServiceAPIDescription]
        """
        self.openapi_types = {
            'service_api_descriptions': List[ServiceAPIDescription]
        }

        self.attribute_map = {
            'service_api_descriptions': 'serviceAPIDescriptions'
        }

        self._service_api_descriptions = service_api_descriptions

    @classmethod
    def from_dict(cls, dikt) -> 'APIList':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The APIList of this APIList.  # noqa: E501
        :rtype: APIList
        """
        return util.deserialize_model(dikt, cls)

    @property
    def service_api_descriptions(self) -> List[ServiceAPIDescription]:
        """Gets the service_api_descriptions of this APIList.

        Represents the list of service APIs that the API Invoker is allowed to invoke.  # noqa: E501

        :return: The service_api_descriptions of this APIList.
        :rtype: List[ServiceAPIDescription]
        """
        return self._service_api_descriptions

    @service_api_descriptions.setter
    def service_api_descriptions(self, service_api_descriptions: List[ServiceAPIDescription]):
        """Sets the service_api_descriptions of this APIList.

        Represents the list of service APIs that the API Invoker is allowed to invoke.  # noqa: E501

        :param service_api_descriptions: The service_api_descriptions of this APIList.
        :type service_api_descriptions: List[ServiceAPIDescription]
        """
        if service_api_descriptions is not None and len(service_api_descriptions) < 1:
            raise ValueError("Invalid value for `service_api_descriptions`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._service_api_descriptions = service_api_descriptions
