from flask import current_app, request
from functools import wraps
from cryptography import x509
from cryptography.hazmat.backends import default_backend

from ..core.apiinvokerenrolmentdetails import InvokerManagementOperations
from ..core.validate_user import ControlAccess
from api_invoker_management.models.api_invoker_enrolment_details_patch import \
    APIInvokerEnrolmentDetailsPatch  # noqa: E501

invoker_operations = InvokerManagementOperations()
valid_user = ControlAccess()


def cert_validation():
    def _cert_validation(f):
        @wraps(f)
        def __cert_validation(*args, **kwargs):

            args = request.view_args
            cert_tmp = request.headers['X-Ssl-Client-Cert']
            cert_raw = cert_tmp.replace('\t', '')

            cert = x509.load_pem_x509_certificate(str.encode(cert_raw), default_backend())

            cn = cert.subject.get_attributes_for_oid(x509.OID_COMMON_NAME)[0].value.strip()

            if cn != "superadmin":
                cert_signature = cert.signature.hex()
                result = valid_user.validate_user_cert(args["onboardingId"], cert_signature)

                if result is not None:
                    return result

            result = f(**kwargs)
            return result
        return __cert_validation
    return _cert_validation


@cert_validation()
def modify_ind_api_invoke_enrolment(onboarding_id, body):  # noqa: E501
    """modify_ind_api_invoke_enrolment

    Modify an individual API invoker details. # noqa: E501

    :param onboarding_id: 
    :type onboarding_id: str
    :param api_invoker_enrolment_details_patch: 
    :type api_invoker_enrolment_details_patch: dict | bytes

    :rtype: Union[APIInvokerEnrolmentDetails, Tuple[APIInvokerEnrolmentDetails, int], Tuple[APIInvokerEnrolmentDetails, int, Dict[str, str]]
    """
    current_app.logger.info("Updating invoker")
    if request.is_json:
        body = APIInvokerEnrolmentDetailsPatch.from_dict(request.get_json())  # noqa: E501

    res = invoker_operations.patch_apiinvokerenrolmentdetail(onboarding_id, body)

    return res

