from datetime import date, datetime  # noqa: F401
from typing import Dict, List  # noqa: F401

from api_provider_management import util
from api_provider_management.models.api_provider_function_details import APIProviderFunctionDetails  # noqa: E501
from api_provider_management.models.base_model import Model


class APIProviderEnrolmentDetailsPatch(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_prov_funcs=None, api_prov_dom_info=None):  # noqa: E501
        """APIProviderEnrolmentDetailsPatch - a model defined in OpenAPI

        :param api_prov_funcs: The api_prov_funcs of this APIProviderEnrolmentDetailsPatch.  # noqa: E501
        :type api_prov_funcs: List[APIProviderFunctionDetails]
        :param api_prov_dom_info: The api_prov_dom_info of this APIProviderEnrolmentDetailsPatch.  # noqa: E501
        :type api_prov_dom_info: str
        """
        self.openapi_types = {
            'api_prov_funcs': List[APIProviderFunctionDetails],
            'api_prov_dom_info': str
        }

        self.attribute_map = {
            'api_prov_funcs': 'apiProvFuncs',
            'api_prov_dom_info': 'apiProvDomInfo'
        }

        self._api_prov_funcs = api_prov_funcs
        self._api_prov_dom_info = api_prov_dom_info

    @classmethod
    def from_dict(cls, dikt) -> 'APIProviderEnrolmentDetailsPatch':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The APIProviderEnrolmentDetailsPatch of this APIProviderEnrolmentDetailsPatch.  # noqa: E501
        :rtype: APIProviderEnrolmentDetailsPatch
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_prov_funcs(self) -> List[APIProviderFunctionDetails]:
        """Gets the api_prov_funcs of this APIProviderEnrolmentDetailsPatch.

        A list of individual API provider domain functions details. When included by the API management function in the HTTP request message, it lists the API provider domain functions that the API management function intends to register/update in registration or update registration procedure.    # noqa: E501

        :return: The api_prov_funcs of this APIProviderEnrolmentDetailsPatch.
        :rtype: List[APIProviderFunctionDetails]
        """
        return self._api_prov_funcs

    @api_prov_funcs.setter
    def api_prov_funcs(self, api_prov_funcs: List[APIProviderFunctionDetails]):
        """Sets the api_prov_funcs of this APIProviderEnrolmentDetailsPatch.

        A list of individual API provider domain functions details. When included by the API management function in the HTTP request message, it lists the API provider domain functions that the API management function intends to register/update in registration or update registration procedure.    # noqa: E501

        :param api_prov_funcs: The api_prov_funcs of this APIProviderEnrolmentDetailsPatch.
        :type api_prov_funcs: List[APIProviderFunctionDetails]
        """
        if api_prov_funcs is not None and len(api_prov_funcs) < 1:
            raise ValueError("Invalid value for `api_prov_funcs`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._api_prov_funcs = api_prov_funcs

    @property
    def api_prov_dom_info(self) -> str:
        """Gets the api_prov_dom_info of this APIProviderEnrolmentDetailsPatch.

        Generic information related to the API provider domain such as details of the API provider applications.   # noqa: E501

        :return: The api_prov_dom_info of this APIProviderEnrolmentDetailsPatch.
        :rtype: str
        """
        return self._api_prov_dom_info

    @api_prov_dom_info.setter
    def api_prov_dom_info(self, api_prov_dom_info: str):
        """Sets the api_prov_dom_info of this APIProviderEnrolmentDetailsPatch.

        Generic information related to the API provider domain such as details of the API provider applications.   # noqa: E501

        :param api_prov_dom_info: The api_prov_dom_info of this APIProviderEnrolmentDetailsPatch.
        :type api_prov_dom_info: str
        """

        self._api_prov_dom_info = api_prov_dom_info
