from flask import Flask, request
import logging
from logging.handlers import RotatingFileHandler
import os

app = Flask(__name__)

# Lista para almacenar las solicitudes recibidas
requests_received = []

def verbose_formatter():
    return logging.Formatter(
        '{"timestamp": "%(asctime)s", "level": "%(levelname)s", "logger": "%(name)s", "function": "%(funcName)s", "line": %(lineno)d, "message": %(message)s}',
        datefmt='%d/%m/%Y %H:%M:%S'
    )


def configure_logging(app):
    del app.logger.handlers[:]
    loggers = [app.logger, ]
    handlers = []
    console_handler = logging.StreamHandler()
    console_handler.setLevel(logging.DEBUG)
    console_handler.setFormatter(verbose_formatter())
    file_handler = RotatingFileHandler(filename="mock_server.log", maxBytes=1024 * 1024 * 100, backupCount=20)
    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(verbose_formatter())
    handlers.append(console_handler)
    handlers.append(file_handler)
  

    for l in loggers:
        for handler in handlers:
            l.addHandler(handler)
        l.propagate = False
        l.setLevel(logging.DEBUG)

@app.route('/testing', methods=['POST', 'GET'])
def index():
    if request.method == 'POST':
        app.logger.debug(request.json)
        app.logger.debug(request.headers)
        requests_received.append(request.json)
    return 'Mock Server is running'

@app.route('/requests_list', methods=['GET','DELETE'])
def requests_list():
    if request.method == 'DELETE':
        requests_received.clear()
    return requests_received


configure_logging(app)

if __name__ == '__main__':
    app.run(host=os.environ.get("IP",'0.0.0.0'),port=os.environ.get("PORT",9090),debug=True)
