from ..models.problem_details import ProblemDetails
from ..encoder import JSONEncoder
from ..util import dict_to_camel_case, clean_empty
from flask import Response, current_app
import json

mimetype = "application/json"


def make_response(object, status):
    res = Response(json.dumps(object, cls=JSONEncoder), status=status, mimetype=mimetype)

    return res


def internal_server_error(detail, cause):
    # prob = ProblemDetails(type="http://www.ietf.org/rfc/rfc2396.txt", instance="http://www.ietf.org/rfc/rfc2396.txt", title="Internal Server Error", status=500, detail=detail, cause=cause, invalid_params=[{"param":"","reason":""}], supported_features="fffff")
    prob = ProblemDetails(title="Internal Server Error", status=500, detail=detail, cause=cause)

    prob = prob.to_dict()
    prob = clean_empty(prob)

    return Response(json.dumps(dict_to_camel_case(prob), cls=JSONEncoder), status=500, mimetype=mimetype)


def forbidden_error(detail, cause):
    prob = ProblemDetails(title="Forbidden", status=403, detail=detail, cause=cause)

    prob = prob.to_dict()
    prob = clean_empty(prob)

    # return Response(json.dumps(dict_to_camel_case(prob.to_dict()), cls=JSONEncoder), status=403, mimetype=mimetype)
    return Response(json.dumps(dict_to_camel_case(prob), cls=JSONEncoder), status=403, mimetype=mimetype)


def bad_request_error(detail, cause, invalid_params):
    # prob = ProblemDetails(type="http://www.ietf.org/rfc/rfc2396.txt", instance="http://www.ietf.org/rfc/rfc2396.txt", title="Bad Request", status=400, detail=detail, cause=cause, invalid_params=invalid_params, supported_features="fffff")
    prob = ProblemDetails(title="Bad Request", status=400, detail=detail, cause=cause, invalid_params=invalid_params)

    prob = prob.to_dict()
    prob = clean_empty(prob)

    return Response(json.dumps(dict_to_camel_case(prob), cls=JSONEncoder), status=400, mimetype=cause)


def not_found_error(detail, cause):
    # prob = ProblemDetails(type="http://www.ietf.org/rfc/rfc2396.txt", instance="http://www.ietf.org/rfc/rfc2396.txt", title="Not Found", status=404, detail=detail, cause=cause, invalid_params=[{"param":"","reason":""}], supported_features="fffff")
    prob = ProblemDetails(title="Not Found", status=404, detail=detail, cause=cause)

    prob = prob.to_dict()
    prob = clean_empty(prob)

    return Response(json.dumps(dict_to_camel_case(prob), cls=JSONEncoder), status=404, mimetype=mimetype)