[**[Return To All Test Plans]**]

- [Test Plan for CAPIF Api Access Control Policy](#test-plan-for-capif-api-access-control-policy)
- [Tests](#tests)
  - [Test Case 1: Retrieve ACL](#test-case-1-retrieve-acl)
  - [Test Case 2: Retrieve ACL with 2 Service APIs published](#test-case-2-retrieve-acl-with-2-service-apis-published)
  - [Test Case 3: Retrieve ACL with security context created by two different Invokers](#test-case-3-retrieve-acl-with-security-context-created-by-two-different-invokers)
  - [Test Case 4: Retrieve ACL filtered by api-invoker-id](#test-case-4-retrieve-acl-filtered-by-api-invoker-id)
  - [Test Case 5: Retrieve ACL filtered by supported-features](#test-case-5-retrieve-acl-filtered-by-supported-features)
  - [Test Case 6: Retrieve ACL with aef-id not valid](#test-case-6-retrieve-acl-with-aef-id-not-valid)
  - [Test Case 7: Retrieve ACL with service-id not valid](#test-case-7-retrieve-acl-with-service-id-not-valid)
  - [Test Case 8: Retrieve ACL with service-api-id and aef-id not valid](#test-case-8-retrieve-acl-with-service-api-id-and-aef-id-not-valid)
  - [Test Case 9: Retrieve ACL without SecurityContext created previously by Invoker](#test-case-9-retrieve-acl-without-securitycontext-created-previously-by-invoker)
  - [Test Case 10: Retrieve ACL filtered by api-invoker-id not present](#test-case-10-retrieve-acl-filtered-by-api-invoker-id-not-present)
  - [Test Case 11: Retrieve ACL with APF Certificate](#test-case-11-retrieve-acl-with-apf-certificate)
  - [Test Case 12: Retrieve ACL with AMF Certificate](#test-case-12-retrieve-acl-with-amf-certificate)
  - [Test Case 13: Retrieve ACL with Invoker Certificate](#test-case-13-retrieve-acl-with-invoker-certificate)
  - [Test Case 14: No ACL for invoker after be removed](#test-case-14-no-acl-for-invoker-after-be-removed)

 


# Test Plan for CAPIF Api Access Control Policy
At this documentation you will have all information and related files and examples of test plan for this API.

# Tests

## Test Case 1: Retrieve ACL
* **Test ID**: ***capif_api_acl-1***
* **Description**:
  
  This test case will check that an API Provider can retrieve ACL from CAPIF
* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}*
     * Use *serviceApiId* and *aefId*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.
   
* **Expected Result**:

  1. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. contain only one object.
        2. apiInvokerId must match apiInvokerId registered previously.


## Test Case 2: Retrieve ACL with 2 Service APIs published
* **Test ID**: ***capif_api_acl-2***
* **Description**:
  
  This test case will check that an API Provider can retrieve ACL from CAPIF for 2 different serviceApis published.
* **Pre-Conditions**:
  
  * API Provider had two Service API Published on CAPIF
  * API Invoker had a Security Context for both Service APIs published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate

  3. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_2
     * Store *serviceApiId*
     * Use APF Certificate
  
  4. Perform [Invoker Onboarding] store apiInvokerId
  5. Discover published APIs
  6. Create Security Context for this Invoker for both published APIs
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  7. Provider Retrieve ACL for serviceApiId1
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId1}?aef-id=${aef_id}*
     * Use *serviceApiId* and *aefId*
     * Use AEF Provider Certificate

  8. Provider Retrieve ACL for serviceApiId2
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId2}?aef-id=${aef_id}*
     * Use *serviceApiId* and *aefId*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1 and service_2
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information for service_1.
  7. Provider Get ACL information for service_2.
   
* **Expected Result**:

  1. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. contain one object.
        2. apiInvokerId must match apiInvokerId registered previously.

## Test Case 3: Retrieve ACL with security context created by two different Invokers
* **Test ID**: ***capif_api_acl-3***
* **Description**:
  
  This test case will check that an API Provider can retrieve ACL from CAPIF containing 2 objects.
* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * Two API Invokers had a Security Context for same Service API published by provider.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker for both published APIs
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Repeat previous 3 steps in order to have a new Invoker.

  7. Provider Retrieve ACL for serviceApiId
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId1}?aef-id=${aef_id}*
     * Use *serviceApiId* and *aefId*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1 and service_2
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.
   
* **Expected Result**:

  1. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. Contain two objects.
        2. One object must match with apiInvokerId1 and the other one with apiInvokerId2 an registered previously.
   
## Test Case 4: Retrieve ACL filtered by api-invoker-id
* **Test ID**: ***capif_api_acl-4***
* **Description**:
  
  This test case will check that an API Provider can retrieve ACL filtering by apiInvokerId from CAPIF containing 1 objects.
* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * Two API Invokers had a Security Context for same Service API published by provider.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  4. Perform [Invoker Onboarding] store apiInvokerId
  6. Discover published APIs
  7. Create Security Context for this Invoker for both published APIs
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  8. Repeat previous 3 steps in order to have a new Invoker.

  9. Provider Retrieve ACL for serviceApiId
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId1}?aef-id=${aef_id}&api-invoker-id={apiInvokerId1}*
     * Use *serviceApiId*, *aefId* and apiInvokerId1
     * Use AEF Provider Certificate

  10. Provider Retrieve ACL for serviceApiId
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId1}?aef-id=${aef_id}&api-invoker-id={apiInvokerId2}*
     * Use *serviceApiId*, *aefId* and apiInvokerId2
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1 and service_2
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information with query parameter indicating first api-invoker-id.
  7. Provider Get ACL information with query parameter indicating second api-invoker-id.
   
* **Expected Result**:

  1. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. Contain one objects.
        2. Object must match with apiInvokerId1.

  2. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. Contain one objects.
        2. Object must match with apiInvokerId2.

## Test Case 5: Retrieve ACL filtered by supported-features
* **Test ID**: ***capif_api_acl-5***
* **Description**:
  **CURRENTLY NOT SUPPORTED FEATURE**
  
  This test case will check that an API Provider can retrieve ACL filtering by supportedFeatures from CAPIF containing 1 objects.

* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * Two API Invokers had a Security Context for same Service API published by provider.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker for both published APIs
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Repeat previous 3 steps in order to have a new Invoker.

  7. Provider Retrieve ACL for serviceApiId
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId1}?aef-id=${aef_id}&supported-features={apiInvokerId1}*
     * Use *serviceApiId*, *aefId* and apiInvokerId1
     * Use AEF Provider Certificate

  8.  Provider Retrieve ACL for serviceApiId
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId1}?aef-id=${aef_id}&supported-features={apiInvokerId2}*
     * Use *serviceApiId*, *aefId* and apiInvokerId2
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1 and service_2
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information with query parameter indicating first supported-features.
  7. Provider Get ACL information with query parameter indicating second supported-features.
   
* **Expected Result**:

  1. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. Contain one objects.
        2. Object must match with supportedFeatures1.

  2. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. Contain one objects.
        2. Object must match with supportedFeatures1.


## Test Case 6: Retrieve ACL with aef-id not valid
* **Test ID**: ***capif_api_acl-6***
* **Description**:
  
  This test case will check that an API Provider can't retrieve ACL from CAPIF if aef-id is not valid
* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${AEF_ID_NOT_VALID}*
     * Use *serviceApiId* and *AEF_ID_NOT_VALID*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.
   
* **Expected Result**:

  1. ACL Response:
     1. **404 Not Found** Response.
     2. body returned must accomplish **Problem Details** data structure.
     3. apiInvokerPolicies must:
        * status **404**
        * title with message "Not Found"
        * detail with message "No ACLs found for the requested service: {service_api_id}, aef_id: {aef_id}, invoker: {api_invoker_id} and supportedFeatures: {supported_features}".
        * cause with message "Wrong id".


## Test Case 7: Retrieve ACL with service-id not valid
* **Test ID**: ***capif_api_acl-7***
* **Description**:
  
  This test case will check that an API Provider can't retrieve ACL from CAPIF if service-api-id is not valid
* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${NOT_VALID_SERVICE_API_ID}?aef-id=${aef_id}*
     * Use *NOT_VALID_SERVICE_API_ID* and *aef_id*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.
   
* **Expected Result**:

  1. ACL Response:
     1. **404 Not Found** Response.
     2. body returned must accomplish **Problem Details** data structure.
     3. apiInvokerPolicies must:
        * status **404**
        * title with message "Not Found"
        * detail with message "No ACLs found for the requested service: {service_api_id}, aef_id: {aef_id}, invoker: {api_invoker_id} and supportedFeatures: {supported_features}".
        * cause with message "Wrong id".

## Test Case 8: Retrieve ACL with service-api-id and aef-id not valid
* **Test ID**: ***capif_api_acl-8***
* **Description**:
  
  This test case will check that an API Provider can't retrieve ACL from CAPIF if service-api-id and aef-id are not valid
* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${NOT_VALID_SERVICE_API_ID}?aef-id=${AEF_ID_NOT_VALID}*
     * Use *NOT_VALID_SERVICE_API_ID* and *aef_id*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.
   
* **Expected Result**:

  1. ACL Response:
     1. **404 Not Found** Response.
     2. body returned must accomplish **Problem Details** data structure.
     3. apiInvokerPolicies must:
        * status **404**
        * title with message "Not Found"
        * detail with message "No ACLs found for the requested service: {NOT_VALID_SERVICE_API_ID}, aef_id: {AEF_ID_NOT_VALID}, invoker: {api_invoker_id} and supportedFeatures: {supported_features}".
        * cause with message "Wrong id".


## Test Case 9: Retrieve ACL without SecurityContext created previously by Invoker
* **Test ID**: ***capif_api_acl-9***
* **Description**:
  
  This test case will check that an API Provider can't retrieve ACL if no invoker had requested Security Context to CAPIF
* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * API Invoker created but no Security Context for Service API published had been requested.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs

  5. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}*
     * Use *serviceApiId* and *aefId*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.
   
* **Expected Result**:

  1. ACL Response:
     1. **404 Not Found** Response.
     2. body returned must accomplish **Problem Details** data structure.
     3. apiInvokerPolicies must:
        * status **404**
        * title with message "Not Found"
        * detail with message "No ACLs found for the requested service: {NOT_VALID_SERVICE_API_ID}, aef_id: {AEF_ID_NOT_VALID}, invoker: {api_invoker_id} and supportedFeatures: {supported_features}".
        * cause with message "Wrong id".

## Test Case 10: Retrieve ACL filtered by api-invoker-id not present
* **Test ID**: ***capif_api_acl-10***
* **Description**:
  
  This test case will check that an API Provider get not found response if filter by not valid api-invoker-id doesn't match any registered ACL.
* **Pre-Conditions**:
  
  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}&api-invoker-id={NOT_VALID_API_INVOKER_ID}*
     * Use *serviceApiId*, *aefId* and *NOT_VALID_API_INVOKER_ID*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.
   
* **Expected Result**:

  1. ACL Response:
     1. **404 Not Found** Response.
     2. body returned must accomplish **Problem Details** data structure.
     3. apiInvokerPolicies must:
        * status **404**
        * title with message "Not Found"
        * detail with message "No ACLs found for the requested service: {NOT_VALID_SERVICE_API_ID}, aef_id: {AEF_ID_NOT_VALID}, invoker: {api_invoker_id} and supportedFeatures: {supported_features}".
        * cause with message "Wrong id".

## Test Case 11: Retrieve ACL with APF Certificate
* **Test ID**: ***capif_api_acl-11***
* **Description**:

  This test case will check that an API Provider can't retrieve ACL from CAPIF using APF Certificate
* **Pre-Conditions**:

  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate

  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}*
     * Use *serviceApiId* and *aefId*
     * Use APF Provider Certificate

* **Execution Steps**:

  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.

* **Expected Result**:

  1. Response to Logging Service must accomplish:
     1. **401 Unauthorized**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 401
        * title with message "Unauthorized"
        * detail with message "Role not authorized for this API route".
        * cause with message "Certificate not authorized".

## Test Case 12: Retrieve ACL with AMF Certificate
* **Test ID**: ***capif_api_acl-12***
* **Description**:

  This test case will check that an API Provider can't retrieve ACL from CAPIF using AMF Certificate
* **Pre-Conditions**:

  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate

  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}*
     * Use *serviceApiId* and *aefId*
     * Use AMF Provider Certificate

* **Execution Steps**:

  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.

* **Expected Result**:

  1. Response to Logging Service must accomplish:
     1. **401 Unauthorized**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 401
        * title with message "Unauthorized"
        * detail with message "Role not authorized for this API route".
        * cause with message "Certificate not authorized".

## Test Case 13: Retrieve ACL with Invoker Certificate
* **Test ID**: ***capif_api_acl-13***
* **Description**:

  This test case will check that an API Provider can't retrieve ACL from CAPIF using Invoker Certificate
* **Pre-Conditions**:

  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published.

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate

  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}*
     * Use *serviceApiId* and *aefId*
     * Use Invoker Certificate

* **Execution Steps**:

  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information.

* **Expected Result**:

  1. Response to Logging Service must accomplish:
     1. **401 Unauthorized**
     2. Error Response Body must accomplish with **ProblemDetails** data structure with:
        * status 401
        * title with message "Unauthorized"
        * detail with message "Role not authorized for this API route".
        * cause with message "Certificate not authorized".

## Test Case 14: No ACL for invoker after be removed
* **Test ID**: ***capif_api_acl-14***
* **Description**:

  This test case will check that ACLs are removed after invoker is removed.
* **Pre-Conditions**:

  * API Provider had a Service API Published on CAPIF
  * API Invoker had a Security Context for Service API published and ACL is present

* **Information of Test**:

  1. Perform [Provider Registration]

  2. Publish Service API at CCF:
     * Send Post to ccf_publish_url *https://{CAPIF_HOSTNAME}/published-apis/v1/{apfId}/service-apis*
     * body [service api description] with apiName service_1
     * Store *serviceApiId*
     * Use APF Certificate
  
  3. Perform [Invoker Onboarding] store apiInvokerId
  4. Discover published APIs
  5. Create Security Context for this Invoker
     * Send PUT *https://{CAPIF_HOSTNAME}/trustedInvokers/{apiInvokerId}*
     * body [service security body]
     * Use Invoker Certificate

  6. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}&api-invoker-id={api-invoker-id}*
     * Use *serviceApiId*, *aefId* and *api-invoker-id*
     * Use AEF Provider Certificate
  7. Remove Invoker from CAPIF
  8. Provider Retrieve ACL
     * Send GET *https://{CAPIF_HOSTNAME}/access-control-policy/v1/accessControlPolicyList/${serviceApiId}?aef-id=${aef_id}&api-invoker-id={api-invoker-id}*
     * Use *serviceApiId*, *aefId* and *api-invoker-id*
     * Use AEF Provider Certificate

* **Execution Steps**:
  
  1. Register and onboard Provider at CCF.
  2. Publish a provider API with name service_1
  3. Register and onboard Invoker at CCF
  4. Store signed Certificate
  5. Create Security Context
  6. Provider Get ACL information of invoker.
  7. Remove Invoker from CAPIF.
  8. Provider Get ACL information of invoker.
   
* **Expected Result**:
  1. ACL Response:
     1. **200 OK** Response.
     2. body returned must accomplish **AccessControlPolicyList** data structure.
     3. apiInvokerPolicies must:
        1. contain only one object.
        2. apiInvokerId must match apiInvokerId registered previously.

  2. ACL Response:
     1. **404 Not Found** Response.
     2. body returned must accomplish **Problem Details** data structure.
     3. apiInvokerPolicies must:
        * status **404**
        * title with message "Not Found"
        * detail with message "No ACLs found for the requested service: {NOT_VALID_SERVICE_API_ID}, aef_id: {AEF_ID_NOT_VALID}, invoker: None and supportedFeatures: None".
        * cause with message "Wrong id".



[Return To All Test Plans]: ../README.md

[service api description]: ../api_publish_service/service_api_description_post_example.json  "Service API Description Request"
[publisher register body]: ../api_publish_service/publisher_register_body.json  "Publish register Body"
[service security body]: ./service_security.json  "Service Security Request"
[security notification body]: ./security_notification.json  "Security Notification Request"
[access token req body]: ./access_token_req.json  "Access Token Request"
[example]: ./access_token_req.json  "Access Token Request Example"
[invoker onboarding]: ../common_operations/README.md#register-an-invoker "Invoker Onboarding"
[provider registration]: ../common_operations/README.md#register-a-provider "Provider Registration"
