from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from api_invoker_management import util
from api_invoker_management.models.base_model import Model
from api_invoker_management.models.ipv6_addr1 import Ipv6Addr1  # noqa: E501


class Ipv6AddressRange(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, start=None, end=None):  # noqa: E501
        """Ipv6AddressRange - a model defined in OpenAPI

        :param start: The start of this Ipv6AddressRange.  # noqa: E501
        :type start: Ipv6Addr1
        :param end: The end of this Ipv6AddressRange.  # noqa: E501
        :type end: Ipv6Addr1
        """
        self.openapi_types = {
            'start': Ipv6Addr1,
            'end': Ipv6Addr1
        }

        self.attribute_map = {
            'start': 'start',
            'end': 'end'
        }

        self._start = start
        self._end = end

    @classmethod
    def from_dict(cls, dikt) -> 'Ipv6AddressRange':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Ipv6AddressRange of this Ipv6AddressRange.  # noqa: E501
        :rtype: Ipv6AddressRange
        """
        return util.deserialize_model(dikt, cls)

    @property
    def start(self) -> Ipv6Addr1:
        """Gets the start of this Ipv6AddressRange.


        :return: The start of this Ipv6AddressRange.
        :rtype: Ipv6Addr1
        """
        return self._start

    @start.setter
    def start(self, start: Ipv6Addr1):
        """Sets the start of this Ipv6AddressRange.


        :param start: The start of this Ipv6AddressRange.
        :type start: Ipv6Addr1
        """
        if start is None:
            raise ValueError("Invalid value for `start`, must not be `None`")  # noqa: E501

        self._start = start

    @property
    def end(self) -> Ipv6Addr1:
        """Gets the end of this Ipv6AddressRange.


        :return: The end of this Ipv6AddressRange.
        :rtype: Ipv6Addr1
        """
        return self._end

    @end.setter
    def end(self, end: Ipv6Addr1):
        """Sets the end of this Ipv6AddressRange.


        :param end: The end of this Ipv6AddressRange.
        :type end: Ipv6Addr1
        """
        if end is None:
            raise ValueError("Invalid value for `end`, must not be `None`")  # noqa: E501

        self._end = end
