from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from capif_events import util
from capif_events.models.access_control_policy_list_ext import AccessControlPolicyListExt  # noqa: E501
from capif_events.models.base_model import Model
from capif_events.models.invocation_log import InvocationLog  # noqa: E501
from capif_events.models.service_api_description import ServiceAPIDescription  # noqa: E501
from capif_events.models.topology_hiding import TopologyHiding  # noqa: E501


class CAPIFEventDetail(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, service_api_descriptions=None, api_ids=None, api_invoker_ids=None, acc_ctrl_pol_list=None, invocation_logs=None, api_topo_hide=None):  # noqa: E501
        """CAPIFEventDetail - a model defined in OpenAPI

        :param service_api_descriptions: The service_api_descriptions of this CAPIFEventDetail.  # noqa: E501
        :type service_api_descriptions: List[ServiceAPIDescription]
        :param api_ids: The api_ids of this CAPIFEventDetail.  # noqa: E501
        :type api_ids: List[str]
        :param api_invoker_ids: The api_invoker_ids of this CAPIFEventDetail.  # noqa: E501
        :type api_invoker_ids: List[str]
        :param acc_ctrl_pol_list: The acc_ctrl_pol_list of this CAPIFEventDetail.  # noqa: E501
        :type acc_ctrl_pol_list: AccessControlPolicyListExt
        :param invocation_logs: The invocation_logs of this CAPIFEventDetail.  # noqa: E501
        :type invocation_logs: List[InvocationLog]
        :param api_topo_hide: The api_topo_hide of this CAPIFEventDetail.  # noqa: E501
        :type api_topo_hide: TopologyHiding
        """
        self.openapi_types = {
            'service_api_descriptions': List[ServiceAPIDescription],
            'api_ids': List[str],
            'api_invoker_ids': List[str],
            'acc_ctrl_pol_list': AccessControlPolicyListExt,
            'invocation_logs': List[InvocationLog],
            'api_topo_hide': TopologyHiding
        }

        self.attribute_map = {
            'service_api_descriptions': 'serviceAPIDescriptions',
            'api_ids': 'apiIds',
            'api_invoker_ids': 'apiInvokerIds',
            'acc_ctrl_pol_list': 'accCtrlPolList',
            'invocation_logs': 'invocationLogs',
            'api_topo_hide': 'apiTopoHide'
        }

        self._service_api_descriptions = service_api_descriptions
        self._api_ids = api_ids
        self._api_invoker_ids = api_invoker_ids
        self._acc_ctrl_pol_list = acc_ctrl_pol_list
        self._invocation_logs = invocation_logs
        self._api_topo_hide = api_topo_hide

    @classmethod
    def from_dict(cls, dikt) -> 'CAPIFEventDetail':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The CAPIFEventDetail of this CAPIFEventDetail.  # noqa: E501
        :rtype: CAPIFEventDetail
        """
        return util.deserialize_model(dikt, cls)

    @property
    def service_api_descriptions(self) -> List[ServiceAPIDescription]:
        """Gets the service_api_descriptions of this CAPIFEventDetail.

        Description of the service API as published by the APF.  # noqa: E501

        :return: The service_api_descriptions of this CAPIFEventDetail.
        :rtype: List[ServiceAPIDescription]
        """
        return self._service_api_descriptions

    @service_api_descriptions.setter
    def service_api_descriptions(self, service_api_descriptions: List[ServiceAPIDescription]):
        """Sets the service_api_descriptions of this CAPIFEventDetail.

        Description of the service API as published by the APF.  # noqa: E501

        :param service_api_descriptions: The service_api_descriptions of this CAPIFEventDetail.
        :type service_api_descriptions: List[ServiceAPIDescription]
        """
        if service_api_descriptions is not None and len(service_api_descriptions) < 1:
            raise ValueError("Invalid value for `service_api_descriptions`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._service_api_descriptions = service_api_descriptions

    @property
    def api_ids(self) -> List[str]:
        """Gets the api_ids of this CAPIFEventDetail.

        Identifier of the service API  # noqa: E501

        :return: The api_ids of this CAPIFEventDetail.
        :rtype: List[str]
        """
        return self._api_ids

    @api_ids.setter
    def api_ids(self, api_ids: List[str]):
        """Sets the api_ids of this CAPIFEventDetail.

        Identifier of the service API  # noqa: E501

        :param api_ids: The api_ids of this CAPIFEventDetail.
        :type api_ids: List[str]
        """
        if api_ids is not None and len(api_ids) < 1:
            raise ValueError("Invalid value for `api_ids`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._api_ids = api_ids

    @property
    def api_invoker_ids(self) -> List[str]:
        """Gets the api_invoker_ids of this CAPIFEventDetail.

        Identity of the API invoker  # noqa: E501

        :return: The api_invoker_ids of this CAPIFEventDetail.
        :rtype: List[str]
        """
        return self._api_invoker_ids

    @api_invoker_ids.setter
    def api_invoker_ids(self, api_invoker_ids: List[str]):
        """Sets the api_invoker_ids of this CAPIFEventDetail.

        Identity of the API invoker  # noqa: E501

        :param api_invoker_ids: The api_invoker_ids of this CAPIFEventDetail.
        :type api_invoker_ids: List[str]
        """
        if api_invoker_ids is not None and len(api_invoker_ids) < 1:
            raise ValueError("Invalid value for `api_invoker_ids`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._api_invoker_ids = api_invoker_ids

    @property
    def acc_ctrl_pol_list(self) -> AccessControlPolicyListExt:
        """Gets the acc_ctrl_pol_list of this CAPIFEventDetail.


        :return: The acc_ctrl_pol_list of this CAPIFEventDetail.
        :rtype: AccessControlPolicyListExt
        """
        return self._acc_ctrl_pol_list

    @acc_ctrl_pol_list.setter
    def acc_ctrl_pol_list(self, acc_ctrl_pol_list: AccessControlPolicyListExt):
        """Sets the acc_ctrl_pol_list of this CAPIFEventDetail.


        :param acc_ctrl_pol_list: The acc_ctrl_pol_list of this CAPIFEventDetail.
        :type acc_ctrl_pol_list: AccessControlPolicyListExt
        """

        self._acc_ctrl_pol_list = acc_ctrl_pol_list

    @property
    def invocation_logs(self) -> List[InvocationLog]:
        """Gets the invocation_logs of this CAPIFEventDetail.

        Invocation logs.  # noqa: E501

        :return: The invocation_logs of this CAPIFEventDetail.
        :rtype: List[InvocationLog]
        """
        return self._invocation_logs

    @invocation_logs.setter
    def invocation_logs(self, invocation_logs: List[InvocationLog]):
        """Sets the invocation_logs of this CAPIFEventDetail.

        Invocation logs.  # noqa: E501

        :param invocation_logs: The invocation_logs of this CAPIFEventDetail.
        :type invocation_logs: List[InvocationLog]
        """
        if invocation_logs is not None and len(invocation_logs) < 1:
            raise ValueError("Invalid value for `invocation_logs`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._invocation_logs = invocation_logs

    @property
    def api_topo_hide(self) -> TopologyHiding:
        """Gets the api_topo_hide of this CAPIFEventDetail.


        :return: The api_topo_hide of this CAPIFEventDetail.
        :rtype: TopologyHiding
        """
        return self._api_topo_hide

    @api_topo_hide.setter
    def api_topo_hide(self, api_topo_hide: TopologyHiding):
        """Sets the api_topo_hide of this CAPIFEventDetail.


        :param api_topo_hide: The api_topo_hide of this CAPIFEventDetail.
        :type api_topo_hide: TopologyHiding
        """

        self._api_topo_hide = api_topo_hide
