from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from service_apis import util
from service_apis.models.base_model import Model
from service_apis.models.service_api_description import ServiceAPIDescription  # noqa: E501


class DiscoveredAPIs(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, service_api_descriptions=None):  # noqa: E501
        """DiscoveredAPIs - a model defined in OpenAPI

        :param service_api_descriptions: The service_api_descriptions of this DiscoveredAPIs.  # noqa: E501
        :type service_api_descriptions: List[ServiceAPIDescription]
        """
        self.openapi_types = {
            'service_api_descriptions': List[ServiceAPIDescription]
        }

        self.attribute_map = {
            'service_api_descriptions': 'serviceAPIDescriptions'
        }

        self._service_api_descriptions = service_api_descriptions

    @classmethod
    def from_dict(cls, dikt) -> 'DiscoveredAPIs':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The DiscoveredAPIs of this DiscoveredAPIs.  # noqa: E501
        :rtype: DiscoveredAPIs
        """
        return util.deserialize_model(dikt, cls)

    @property
    def service_api_descriptions(self) -> List[ServiceAPIDescription]:
        """Gets the service_api_descriptions of this DiscoveredAPIs.

        Description of the service API as published by the service. Each service API description shall include AEF profiles matching the filter criteria.   # noqa: E501

        :return: The service_api_descriptions of this DiscoveredAPIs.
        :rtype: List[ServiceAPIDescription]
        """
        return self._service_api_descriptions

    @service_api_descriptions.setter
    def service_api_descriptions(self, service_api_descriptions: List[ServiceAPIDescription]):
        """Sets the service_api_descriptions of this DiscoveredAPIs.

        Description of the service API as published by the service. Each service API description shall include AEF profiles matching the filter criteria.   # noqa: E501

        :param service_api_descriptions: The service_api_descriptions of this DiscoveredAPIs.
        :type service_api_descriptions: List[ServiceAPIDescription]
        """
        if service_api_descriptions is not None and len(service_api_descriptions) < 1:
            raise ValueError("Invalid value for `service_api_descriptions`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._service_api_descriptions = service_api_descriptions
