import re  # noqa: E501
from datetime import date, datetime  # noqa: F401
from typing import List, Dict  # noqa: F401

from logs import util
from logs.models.base_model import Model
from logs.models.invocation_log import InvocationLog  # noqa: E501


class InvocationLogs(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, multiple_invocation_logs=None, supported_features=None):  # noqa: E501
        """InvocationLogs - a model defined in OpenAPI

        :param multiple_invocation_logs: The multiple_invocation_logs of this InvocationLogs.  # noqa: E501
        :type multiple_invocation_logs: List[InvocationLog]
        :param supported_features: The supported_features of this InvocationLogs.  # noqa: E501
        :type supported_features: str
        """
        self.openapi_types = {
            'multiple_invocation_logs': List[InvocationLog],
            'supported_features': str
        }

        self.attribute_map = {
            'multiple_invocation_logs': 'multipleInvocationLogs',
            'supported_features': 'supportedFeatures'
        }

        self._multiple_invocation_logs = multiple_invocation_logs
        self._supported_features = supported_features

    @classmethod
    def from_dict(cls, dikt) -> 'InvocationLogs':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The InvocationLogs of this InvocationLogs.  # noqa: E501
        :rtype: InvocationLogs
        """
        return util.deserialize_model(dikt, cls)

    @property
    def multiple_invocation_logs(self) -> List[InvocationLog]:
        """Gets the multiple_invocation_logs of this InvocationLogs.


        :return: The multiple_invocation_logs of this InvocationLogs.
        :rtype: List[InvocationLog]
        """
        return self._multiple_invocation_logs

    @multiple_invocation_logs.setter
    def multiple_invocation_logs(self, multiple_invocation_logs: List[InvocationLog]):
        """Sets the multiple_invocation_logs of this InvocationLogs.


        :param multiple_invocation_logs: The multiple_invocation_logs of this InvocationLogs.
        :type multiple_invocation_logs: List[InvocationLog]
        """
        if multiple_invocation_logs is None:
            raise ValueError("Invalid value for `multiple_invocation_logs`, must not be `None`")  # noqa: E501
        if multiple_invocation_logs is not None and len(multiple_invocation_logs) < 1:
            raise ValueError("Invalid value for `multiple_invocation_logs`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._multiple_invocation_logs = multiple_invocation_logs

    @property
    def supported_features(self) -> str:
        """Gets the supported_features of this InvocationLogs.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :return: The supported_features of this InvocationLogs.
        :rtype: str
        """
        return self._supported_features

    @supported_features.setter
    def supported_features(self, supported_features: str):
        """Sets the supported_features of this InvocationLogs.

        A string used to indicate the features supported by an API that is used as defined in clause  6.6 in 3GPP TS 29.500. The string shall contain a bitmask indicating supported features in  hexadecimal representation Each character in the string shall take a value of \"0\" to \"9\",  \"a\" to \"f\" or \"A\" to \"F\" and shall represent the support of 4 features as described in  table 5.2.2-3. The most significant character representing the highest-numbered features shall  appear first in the string, and the character representing features 1 to 4 shall appear last  in the string. The list of features and their numbering (starting with 1) are defined  separately for each API. If the string contains a lower number of characters than there are  defined features for an API, all features that would be represented by characters that are not  present in the string are not supported.   # noqa: E501

        :param supported_features: The supported_features of this InvocationLogs.
        :type supported_features: str
        """
        if supported_features is not None and not re.search(r'^[A-Fa-f0-9]*$', supported_features):  # noqa: E501
            raise ValueError("Invalid value for `supported_features`, must be a follow pattern or equal to `/^[A-Fa-f0-9]*$/`")  # noqa: E501

        self._supported_features = supported_features
