# Common API Framework (CAPIF)

- [Common API Framework (CAPIF)](#common-api-framework-capif)
- [Repository structure](#repository-structure)
- [CAPIF\_API\_Services](#capif_api_services)
  - [How to run CAPIF services in this Repository](#how-to-run-capif-services-in-this-repository)
    - [Run All CAPIF Services locally with Docker images](#run-all-capif-services-locally-with-docker-images)
    - [Run All CAPIF Services locally with Docker images and deploy monitoring stack](#run-all-capif-services-locally-with-docker-images-and-deploy-monitoring-stack)
    - [Run each service using Docker](#run-each-service-using-docker)
    - [Run each service using Python](#run-each-service-using-python)
- [How to test CAPIF APIs](#how-to-test-capif-apis)
  - [Test Plan Documentation](#test-plan-documentation)
  - [Robot Framework](#robot-framework)
  - [Using Curl](#using-curl)
  - [Using PostMan](#using-postman)
- [Important urls:](#important-urls)
  - [Mongo DB Dashboard](#mongo-db-dashboard)
- [FAQ Documentation](#faq-documentation)
- [CAPIF Release 0](#capif-release-0)


# Repository structure

```
CAPIF_API_Services
└───docs
│    └───test_plan
│    └───testing_with_postman
└───services
└───tests
└───tools
    └───robot
    └───open_api_script
```
* **services**: Services developed following CAPIF API specifications. Also, other complementary services (e.g., NGINX and JWTauth services for the authentication of API consuming entities).
* **tools**: Auxiliary tools. Robot Framework related code and OpenAPI scripts.
* **test**: Tests developed using Robot Framework.

* **docs**: Documents related to the code in the repository.
  * images: images used in the repository
  * test_plan: test plan descriptions for each API service referring to the test that are executed with the Robot Framework.
  * testing_with_postman: auxiliary JSON file needed for the Postman-based examples.

# CAPIF_API_Services
This repository has the python-flask Mockup servers created with openapi-generator related with CAPIF APIS defined here:
[Open API Descriptions of 3GPP 5G APIs]

## How to run CAPIF services in this Repository
Capif services are developed under /service/ folder.

### Run All CAPIF Services locally with Docker images
To run using docker and docker compose, version 2.10 or higher, you must ensure you have that tools installed at your machine. Also to simplify the process, we have 3 script to control docker images to deploy, check and cleanup.

To run all CAPIF APIs locally using docker and docker-compose you can execute:
```
cd services/

./run.sh
```
This will build and run all services using docker images, including mongodb and nginx locally and in background, and import ca.crt to nginx.

Nginx deployed by default use **capifcore** hostname, but can add a parameter when run.sh is executed setting a different hostname, for example,
```
./run.sh openshift.evolved-5g.eu
```

If you want to check if all CAPIF services are running properly in local machine after execute run.sh, we can use:
```
./check_services_are_running.sh
```
This shell script will return 0 if all services are running properly.

When we need to stop CAPIF services, we can use next bash script:
```
./clean_capif_docker_services.sh
```

or also the next script:
```
./stop.sh
```

This shell script will remove and clean all CAPIF services started previously with run.sh

### Run All CAPIF Services locally with Docker images and deploy monitoring stack
It is now possible to deploy a monitoring stack for CAPIF with Grafana, Prometheus, FluentBit, Loki, Cadvisor, Tempo and Opentelemetry.

To deploy CAPIF together with the monitoring stack, it is only necessary to execute the following.

```
./run.sh --m true
```

After they have been built, the different panels can be consulted in Grafana at the url

```
http:<0.0.0.0>:3000
```

By default, the monitoring option is set to false. Once up, all data sources and dashboards are automatically provisioned

### Run each service using Docker

Also you can run service by service using docker:
```
cd <Service>
docker build -t capif_security .
docker run -p 8080:8080 capif_security
```

### Run each service using Python

Run using python
```
cd <Service>
pip3 install -r requirements.txt
python3 -m <service>
```

# How to test CAPIF APIs
The above APIs can be tested either with "curl" command, POSTMAN tool or running developed tests with Robot Framework.
## Test Plan Documentation

Complete documentation of tests is here: [Test Plan Directory]
## Robot Framework

In order to ensure modifications over CAPIF services still accomplish the required functionality, Robot Framework test suite must be success.

Test suite implemented accomplish requirements described under test plan at [Test Plan Directory] folder.

Please go to [Testing with Robot Framework] Section

## Using Curl

Please go to [Testing Using Curl] section.

## Using PostMan
You can test the CAPIF flow using the Postman tool. To do this, we have created a collection with some examples of CAPIF requests with everything necessary to carry them out.

For more information on how to test the APIs with POSTMAN, follow this [Document](docs/testing_with_postman/README.md).
Also you have here the [POSTMAN Collection](docs/testing_with_postman/CAPIF.postman_collection.json)

# Important urls:

## Mongo DB Dashboard
```
http://0.0.0.0:8082/ (if accessed from localhost) 

or

http://<Mongo Express Host IP>:8082/ (if accessed from another host)
```
# FAQ Documentation

Frequently asked questions can be found here: [FAQ Directory]

# CAPIF Release 0

The APIs included in release 0 are:
- JWT Authentication APIs
- CAPIF Invoker Management API
- CAPIF Publish API
- CAPIF Discover API
- CAPIF Security API
- CAPIF Events API
- CAPIF Provider Management API

Testing Suite of all services with robot.
Also Postman suite to a simple test.



[Open API Descriptions of 3GPP 5G APIs]: https://forge.3gpp.org/rep/all/5G_APIs  "Open API Descriptions of 3GPP 5G APIs"
[Test Plan Directory]: ./docs/test_plan/README.md  "Test Plan Directory"
[Testing Using Curl]: ./docs/testing_with_curl/README.md  "Testing Using Curl"
[Testing with Robot Framework]: ./docs/testing_with_robot/README.md  "Testing with Robot Framework"
[FAQ Directory]: ./FAQ.md "FAQ directory"