from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_security.models.base_model import Model
from capif_security import util


class AccessTokenRsp(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, access_token=None, token_type=None, expires_in=None, scope=None):  # noqa: E501
        """AccessTokenRsp - a model defined in OpenAPI

        :param access_token: The access_token of this AccessTokenRsp.  # noqa: E501
        :type access_token: str
        :param token_type: The token_type of this AccessTokenRsp.  # noqa: E501
        :type token_type: str
        :param expires_in: The expires_in of this AccessTokenRsp.  # noqa: E501
        :type expires_in: int
        :param scope: The scope of this AccessTokenRsp.  # noqa: E501
        :type scope: str
        """
        self.openapi_types = {
            'access_token': str,
            'token_type': str,
            'expires_in': int,
            'scope': str
        }

        self.attribute_map = {
            'access_token': 'access_token',
            'token_type': 'token_type',
            'expires_in': 'expires_in',
            'scope': 'scope'
        }

        self._access_token = access_token
        self._token_type = token_type
        self._expires_in = expires_in
        self._scope = scope

    @classmethod
    def from_dict(cls, dikt) -> 'AccessTokenRsp':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AccessTokenRsp of this AccessTokenRsp.  # noqa: E501
        :rtype: AccessTokenRsp
        """
        return util.deserialize_model(dikt, cls)

    @property
    def access_token(self) -> str:
        """Gets the access_token of this AccessTokenRsp.

        JWS Compact Serialized representation of JWS signed JSON object (AccessTokenClaims)   # noqa: E501

        :return: The access_token of this AccessTokenRsp.
        :rtype: str
        """
        return self._access_token

    @access_token.setter
    def access_token(self, access_token: str):
        """Sets the access_token of this AccessTokenRsp.

        JWS Compact Serialized representation of JWS signed JSON object (AccessTokenClaims)   # noqa: E501

        :param access_token: The access_token of this AccessTokenRsp.
        :type access_token: str
        """
        if access_token is None:
            raise ValueError("Invalid value for `access_token`, must not be `None`")  # noqa: E501

        self._access_token = access_token

    @property
    def token_type(self) -> str:
        """Gets the token_type of this AccessTokenRsp.


        :return: The token_type of this AccessTokenRsp.
        :rtype: str
        """
        return self._token_type

    @token_type.setter
    def token_type(self, token_type: str):
        """Sets the token_type of this AccessTokenRsp.


        :param token_type: The token_type of this AccessTokenRsp.
        :type token_type: str
        """
        allowed_values = ["Bearer"]  # noqa: E501
        if token_type not in allowed_values:
            raise ValueError(
                "Invalid value for `token_type` ({0}), must be one of {1}"
                .format(token_type, allowed_values)
            )

        self._token_type = token_type

    @property
    def expires_in(self) -> int:
        """Gets the expires_in of this AccessTokenRsp.

        Unsigned integer identifying a period of time in units of seconds.  # noqa: E501

        :return: The expires_in of this AccessTokenRsp.
        :rtype: int
        """
        return self._expires_in

    @expires_in.setter
    def expires_in(self, expires_in: int):
        """Sets the expires_in of this AccessTokenRsp.

        Unsigned integer identifying a period of time in units of seconds.  # noqa: E501

        :param expires_in: The expires_in of this AccessTokenRsp.
        :type expires_in: int
        """
        if expires_in is None:
            raise ValueError("Invalid value for `expires_in`, must not be `None`")  # noqa: E501
        if expires_in is not None and expires_in < 0:  # noqa: E501
            raise ValueError("Invalid value for `expires_in`, must be a value greater than or equal to `0`")  # noqa: E501

        self._expires_in = expires_in

    @property
    def scope(self) -> str:
        """Gets the scope of this AccessTokenRsp.


        :return: The scope of this AccessTokenRsp.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope: str):
        """Sets the scope of this AccessTokenRsp.


        :param scope: The scope of this AccessTokenRsp.
        :type scope: str
        """

        self._scope = scope
