from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_security.models.base_model import Model
from capif_security.models.nf_type import NFType
from capif_security.models.plmn_id import PlmnId
from capif_security.models.plmn_id_nid import PlmnIdNid
from capif_security.models.snssai import Snssai
import re
from capif_security import util

from capif_security.models.nf_type import NFType  # noqa: E501
from capif_security.models.plmn_id import PlmnId  # noqa: E501
from capif_security.models.plmn_id_nid import PlmnIdNid  # noqa: E501
from capif_security.models.snssai import Snssai  # noqa: E501
import re  # noqa: E501

class AccessTokenReq1(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, grant_type=None, nf_instance_id=None, nf_type=None, target_nf_type=None, scope=None, target_nf_instance_id=None, requester_plmn=None, requester_plmn_list=None, requester_snssai_list=None, requester_fqdn=None, requester_snpn_list=None, target_plmn=None, target_snpn=None, target_snssai_list=None, target_nsi_list=None, target_nf_set_id=None, target_nf_service_set_id=None, hnrf_access_token_uri=None, source_nf_instance_id=None):  # noqa: E501
        """AccessTokenReq1 - a model defined in OpenAPI

        :param grant_type: The grant_type of this AccessTokenReq1.  # noqa: E501
        :type grant_type: str
        :param nf_instance_id: The nf_instance_id of this AccessTokenReq1.  # noqa: E501
        :type nf_instance_id: str
        :param nf_type: The nf_type of this AccessTokenReq1.  # noqa: E501
        :type nf_type: NFType
        :param target_nf_type: The target_nf_type of this AccessTokenReq1.  # noqa: E501
        :type target_nf_type: NFType
        :param scope: The scope of this AccessTokenReq1.  # noqa: E501
        :type scope: str
        :param target_nf_instance_id: The target_nf_instance_id of this AccessTokenReq1.  # noqa: E501
        :type target_nf_instance_id: str
        :param requester_plmn: The requester_plmn of this AccessTokenReq1.  # noqa: E501
        :type requester_plmn: PlmnId
        :param requester_plmn_list: The requester_plmn_list of this AccessTokenReq1.  # noqa: E501
        :type requester_plmn_list: List[PlmnId]
        :param requester_snssai_list: The requester_snssai_list of this AccessTokenReq1.  # noqa: E501
        :type requester_snssai_list: List[Snssai]
        :param requester_fqdn: The requester_fqdn of this AccessTokenReq1.  # noqa: E501
        :type requester_fqdn: str
        :param requester_snpn_list: The requester_snpn_list of this AccessTokenReq1.  # noqa: E501
        :type requester_snpn_list: List[PlmnIdNid]
        :param target_plmn: The target_plmn of this AccessTokenReq1.  # noqa: E501
        :type target_plmn: PlmnId
        :param target_snpn: The target_snpn of this AccessTokenReq1.  # noqa: E501
        :type target_snpn: PlmnIdNid
        :param target_snssai_list: The target_snssai_list of this AccessTokenReq1.  # noqa: E501
        :type target_snssai_list: List[Snssai]
        :param target_nsi_list: The target_nsi_list of this AccessTokenReq1.  # noqa: E501
        :type target_nsi_list: List[str]
        :param target_nf_set_id: The target_nf_set_id of this AccessTokenReq1.  # noqa: E501
        :type target_nf_set_id: str
        :param target_nf_service_set_id: The target_nf_service_set_id of this AccessTokenReq1.  # noqa: E501
        :type target_nf_service_set_id: str
        :param hnrf_access_token_uri: The hnrf_access_token_uri of this AccessTokenReq1.  # noqa: E501
        :type hnrf_access_token_uri: str
        :param source_nf_instance_id: The source_nf_instance_id of this AccessTokenReq1.  # noqa: E501
        :type source_nf_instance_id: str
        """
        self.openapi_types = {
            'grant_type': str,
            'nf_instance_id': str,
            'nf_type': NFType,
            'target_nf_type': NFType,
            'scope': str,
            'target_nf_instance_id': str,
            'requester_plmn': PlmnId,
            'requester_plmn_list': List[PlmnId],
            'requester_snssai_list': List[Snssai],
            'requester_fqdn': str,
            'requester_snpn_list': List[PlmnIdNid],
            'target_plmn': PlmnId,
            'target_snpn': PlmnIdNid,
            'target_snssai_list': List[Snssai],
            'target_nsi_list': List[str],
            'target_nf_set_id': str,
            'target_nf_service_set_id': str,
            'hnrf_access_token_uri': str,
            'source_nf_instance_id': str
        }

        self.attribute_map = {
            'grant_type': 'grant_type',
            'nf_instance_id': 'nfInstanceId',
            'nf_type': 'nfType',
            'target_nf_type': 'targetNfType',
            'scope': 'scope',
            'target_nf_instance_id': 'targetNfInstanceId',
            'requester_plmn': 'requesterPlmn',
            'requester_plmn_list': 'requesterPlmnList',
            'requester_snssai_list': 'requesterSnssaiList',
            'requester_fqdn': 'requesterFqdn',
            'requester_snpn_list': 'requesterSnpnList',
            'target_plmn': 'targetPlmn',
            'target_snpn': 'targetSnpn',
            'target_snssai_list': 'targetSnssaiList',
            'target_nsi_list': 'targetNsiList',
            'target_nf_set_id': 'targetNfSetId',
            'target_nf_service_set_id': 'targetNfServiceSetId',
            'hnrf_access_token_uri': 'hnrfAccessTokenUri',
            'source_nf_instance_id': 'sourceNfInstanceId'
        }

        self._grant_type = grant_type
        self._nf_instance_id = nf_instance_id
        self._nf_type = nf_type
        self._target_nf_type = target_nf_type
        self._scope = scope
        self._target_nf_instance_id = target_nf_instance_id
        self._requester_plmn = requester_plmn
        self._requester_plmn_list = requester_plmn_list
        self._requester_snssai_list = requester_snssai_list
        self._requester_fqdn = requester_fqdn
        self._requester_snpn_list = requester_snpn_list
        self._target_plmn = target_plmn
        self._target_snpn = target_snpn
        self._target_snssai_list = target_snssai_list
        self._target_nsi_list = target_nsi_list
        self._target_nf_set_id = target_nf_set_id
        self._target_nf_service_set_id = target_nf_service_set_id
        self._hnrf_access_token_uri = hnrf_access_token_uri
        self._source_nf_instance_id = source_nf_instance_id

    @classmethod
    def from_dict(cls, dikt) -> 'AccessTokenReq1':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AccessTokenReq_1 of this AccessTokenReq1.  # noqa: E501
        :rtype: AccessTokenReq1
        """
        return util.deserialize_model(dikt, cls)

    @property
    def grant_type(self) -> str:
        """Gets the grant_type of this AccessTokenReq1.


        :return: The grant_type of this AccessTokenReq1.
        :rtype: str
        """
        return self._grant_type

    @grant_type.setter
    def grant_type(self, grant_type: str):
        """Sets the grant_type of this AccessTokenReq1.


        :param grant_type: The grant_type of this AccessTokenReq1.
        :type grant_type: str
        """
        allowed_values = ["client_credentials"]  # noqa: E501
        if grant_type not in allowed_values:
            raise ValueError(
                "Invalid value for `grant_type` ({0}), must be one of {1}"
                .format(grant_type, allowed_values)
            )

        self._grant_type = grant_type

    @property
    def nf_instance_id(self) -> str:
        """Gets the nf_instance_id of this AccessTokenReq1.

        String uniquely identifying a NF instance. The format of the NF Instance ID shall be a  Universally Unique Identifier (UUID) version 4, as described in IETF RFC 4122.    # noqa: E501

        :return: The nf_instance_id of this AccessTokenReq1.
        :rtype: str
        """
        return self._nf_instance_id

    @nf_instance_id.setter
    def nf_instance_id(self, nf_instance_id: str):
        """Sets the nf_instance_id of this AccessTokenReq1.

        String uniquely identifying a NF instance. The format of the NF Instance ID shall be a  Universally Unique Identifier (UUID) version 4, as described in IETF RFC 4122.    # noqa: E501

        :param nf_instance_id: The nf_instance_id of this AccessTokenReq1.
        :type nf_instance_id: str
        """
        if nf_instance_id is None:
            raise ValueError("Invalid value for `nf_instance_id`, must not be `None`")  # noqa: E501

        self._nf_instance_id = nf_instance_id

    @property
    def nf_type(self) -> NFType:
        """Gets the nf_type of this AccessTokenReq1.


        :return: The nf_type of this AccessTokenReq1.
        :rtype: NFType
        """
        return self._nf_type

    @nf_type.setter
    def nf_type(self, nf_type: NFType):
        """Sets the nf_type of this AccessTokenReq1.


        :param nf_type: The nf_type of this AccessTokenReq1.
        :type nf_type: NFType
        """

        self._nf_type = nf_type

    @property
    def target_nf_type(self) -> NFType:
        """Gets the target_nf_type of this AccessTokenReq1.


        :return: The target_nf_type of this AccessTokenReq1.
        :rtype: NFType
        """
        return self._target_nf_type

    @target_nf_type.setter
    def target_nf_type(self, target_nf_type: NFType):
        """Sets the target_nf_type of this AccessTokenReq1.


        :param target_nf_type: The target_nf_type of this AccessTokenReq1.
        :type target_nf_type: NFType
        """

        self._target_nf_type = target_nf_type

    @property
    def scope(self) -> str:
        """Gets the scope of this AccessTokenReq1.


        :return: The scope of this AccessTokenReq1.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope: str):
        """Sets the scope of this AccessTokenReq1.


        :param scope: The scope of this AccessTokenReq1.
        :type scope: str
        """
        if scope is None:
            raise ValueError("Invalid value for `scope`, must not be `None`")  # noqa: E501
        if scope is not None and not re.search(r'^([a-zA-Z0-9_:-]+)( [a-zA-Z0-9_:-]+)*$', scope):  # noqa: E501
            raise ValueError("Invalid value for `scope`, must be a follow pattern or equal to `/^([a-zA-Z0-9_:-]+)( [a-zA-Z0-9_:-]+)*$/`")  # noqa: E501

        self._scope = scope

    @property
    def target_nf_instance_id(self) -> str:
        """Gets the target_nf_instance_id of this AccessTokenReq1.

        String uniquely identifying a NF instance. The format of the NF Instance ID shall be a  Universally Unique Identifier (UUID) version 4, as described in IETF RFC 4122.    # noqa: E501

        :return: The target_nf_instance_id of this AccessTokenReq1.
        :rtype: str
        """
        return self._target_nf_instance_id

    @target_nf_instance_id.setter
    def target_nf_instance_id(self, target_nf_instance_id: str):
        """Sets the target_nf_instance_id of this AccessTokenReq1.

        String uniquely identifying a NF instance. The format of the NF Instance ID shall be a  Universally Unique Identifier (UUID) version 4, as described in IETF RFC 4122.    # noqa: E501

        :param target_nf_instance_id: The target_nf_instance_id of this AccessTokenReq1.
        :type target_nf_instance_id: str
        """

        self._target_nf_instance_id = target_nf_instance_id

    @property
    def requester_plmn(self) -> PlmnId:
        """Gets the requester_plmn of this AccessTokenReq1.


        :return: The requester_plmn of this AccessTokenReq1.
        :rtype: PlmnId
        """
        return self._requester_plmn

    @requester_plmn.setter
    def requester_plmn(self, requester_plmn: PlmnId):
        """Sets the requester_plmn of this AccessTokenReq1.


        :param requester_plmn: The requester_plmn of this AccessTokenReq1.
        :type requester_plmn: PlmnId
        """

        self._requester_plmn = requester_plmn

    @property
    def requester_plmn_list(self) -> List[PlmnId]:
        """Gets the requester_plmn_list of this AccessTokenReq1.


        :return: The requester_plmn_list of this AccessTokenReq1.
        :rtype: List[PlmnId]
        """
        return self._requester_plmn_list

    @requester_plmn_list.setter
    def requester_plmn_list(self, requester_plmn_list: List[PlmnId]):
        """Sets the requester_plmn_list of this AccessTokenReq1.


        :param requester_plmn_list: The requester_plmn_list of this AccessTokenReq1.
        :type requester_plmn_list: List[PlmnId]
        """
        if requester_plmn_list is not None and len(requester_plmn_list) < 2:
            raise ValueError("Invalid value for `requester_plmn_list`, number of items must be greater than or equal to `2`")  # noqa: E501

        self._requester_plmn_list = requester_plmn_list

    @property
    def requester_snssai_list(self) -> List[Snssai]:
        """Gets the requester_snssai_list of this AccessTokenReq1.


        :return: The requester_snssai_list of this AccessTokenReq1.
        :rtype: List[Snssai]
        """
        return self._requester_snssai_list

    @requester_snssai_list.setter
    def requester_snssai_list(self, requester_snssai_list: List[Snssai]):
        """Sets the requester_snssai_list of this AccessTokenReq1.


        :param requester_snssai_list: The requester_snssai_list of this AccessTokenReq1.
        :type requester_snssai_list: List[Snssai]
        """
        if requester_snssai_list is not None and len(requester_snssai_list) < 1:
            raise ValueError("Invalid value for `requester_snssai_list`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._requester_snssai_list = requester_snssai_list

    @property
    def requester_fqdn(self) -> str:
        """Gets the requester_fqdn of this AccessTokenReq1.

        Fully Qualified Domain Name  # noqa: E501

        :return: The requester_fqdn of this AccessTokenReq1.
        :rtype: str
        """
        return self._requester_fqdn

    @requester_fqdn.setter
    def requester_fqdn(self, requester_fqdn: str):
        """Sets the requester_fqdn of this AccessTokenReq1.

        Fully Qualified Domain Name  # noqa: E501

        :param requester_fqdn: The requester_fqdn of this AccessTokenReq1.
        :type requester_fqdn: str
        """
        if requester_fqdn is not None and len(requester_fqdn) > 253:
            raise ValueError("Invalid value for `requester_fqdn`, length must be less than or equal to `253`")  # noqa: E501
        if requester_fqdn is not None and len(requester_fqdn) < 4:
            raise ValueError("Invalid value for `requester_fqdn`, length must be greater than or equal to `4`")  # noqa: E501
        if requester_fqdn is not None and not re.search(r'^([0-9A-Za-z]([-0-9A-Za-z]{0,61}[0-9A-Za-z])?\.)+[A-Za-z]{2,63}\.?$', requester_fqdn):  # noqa: E501
            raise ValueError("Invalid value for `requester_fqdn`, must be a follow pattern or equal to `/^([0-9A-Za-z]([-0-9A-Za-z]{0,61}[0-9A-Za-z])?\.)+[A-Za-z]{2,63}\.?$/`")  # noqa: E501

        self._requester_fqdn = requester_fqdn

    @property
    def requester_snpn_list(self) -> List[PlmnIdNid]:
        """Gets the requester_snpn_list of this AccessTokenReq1.


        :return: The requester_snpn_list of this AccessTokenReq1.
        :rtype: List[PlmnIdNid]
        """
        return self._requester_snpn_list

    @requester_snpn_list.setter
    def requester_snpn_list(self, requester_snpn_list: List[PlmnIdNid]):
        """Sets the requester_snpn_list of this AccessTokenReq1.


        :param requester_snpn_list: The requester_snpn_list of this AccessTokenReq1.
        :type requester_snpn_list: List[PlmnIdNid]
        """
        if requester_snpn_list is not None and len(requester_snpn_list) < 1:
            raise ValueError("Invalid value for `requester_snpn_list`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._requester_snpn_list = requester_snpn_list

    @property
    def target_plmn(self) -> PlmnId:
        """Gets the target_plmn of this AccessTokenReq1.


        :return: The target_plmn of this AccessTokenReq1.
        :rtype: PlmnId
        """
        return self._target_plmn

    @target_plmn.setter
    def target_plmn(self, target_plmn: PlmnId):
        """Sets the target_plmn of this AccessTokenReq1.


        :param target_plmn: The target_plmn of this AccessTokenReq1.
        :type target_plmn: PlmnId
        """

        self._target_plmn = target_plmn

    @property
    def target_snpn(self) -> PlmnIdNid:
        """Gets the target_snpn of this AccessTokenReq1.


        :return: The target_snpn of this AccessTokenReq1.
        :rtype: PlmnIdNid
        """
        return self._target_snpn

    @target_snpn.setter
    def target_snpn(self, target_snpn: PlmnIdNid):
        """Sets the target_snpn of this AccessTokenReq1.


        :param target_snpn: The target_snpn of this AccessTokenReq1.
        :type target_snpn: PlmnIdNid
        """

        self._target_snpn = target_snpn

    @property
    def target_snssai_list(self) -> List[Snssai]:
        """Gets the target_snssai_list of this AccessTokenReq1.


        :return: The target_snssai_list of this AccessTokenReq1.
        :rtype: List[Snssai]
        """
        return self._target_snssai_list

    @target_snssai_list.setter
    def target_snssai_list(self, target_snssai_list: List[Snssai]):
        """Sets the target_snssai_list of this AccessTokenReq1.


        :param target_snssai_list: The target_snssai_list of this AccessTokenReq1.
        :type target_snssai_list: List[Snssai]
        """
        if target_snssai_list is not None and len(target_snssai_list) < 1:
            raise ValueError("Invalid value for `target_snssai_list`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._target_snssai_list = target_snssai_list

    @property
    def target_nsi_list(self) -> List[str]:
        """Gets the target_nsi_list of this AccessTokenReq1.


        :return: The target_nsi_list of this AccessTokenReq1.
        :rtype: List[str]
        """
        return self._target_nsi_list

    @target_nsi_list.setter
    def target_nsi_list(self, target_nsi_list: List[str]):
        """Sets the target_nsi_list of this AccessTokenReq1.


        :param target_nsi_list: The target_nsi_list of this AccessTokenReq1.
        :type target_nsi_list: List[str]
        """
        if target_nsi_list is not None and len(target_nsi_list) < 1:
            raise ValueError("Invalid value for `target_nsi_list`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._target_nsi_list = target_nsi_list

    @property
    def target_nf_set_id(self) -> str:
        """Gets the target_nf_set_id of this AccessTokenReq1.

        NF Set Identifier (see clause 28.12 of 3GPP TS 23.003), formatted as the following string \"set<Set ID>.<nftype>set.5gc.mnc<MNC>.mcc<MCC>\", or  \"set<SetID>.<NFType>set.5gc.nid<NID>.mnc<MNC>.mcc<MCC>\" with  <MCC> encoded as defined in clause 5.4.2 (\"Mcc\" data type definition)  <MNC> encoding the Mobile Network Code part of the PLMN, comprising 3 digits.    If there are only 2 significant digits in the MNC, one \"0\" digit shall be inserted    at the left side to fill the 3 digits coding of MNC.  Pattern: '^[0-9]{3}$' <NFType> encoded as a value defined in Table 6.1.6.3.3-1 of 3GPP TS 29.510 but    with lower case characters <Set ID> encoded as a string of characters consisting of    alphabetic characters (A-Z and a-z), digits (0-9) and/or the hyphen (-) and that    shall end with either an alphabetic character or a digit.    # noqa: E501

        :return: The target_nf_set_id of this AccessTokenReq1.
        :rtype: str
        """
        return self._target_nf_set_id

    @target_nf_set_id.setter
    def target_nf_set_id(self, target_nf_set_id: str):
        """Sets the target_nf_set_id of this AccessTokenReq1.

        NF Set Identifier (see clause 28.12 of 3GPP TS 23.003), formatted as the following string \"set<Set ID>.<nftype>set.5gc.mnc<MNC>.mcc<MCC>\", or  \"set<SetID>.<NFType>set.5gc.nid<NID>.mnc<MNC>.mcc<MCC>\" with  <MCC> encoded as defined in clause 5.4.2 (\"Mcc\" data type definition)  <MNC> encoding the Mobile Network Code part of the PLMN, comprising 3 digits.    If there are only 2 significant digits in the MNC, one \"0\" digit shall be inserted    at the left side to fill the 3 digits coding of MNC.  Pattern: '^[0-9]{3}$' <NFType> encoded as a value defined in Table 6.1.6.3.3-1 of 3GPP TS 29.510 but    with lower case characters <Set ID> encoded as a string of characters consisting of    alphabetic characters (A-Z and a-z), digits (0-9) and/or the hyphen (-) and that    shall end with either an alphabetic character or a digit.    # noqa: E501

        :param target_nf_set_id: The target_nf_set_id of this AccessTokenReq1.
        :type target_nf_set_id: str
        """

        self._target_nf_set_id = target_nf_set_id

    @property
    def target_nf_service_set_id(self) -> str:
        """Gets the target_nf_service_set_id of this AccessTokenReq1.

        NF Service Set Identifier (see clause 28.12 of 3GPP TS 23.003) formatted as the following  string \"set<Set ID>.sn<Service Name>.nfi<NF Instance ID>.5gc.mnc<MNC>.mcc<MCC>\", or  \"set<SetID>.sn<ServiceName>.nfi<NFInstanceID>.5gc.nid<NID>.mnc<MNC>.mcc<MCC>\" with  <MCC> encoded as defined in clause 5.4.2 (\"Mcc\" data type definition)   <MNC> encoding the Mobile Network Code part of the PLMN, comprising 3 digits.    If there are only 2 significant digits in the MNC, one \"0\" digit shall be inserted    at the left side to fill the 3 digits coding of MNC.  Pattern: '^[0-9]{3}$' <NID> encoded as defined in clause 5.4.2 (\"Nid\" data type definition)  <NFInstanceId> encoded as defined in clause 5.3.2  <ServiceName> encoded as defined in 3GPP TS 29.510  <Set ID> encoded as a string of characters consisting of alphabetic    characters (A-Z and a-z), digits (0-9) and/or the hyphen (-) and that shall end    with either an alphabetic character or a digit.   # noqa: E501

        :return: The target_nf_service_set_id of this AccessTokenReq1.
        :rtype: str
        """
        return self._target_nf_service_set_id

    @target_nf_service_set_id.setter
    def target_nf_service_set_id(self, target_nf_service_set_id: str):
        """Sets the target_nf_service_set_id of this AccessTokenReq1.

        NF Service Set Identifier (see clause 28.12 of 3GPP TS 23.003) formatted as the following  string \"set<Set ID>.sn<Service Name>.nfi<NF Instance ID>.5gc.mnc<MNC>.mcc<MCC>\", or  \"set<SetID>.sn<ServiceName>.nfi<NFInstanceID>.5gc.nid<NID>.mnc<MNC>.mcc<MCC>\" with  <MCC> encoded as defined in clause 5.4.2 (\"Mcc\" data type definition)   <MNC> encoding the Mobile Network Code part of the PLMN, comprising 3 digits.    If there are only 2 significant digits in the MNC, one \"0\" digit shall be inserted    at the left side to fill the 3 digits coding of MNC.  Pattern: '^[0-9]{3}$' <NID> encoded as defined in clause 5.4.2 (\"Nid\" data type definition)  <NFInstanceId> encoded as defined in clause 5.3.2  <ServiceName> encoded as defined in 3GPP TS 29.510  <Set ID> encoded as a string of characters consisting of alphabetic    characters (A-Z and a-z), digits (0-9) and/or the hyphen (-) and that shall end    with either an alphabetic character or a digit.   # noqa: E501

        :param target_nf_service_set_id: The target_nf_service_set_id of this AccessTokenReq1.
        :type target_nf_service_set_id: str
        """

        self._target_nf_service_set_id = target_nf_service_set_id

    @property
    def hnrf_access_token_uri(self) -> str:
        """Gets the hnrf_access_token_uri of this AccessTokenReq1.

        String providing an URI formatted according to RFC 3986.  # noqa: E501

        :return: The hnrf_access_token_uri of this AccessTokenReq1.
        :rtype: str
        """
        return self._hnrf_access_token_uri

    @hnrf_access_token_uri.setter
    def hnrf_access_token_uri(self, hnrf_access_token_uri: str):
        """Sets the hnrf_access_token_uri of this AccessTokenReq1.

        String providing an URI formatted according to RFC 3986.  # noqa: E501

        :param hnrf_access_token_uri: The hnrf_access_token_uri of this AccessTokenReq1.
        :type hnrf_access_token_uri: str
        """

        self._hnrf_access_token_uri = hnrf_access_token_uri

    @property
    def source_nf_instance_id(self) -> str:
        """Gets the source_nf_instance_id of this AccessTokenReq1.

        String uniquely identifying a NF instance. The format of the NF Instance ID shall be a  Universally Unique Identifier (UUID) version 4, as described in IETF RFC 4122.    # noqa: E501

        :return: The source_nf_instance_id of this AccessTokenReq1.
        :rtype: str
        """
        return self._source_nf_instance_id

    @source_nf_instance_id.setter
    def source_nf_instance_id(self, source_nf_instance_id: str):
        """Sets the source_nf_instance_id of this AccessTokenReq1.

        String uniquely identifying a NF instance. The format of the NF Instance ID shall be a  Universally Unique Identifier (UUID) version 4, as described in IETF RFC 4122.    # noqa: E501

        :param source_nf_instance_id: The source_nf_instance_id of this AccessTokenReq1.
        :type source_nf_instance_id: str
        """

        self._source_nf_instance_id = source_nf_instance_id
