#!/bin/bash
source $(dirname "$(readlink -f "$0")")/variables.sh

help() {
  echo "Usage: $1 <options>"
  echo "       -y : Force uninstall component"
  echo "       -h : show this help"
  exit 1
}

export FORCE=0
# Read params
while getopts ":yh" opt; do
  case $opt in
    y)
      FORCE=1
      ;;
    h)
      help
      ;;
    \?)
      echo "Not valid option: -$OPTARG" >&2
      help
      ;;
    :)
      echo "The -$OPTARG option requires an argument." >&2
      help
      ;;
  esac
done

if [ "$FORCE" == "0" ]; then
    # Function to display a warning message
    warning_message() {
        echo "WARNING: This uninstallation process is irreversible."
        echo "All data associated with CAPIF service will be permanently lost."
        echo "Are you sure you want to continue? (yes/no)"
    }

    # Display the warning message
    warning_message

    # Read the user input
    read -r USER_INPUT

    # Check if the user confirmed the uninstallation
    if [ "$USER_INPUT" != "yes" ]; then
        echo "Uninstallation aborted by the user."
        exit 1
    fi
else
    echo "Forced uninstall"
fi
# Proceed with the uninstallation process
echo "Proceeding with uninstallation..."

helm $KUBECONFIG uninstall $MONITORING_SERVICE_NAME -n $MONITORING_NAMESPACE || echo "$MONITORING_SERVICE_NAME is not present"
kubectl $KUBECONFIG delete namespace $MONITORING_NAMESPACE || echo "$MONITORING_NAMESPACE is not present"

echo "Uninstallation complete. The Monitoring service and all associated data have been removed."