# Helm monitoring stack

![Version: 1.0.0](https://img.shields.io/badge/Version-1.0.0-informational?style=flat-square) ![Type: application](https://img.shields.io/badge/Type-application-informational?style=flat-square) ![AppVersion: 1.0.0](https://img.shields.io/badge/AppVersion-1.0.0-informational?style=flat-square)

A Helm chart for Kubernetes monitoring stack

## Requirements

| Repository | Name | Version |
|------------|------|---------|
|  | grafana | * |
|  | prometheus | * |
|  | skooner | * |
| https://charts.bitnami.com/bitnami | metrics-server | 6.9.3 |

## Values

| Key | Type | Default | Description |
|-----|------|---------|-------------|
| grafana.enabled | bool | `true` |  |
| grafana.env.prometheusUrl | string | `"http://monitoring-prometheus.monitoring.svc.cluster.local:9090"` |  |
| grafana.ingress.enable | bool | `true` |  |
| grafana.ingress.hosts[0].host | string | `"grafana-dt.test.int"` |  |
| grafana.ingress.hosts[0].paths[0].path | string | `"/"` |  |
| grafana.ingress.hosts[0].paths[0].pathType | string | `"Prefix"` |  |
| grafana.service.type | string | `"ClusterIP"` |  |
| metrics-server.apiService.create | bool | `true` |  |
| metrics-server.enabled | bool | `false` |  |
| metrics-server.extraArgs[0] | string | `"--kubelet-insecure-tls=true"` |  |
| metrics-server.extraArgs[1] | string | `"--kubelet-preferred-address-types=InternalIP"` |  |
| prometheus.enabled | bool | `true` |  |
| prometheus.ingress.enabled | bool | `true` |  |
| prometheus.ingress.hosts[0].host | string | `"prometheus-dt.test.int"` |  |
| prometheus.ingress.hosts[0].paths[0].path | string | `"/"` |  |
| prometheus.ingress.hosts[0].paths[0].pathType | string | `"Prefix"` |  |
| prometheus.service.type | string | `"ClusterIP"` |  |
| prometheus.serviceAccount.create | bool | `false` |  |
| skooner.enabled | bool | `true` |  |
| skooner.ingress.className | string | `"nginx"` |  |
| skooner.ingress.enabled | bool | `true` |  |
| skooner.ingress.hosts[0].host | string | `"skooner-dt.test.int"` |  |
| skooner.ingress.hosts[0].paths[0].path | string | `"/"` |  |
| skooner.ingress.hosts[0].paths[0].pathType | string | `"Prefix"` |  |
| skooner.service.type | string | `"ClusterIP"` |  |

----------------------------------------------
Autogenerated from chart metadata using [helm-docs v1.13.1](https://github.com/norwoodj/helm-docs/releases/v1.13.1)
