from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_routing_info.models.base_model import Model
from capif_routing_info.models.gad_shape import GADShape
from capif_routing_info.models.geographical_coordinates import GeographicalCoordinates
from capif_routing_info.models.supported_gad_shapes import SupportedGADShapes
from capif_routing_info import util

from capif_routing_info.models.gad_shape import GADShape  # noqa: E501
from capif_routing_info.models.geographical_coordinates import GeographicalCoordinates  # noqa: E501
from capif_routing_info.models.supported_gad_shapes import SupportedGADShapes  # noqa: E501

class Polygon(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, shape=None, point_list=None):  # noqa: E501
        """Polygon - a model defined in OpenAPI

        :param shape: The shape of this Polygon.  # noqa: E501
        :type shape: SupportedGADShapes
        :param point_list: The point_list of this Polygon.  # noqa: E501
        :type point_list: List[GeographicalCoordinates]
        """
        self.openapi_types = {
            'shape': SupportedGADShapes,
            'point_list': List[GeographicalCoordinates]
        }

        self.attribute_map = {
            'shape': 'shape',
            'point_list': 'pointList'
        }

        self._shape = shape
        self._point_list = point_list

    @classmethod
    def from_dict(cls, dikt) -> 'Polygon':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Polygon of this Polygon.  # noqa: E501
        :rtype: Polygon
        """
        return util.deserialize_model(dikt, cls)

    @property
    def shape(self) -> SupportedGADShapes:
        """Gets the shape of this Polygon.


        :return: The shape of this Polygon.
        :rtype: SupportedGADShapes
        """
        return self._shape

    @shape.setter
    def shape(self, shape: SupportedGADShapes):
        """Sets the shape of this Polygon.


        :param shape: The shape of this Polygon.
        :type shape: SupportedGADShapes
        """
        if shape is None:
            raise ValueError("Invalid value for `shape`, must not be `None`")  # noqa: E501

        self._shape = shape

    @property
    def point_list(self) -> List[GeographicalCoordinates]:
        """Gets the point_list of this Polygon.

        List of points.  # noqa: E501

        :return: The point_list of this Polygon.
        :rtype: List[GeographicalCoordinates]
        """
        return self._point_list

    @point_list.setter
    def point_list(self, point_list: List[GeographicalCoordinates]):
        """Sets the point_list of this Polygon.

        List of points.  # noqa: E501

        :param point_list: The point_list of this Polygon.
        :type point_list: List[GeographicalCoordinates]
        """
        if point_list is None:
            raise ValueError("Invalid value for `point_list`, must not be `None`")  # noqa: E501
        if point_list is not None and len(point_list) > 15:
            raise ValueError("Invalid value for `point_list`, number of items must be less than or equal to `15`")  # noqa: E501
        if point_list is not None and len(point_list) < 3:
            raise ValueError("Invalid value for `point_list`, number of items must be greater than or equal to `3`")  # noqa: E501

        self._point_list = point_list
