import json

from flask import current_app, Response

from .resources import Resource
from .responses import internal_server_error
from ..encoder import CustomJSONEncoder
from ..models.problem_details import ProblemDetails
from ..util import serialize_clean_camel_case


class ControlAccess(Resource):

    def validate_user_cert(self, api_provider_id, cert_signature):

        cert_col = self.db.get_col_by_name(self.db.certs_col)

        try:
            my_query = {'provider_id':api_provider_id, "role": "AMF"}
            cert_entry = cert_col.find_one(my_query)

            if cert_entry is not None:
                if cert_entry["cert_signature"] != cert_signature:
                    prob = ProblemDetails(title="Unauthorized", detail="User not authorized", cause="You are not the owner of this resource")
                    prob = serialize_clean_camel_case(prob)
                    return Response(json.dumps(prob, cls=CustomJSONEncoder), status=401, mimetype="application/json")

        except Exception as e:
            exception = "An exception occurred in validate amf"
            current_app.logger.error(exception + "::" + str(e))
            return internal_server_error(detail=exception, cause=str(e))