# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_events.models.base_model_ import Model
from capif_events.models.routing_rule import RoutingRule
from capif_events import util

from capif_events.models.routing_rule import RoutingRule  # noqa: E501

class TopologyHiding(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_id=None, routing_rules=None):  # noqa: E501
        """TopologyHiding - a model defined in OpenAPI

        :param api_id: The api_id of this TopologyHiding.  # noqa: E501
        :type api_id: str
        :param routing_rules: The routing_rules of this TopologyHiding.  # noqa: E501
        :type routing_rules: List[RoutingRule]
        """
        self.openapi_types = {
            'api_id': str,
            'routing_rules': List[RoutingRule]
        }

        self.attribute_map = {
            'api_id': 'apiId',
            'routing_rules': 'routingRules'
        }

        self._api_id = api_id
        self._routing_rules = routing_rules

    @classmethod
    def from_dict(cls, dikt) -> 'TopologyHiding':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The TopologyHiding of this TopologyHiding.  # noqa: E501
        :rtype: TopologyHiding
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_id(self):
        """Gets the api_id of this TopologyHiding.


        :return: The api_id of this TopologyHiding.
        :rtype: str
        """
        return self._api_id

    @api_id.setter
    def api_id(self, api_id):
        """Sets the api_id of this TopologyHiding.


        :param api_id: The api_id of this TopologyHiding.
        :type api_id: str
        """
        if api_id is None:
            raise ValueError("Invalid value for `api_id`, must not be `None`")  # noqa: E501

        self._api_id = api_id

    @property
    def routing_rules(self):
        """Gets the routing_rules of this TopologyHiding.


        :return: The routing_rules of this TopologyHiding.
        :rtype: List[RoutingRule]
        """
        return self._routing_rules

    @routing_rules.setter
    def routing_rules(self, routing_rules):
        """Sets the routing_rules of this TopologyHiding.


        :param routing_rules: The routing_rules of this TopologyHiding.
        :type routing_rules: List[RoutingRule]
        """
        if routing_rules is None:
            raise ValueError("Invalid value for `routing_rules`, must not be `None`")  # noqa: E501
        if routing_rules is not None and len(routing_rules) < 1:
            raise ValueError("Invalid value for `routing_rules`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._routing_rules = routing_rules
