from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_routing_info.models.base_model import Model
from capif_routing_info.models.custom_operation import CustomOperation
from capif_routing_info.models.resource import Resource
from capif_routing_info import util

from capif_routing_info.models.custom_operation import CustomOperation  # noqa: E501
from capif_routing_info.models.resource import Resource  # noqa: E501

class Version(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_version=None, expiry=None, resources=None, cust_operations=None):  # noqa: E501
        """Version - a model defined in OpenAPI

        :param api_version: The api_version of this Version.  # noqa: E501
        :type api_version: str
        :param expiry: The expiry of this Version.  # noqa: E501
        :type expiry: datetime
        :param resources: The resources of this Version.  # noqa: E501
        :type resources: List[Resource]
        :param cust_operations: The cust_operations of this Version.  # noqa: E501
        :type cust_operations: List[CustomOperation]
        """
        self.openapi_types = {
            'api_version': str,
            'expiry': datetime,
            'resources': List[Resource],
            'cust_operations': List[CustomOperation]
        }

        self.attribute_map = {
            'api_version': 'apiVersion',
            'expiry': 'expiry',
            'resources': 'resources',
            'cust_operations': 'custOperations'
        }

        self._api_version = api_version
        self._expiry = expiry
        self._resources = resources
        self._cust_operations = cust_operations

    @classmethod
    def from_dict(cls, dikt) -> 'Version':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The Version of this Version.  # noqa: E501
        :rtype: Version
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_version(self) -> str:
        """Gets the api_version of this Version.

        API major version in URI (e.g. v1)  # noqa: E501

        :return: The api_version of this Version.
        :rtype: str
        """
        return self._api_version

    @api_version.setter
    def api_version(self, api_version: str):
        """Sets the api_version of this Version.

        API major version in URI (e.g. v1)  # noqa: E501

        :param api_version: The api_version of this Version.
        :type api_version: str
        """
        if api_version is None:
            raise ValueError("Invalid value for `api_version`, must not be `None`")  # noqa: E501

        self._api_version = api_version

    @property
    def expiry(self) -> datetime:
        """Gets the expiry of this Version.

        string with format \"date-time\" as defined in OpenAPI.  # noqa: E501

        :return: The expiry of this Version.
        :rtype: datetime
        """
        return self._expiry

    @expiry.setter
    def expiry(self, expiry: datetime):
        """Sets the expiry of this Version.

        string with format \"date-time\" as defined in OpenAPI.  # noqa: E501

        :param expiry: The expiry of this Version.
        :type expiry: datetime
        """

        self._expiry = expiry

    @property
    def resources(self) -> List[Resource]:
        """Gets the resources of this Version.

        Resources supported by the API.  # noqa: E501

        :return: The resources of this Version.
        :rtype: List[Resource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources: List[Resource]):
        """Sets the resources of this Version.

        Resources supported by the API.  # noqa: E501

        :param resources: The resources of this Version.
        :type resources: List[Resource]
        """
        if resources is not None and len(resources) < 1:
            raise ValueError("Invalid value for `resources`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._resources = resources

    @property
    def cust_operations(self) -> List[CustomOperation]:
        """Gets the cust_operations of this Version.

        Custom operations without resource association.  # noqa: E501

        :return: The cust_operations of this Version.
        :rtype: List[CustomOperation]
        """
        return self._cust_operations

    @cust_operations.setter
    def cust_operations(self, cust_operations: List[CustomOperation]):
        """Sets the cust_operations of this Version.

        Custom operations without resource association.  # noqa: E501

        :param cust_operations: The cust_operations of this Version.
        :type cust_operations: List[CustomOperation]
        """
        if cust_operations is not None and len(cust_operations) < 1:
            raise ValueError("Invalid value for `cust_operations`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._cust_operations = cust_operations
