#!/usr/bin/env python3

from flask import Blueprint, request, current_app, jsonify
from core.helper_operations import HelperOperations
from config import Config

config = Config().get_config()

helper_routes = Blueprint("helper_routes", __name__)
helper_operation = HelperOperations()

@helper_routes.route("/helper/getInvokers", methods=["GET"])
def getInvokers():
    uuid = request.args.get('uuid')
    invoker_id = request.args.get('api_invoker_id')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    sort_order = request.args.get('sort_order')
    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"uuid: {uuid}, invoker_id: {invoker_id}, page: {page}, page_size: {page_size}, sort_order: {sort_order}")

    return helper_operation.get_invokers(uuid, invoker_id, page, page_size, sort_order)

@helper_routes.route("/helper/getProviders", methods=["GET"])
def getProviders():
    uuid = request.args.get('uuid')
    provider_id = request.args.get('api_prov_dom_id')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    sort_order = request.args.get('sort_order')

    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"uuid: {uuid}, provider_id: {provider_id}, page: {page}, page_size: {page_size}, sort_order: {sort_order}")

    return helper_operation.get_providers(uuid, provider_id, page, page_size, sort_order)


@helper_routes.route("/helper/getServices", methods=["GET"])
def getServices():
    service_id = request.args.get('service_id')
    apf_id = request.args.get('apf_id')
    api_name = request.args.get('api_name')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    sort_order = request.args.get('sort_order')
    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"service_id: {service_id}, apf_id: {apf_id}, api_name: {api_name}, page: {page}, page_size: {page_size}, sort_order: {sort_order}")

    return helper_operation.get_services(service_id, apf_id, api_name, page, page_size, sort_order)

@helper_routes.route("/helper/getSecurity", methods=["GET"])
def getSecurity():
    invoker_id = request.args.get('invoker_id')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"invoker_id: {invoker_id}, page: {page}, page_size: {page_size} ")

    return helper_operation.get_security(invoker_id, page, page_size)

@helper_routes.route("/helper/getEvents", methods=["GET"])
def getEvents():
    subscriber_id = request.args.get('subscriber_id')
    subscription_id = request.args.get('subscription_id')
    page_size = request.args.get('page_size')
    page = request.args.get('page')
    if page_size:
        page_size = int(page_size)
        if page_size < 0:
            return jsonify(message="The value of the page_size parameter must be greater than 0"), 400
    if page:
        page = int(page)
        if page < 0:
            return jsonify(message="The value of the page parameter must be greater than 0"), 400
    
    current_app.logger.debug(f"subscriber_id: {subscriber_id}, subscription_id: {subscription_id}, page: {page}, page_size: {page_size} ")

    return helper_operation.get_events(subscriber_id, subscription_id, page, page_size)


@helper_routes.route("/helper/deleteEntities/<uuid>", methods=["DELETE"])
def deleteUserEntities(uuid):
    return helper_operation.remove_entities(uuid)
