# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_security.models.base_model_ import Model
from capif_security.models.cause import Cause
from capif_security import util

from capif_security.models.cause import Cause  # noqa: E501

class SecurityNotification(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, api_invoker_id=None, aef_id=None, api_ids=None, cause=None):  # noqa: E501
        """SecurityNotification - a model defined in OpenAPI

        :param api_invoker_id: The api_invoker_id of this SecurityNotification.  # noqa: E501
        :type api_invoker_id: str
        :param aef_id: The aef_id of this SecurityNotification.  # noqa: E501
        :type aef_id: str
        :param api_ids: The api_ids of this SecurityNotification.  # noqa: E501
        :type api_ids: List[str]
        :param cause: The cause of this SecurityNotification.  # noqa: E501
        :type cause: Cause
        """
        self.openapi_types = {
            'api_invoker_id': str,
            'aef_id': str,
            'api_ids': List[str],
            'cause': Cause
        }

        self.attribute_map = {
            'api_invoker_id': 'apiInvokerId',
            'aef_id': 'aefId',
            'api_ids': 'apiIds',
            'cause': 'cause'
        }

        self._api_invoker_id = api_invoker_id
        self._aef_id = aef_id
        self._api_ids = api_ids
        self._cause = cause

    @classmethod
    def from_dict(cls, dikt) -> 'SecurityNotification':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The SecurityNotification of this SecurityNotification.  # noqa: E501
        :rtype: SecurityNotification
        """
        return util.deserialize_model(dikt, cls)

    @property
    def api_invoker_id(self):
        """Gets the api_invoker_id of this SecurityNotification.

        String identifying the API invoker assigned by the CAPIF core function.  # noqa: E501

        :return: The api_invoker_id of this SecurityNotification.
        :rtype: str
        """
        return self._api_invoker_id

    @api_invoker_id.setter
    def api_invoker_id(self, api_invoker_id):
        """Sets the api_invoker_id of this SecurityNotification.

        String identifying the API invoker assigned by the CAPIF core function.  # noqa: E501

        :param api_invoker_id: The api_invoker_id of this SecurityNotification.
        :type api_invoker_id: str
        """
        if api_invoker_id is None:
            raise ValueError("Invalid value for `api_invoker_id`, must not be `None`")  # noqa: E501

        self._api_invoker_id = api_invoker_id

    @property
    def aef_id(self):
        """Gets the aef_id of this SecurityNotification.

        String identifying the AEF.  # noqa: E501

        :return: The aef_id of this SecurityNotification.
        :rtype: str
        """
        return self._aef_id

    @aef_id.setter
    def aef_id(self, aef_id):
        """Sets the aef_id of this SecurityNotification.

        String identifying the AEF.  # noqa: E501

        :param aef_id: The aef_id of this SecurityNotification.
        :type aef_id: str
        """

        self._aef_id = aef_id

    @property
    def api_ids(self):
        """Gets the api_ids of this SecurityNotification.

        Identifier of the service API  # noqa: E501

        :return: The api_ids of this SecurityNotification.
        :rtype: List[str]
        """
        return self._api_ids

    @api_ids.setter
    def api_ids(self, api_ids):
        """Sets the api_ids of this SecurityNotification.

        Identifier of the service API  # noqa: E501

        :param api_ids: The api_ids of this SecurityNotification.
        :type api_ids: List[str]
        """
        if api_ids is None:
            raise ValueError("Invalid value for `api_ids`, must not be `None`")  # noqa: E501
        if api_ids is not None and len(api_ids) < 1:
            raise ValueError("Invalid value for `api_ids`, number of items must be greater than or equal to `1`")  # noqa: E501

        self._api_ids = api_ids

    @property
    def cause(self):
        """Gets the cause of this SecurityNotification.


        :return: The cause of this SecurityNotification.
        :rtype: Cause
        """
        return self._cause

    @cause.setter
    def cause(self, cause):
        """Sets the cause of this SecurityNotification.


        :param cause: The cause of this SecurityNotification.
        :type cause: Cause
        """
        if cause is None:
            raise ValueError("Invalid value for `cause`, must not be `None`")  # noqa: E501

        self._cause = cause
