# coding: utf-8

from __future__ import absolute_import
from datetime import date, datetime  # noqa: F401

from typing import List, Dict  # noqa: F401

from capif_security.models.base_model_ import Model
from capif_security.models.access_token_err import AccessTokenErr
from capif_security import util


class AccessTokenReq(Model):
    """NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).

    Do not edit the class manually.
    """

    def __init__(self, grant_type=None, client_id=None, client_secret=None, scope=None):  # noqa: E501
        """AccessTokenReq - a model defined in OpenAPI

        :param grant_type: The grant_type of this AccessTokenReq.  # noqa: E501
        :type grant_type: str
        :param client_id: The client_id of this AccessTokenReq.  # noqa: E501
        :type client_id: str
        :param client_secret: The client_secret of this AccessTokenReq.  # noqa: E501
        :type client_secret: str
        :param scope: The scope of this AccessTokenReq.  # noqa: E501
        :type scope: str
        """
        self.openapi_types = {
            'grant_type': str,
            'client_id': str,
            'client_secret': str,
            'scope': str
        }

        self.attribute_map = {
            'grant_type': 'grant_type',
            'client_id': 'client_id',
            'client_secret': 'client_secret',
            'scope': 'scope'
        }

        self._grant_type = grant_type
        self._client_id = client_id
        self._client_secret = client_secret
        self._scope = scope

    @classmethod
    def from_dict(cls, dikt) -> 'AccessTokenReq':
        """Returns the dict as a model

        :param dikt: A dict.
        :type: dict
        :return: The AccessTokenReq of this AccessTokenReq.  # noqa: E501
        :rtype: AccessTokenReq
        """
        return util.deserialize_model(dikt, cls)

    @property
    def grant_type(self):
        """Gets the grant_type of this AccessTokenReq.


        :return: The grant_type of this AccessTokenReq.
        :rtype: str
        """
        return self._grant_type

    @grant_type.setter
    def grant_type(self, grant_type):
        """Sets the grant_type of this AccessTokenReq.


        :param grant_type: The grant_type of this AccessTokenReq.
        :type grant_type: str
        """
        allowed_values = ["client_credentials"]  # noqa: E501
        if grant_type not in allowed_values:
            raise ValueError(
                "Invalid value for `grant_type` ({0}), must be one of {1}"
                .format(grant_type, allowed_values)
            )

        self._grant_type = grant_type

    @property
    def client_id(self):
        """Gets the client_id of this AccessTokenReq.


        :return: The client_id of this AccessTokenReq.
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """Sets the client_id of this AccessTokenReq.


        :param client_id: The client_id of this AccessTokenReq.
        :type client_id: str
        """
        if client_id is None:
            raise ValueError("Invalid value for `client_id`, must not be `None`")  # noqa: E501

        self._client_id = client_id

    @property
    def client_secret(self):
        """Gets the client_secret of this AccessTokenReq.


        :return: The client_secret of this AccessTokenReq.
        :rtype: str
        """
        return self._client_secret

    @client_secret.setter
    def client_secret(self, client_secret):
        """Sets the client_secret of this AccessTokenReq.


        :param client_secret: The client_secret of this AccessTokenReq.
        :type client_secret: str
        """

        self._client_secret = client_secret

    @property
    def scope(self):
        """Gets the scope of this AccessTokenReq.


        :return: The scope of this AccessTokenReq.
        :rtype: str
        """
        return self._scope

    @scope.setter
    def scope(self, scope):
        """Sets the scope of this AccessTokenReq.


        :param scope: The scope of this AccessTokenReq.
        :type scope: str
        """

        self._scope = scope
